/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;

public class MethodGeneratorProgram
extends ConfigProgram {
    private static final Logger log = Logger.getLogger(MethodGeneratorProgram.class.getName());
    private static final L10N L = new L10N(MethodGeneratorProgram.class);
    private Method _method;
    private ValueGenerator _gen;

    public MethodGeneratorProgram(Method method, ValueGenerator gen) {
        this._method = method;
        this._method.setAccessible(true);
        this._gen = gen;
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    Class<?> getType() {
        return this._method.getParameterTypes()[0];
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) throws ConfigException {
        Class<?> type = this.getType();
        Object value = this._gen.create();
        try {
            this._method.invoke(bean, value);
        }
        catch (InvocationTargetException e) {
            throw new ConfigException(this.location() + e.getCause().getMessage(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(this.location() + L.l("Resource type {0} is not assignable to method '{1}' of type {2}.", (Object)value.getClass().getName(), (Object)this._method.getName(), (Object)type.getName()), e);
        }
        catch (Exception e) {
            throw new ConfigException(this.location() + e.getMessage(), e);
        }
    }

    private String location() {
        return this._method.getDeclaringClass().getName() + "." + this._method.getName() + ": ";
    }
}

