/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class IntegerType
extends ConfigType {
    private static final L10N L = new L10N(IntegerType.class);
    public static final IntegerType TYPE = new IntegerType();
    private static final Integer ZERO = new Integer(0);

    private IntegerType() {
    }

    public Class getType() {
        return Integer.class;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Integer.valueOf(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to an Integer", value));
    }
}

