/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.LocaleType;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QName;
import java.util.Properties;

public final class PropertiesType
extends ConfigType {
    private static final L10N L = new L10N(LocaleType.class);
    public static final PropertiesType TYPE = new PropertiesType();

    private PropertiesType() {
    }

    public Class getType() {
        return Properties.class;
    }

    @Override
    public Object create(Object parent, QName name) {
        throw new ConfigException(L.l("java.util.Properties syntax is a string in .properties file syntax like the following:\n  a=b\n  b=c"));
    }

    @Override
    public Object valueOf(String text) {
        if (text == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            ReadStream is = Vfs.openString(text);
            props.load(is);
            return props;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Properties) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        throw new ConfigException(L.l("'{0}' is not a valid Properties value.", value));
    }
}

