/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.blob;

import com.caucho.db.blob.Inode;
import com.caucho.db.block.BlockStore;
import com.caucho.db.xa.DbTransaction;
import com.caucho.db.xa.RawTransaction;
import com.caucho.db.xa.StoreTransaction;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BlobOutputStream
extends OutputStream {
    private StoreTransaction _xa;
    private BlockStore _store;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _bufferEnd;
    private Inode _inode;
    private byte[] _inodeBuffer;
    private int _inodeOffset;

    public BlobOutputStream(DbTransaction xa, BlockStore store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
        this._xa = xa;
    }

    public BlobOutputStream(BlockStore store, byte[] inode, int inodeOffset) {
        this.init(store, inode, inodeOffset);
    }

    BlobOutputStream(Inode inode) {
        this.init(inode.getStore(), inode.getBuffer(), 0);
        this._inode = inode;
    }

    public void init(BlockStore store, byte[] inode, int inodeOffset) {
        this._store = store;
        this._xa = RawTransaction.create();
        this._inodeBuffer = inode;
        this._inodeOffset = inodeOffset;
        Inode.clear(this._inodeBuffer, this._inodeOffset);
        this._offset = 0;
        if (this._tempBuffer == null) {
            this._tempBuffer = TempBuffer.allocateLarge();
            this._buffer = this._tempBuffer.getBuffer();
            this._bufferEnd = this._buffer.length;
        }
    }

    @Override
    public void write(int v) throws IOException {
        if (this._bufferEnd <= this._offset) {
            this.flushBlock();
        }
        this._buffer[this._offset++] = (byte)v;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int sublen;
            if (this._bufferEnd <= this._offset) {
                this.flushBlock();
            }
            if (length < (sublen = this._bufferEnd - this._offset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._offset, sublen);
            offset += sublen;
            this._offset += sublen;
            length -= sublen;
        }
    }

    public void writeFromStream(InputStream is) throws IOException {
        while (true) {
            if (this._bufferEnd <= this._offset) {
                this.flushBlock();
            }
            int sublen = this._bufferEnd - this._offset;
            if ((sublen = is.read(this._buffer, this._offset, sublen)) <= 0) {
                return;
            }
            this._offset += sublen;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._tempBuffer == null) {
                return;
            }
            this.flushBlock();
        }
        finally {
            Inode inode = this._inode;
            this._inode = null;
            if (inode != null) {
                inode.closeOutputStream();
            }
            this._inodeBuffer = null;
            TempBuffer tempBuffer = this._tempBuffer;
            this._tempBuffer = null;
            if (tempBuffer != null) {
                TempBuffer.freeLarge(tempBuffer);
            }
        }
    }

    private void flushBlock() throws IOException {
        int length = this._offset;
        this._offset = 0;
        Inode.append(this._inodeBuffer, this._inodeOffset, this._store, this._xa, this._buffer, 0, length);
    }
}

