/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.BinaryAndExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;

final class AndExpr
extends Expr {
    private ArrayList<Expr> _exprList = new ArrayList();
    private Expr[] _exprs;

    AndExpr() {
    }

    void add(Expr expr) {
        this._exprList.add(expr);
    }

    Expr getSingleExpr() {
        if (this._exprList.size() == 0) {
            return null;
        }
        if (this._exprList.size() == 1) {
            return this._exprList.get(0);
        }
        return this;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._exprs = new Expr[this._exprList.size()];
        for (int i = 0; i < this._exprs.length; ++i) {
            Expr expr = this._exprList.get(i);
            if (!(expr = expr.bind(query)).getType().equals(Boolean.TYPE)) {
                throw new SQLException(L.l("AND requires boolean operands at {0}", (Object)expr));
            }
            this._exprList.set(i, expr);
            this._exprs[i] = expr;
        }
        Expr tailExpr = this._exprs[this._exprs.length - 1];
        for (int i = this._exprs.length - 2; i >= 0; --i) {
            tailExpr = new BinaryAndExpr(this._exprs[i], tailExpr);
        }
        return tailExpr;
    }

    @Override
    public Class<?> getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        long cost = 0L;
        for (int i = 0; i < this._exprList.size(); ++i) {
            cost += this._exprList.get(i).subCost(fromList);
        }
        return cost;
    }

    @Override
    public void splitAnd(ArrayList<Expr> andProduct) {
        for (int i = 0; i < this._exprList.size(); ++i) {
            this._exprList.get(i).splitAnd(andProduct);
        }
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        Expr[] exprs = this._exprs;
        int length = exprs.length;
        boolean isNull = false;
        for (int i = 0; i < length; ++i) {
            int value = exprs[i].evalBoolean(context);
            if (value == 0) {
                return false;
            }
            if (value == 1) continue;
            isNull = true;
        }
        return isNull;
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        Expr[] exprs = this._exprs;
        int length = exprs.length;
        int value = 1;
        for (int i = 0; i < length; ++i) {
            int subValue = exprs[i].evalBoolean(context);
            if (subValue == 0) {
                return 0;
            }
            if (subValue != -1) continue;
            value = -1;
        }
        return value;
    }

    @Override
    public final boolean isSelect(QueryContext context) throws SQLException {
        Expr[] exprs = this._exprs;
        int length = exprs.length;
        for (int i = 0; i < length; ++i) {
            if (exprs[i].isSelect(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        switch (this.evalBoolean(context)) {
            case 1: {
                return "1";
            }
            case 0: {
                return "0";
            }
        }
        return null;
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("(");
        for (int i = 0; i < this._exprList.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(this._exprList.get(i));
        }
        cb.append(")");
        return cb.close();
    }
}

