/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class LikeExpr
extends Expr {
    private static final Logger log = Logger.getLogger(LikeExpr.class.getName());
    private Expr _expr;
    private String _pattern;
    private Pattern _regexp;
    private boolean _isNot;

    LikeExpr(Expr expr, String pattern, boolean isNot) {
        this._expr = expr;
        this._pattern = pattern;
        this._isNot = isNot;
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '%': {
                    sb.append(".*");
                    continue block7;
                }
                case '_': {
                    sb.append(".");
                    continue block7;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        try {
            this._regexp = Pattern.compile(sb.toString());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._expr.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._expr.isNull(context)) {
            return -1;
        }
        String value = this._expr.evalString(context);
        if (this._regexp.matcher(value).matches()) {
            return this._isNot ? 0 : 1;
        }
        return this._isNot ? 1 : 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._expr.evalGroup(context);
    }

    public String toString() {
        return "(" + this._expr + " LIKE " + this._pattern + ")";
    }
}

