/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.Database;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.CreateQuery;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.Parser;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.IdentityColumn;
import com.caucho.db.table.NumericColumn;
import com.caucho.db.table.Row;
import com.caucho.db.table.TableFactory;
import com.caucho.db.table.TableIterator;
import com.caucho.db.table.TableRowAllocator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.inject.Module;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.BitsUtil;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class Table
extends BlockStore {
    private static final Logger log = Logger.getLogger(Table.class.getName());
    private static final L10N L = new L10N(Table.class);
    private static final int TABLE_DATA_OFFSET = 1024;
    private static final int STARTUP_TIMESTAMP_OFFSET = 1024;
    private static final int SHUTDOWN_TIMESTAMP_OFFSET = 1032;
    private static final int TABLE_DATA_END = 1040;
    private static final int ROOT_DATA_OFFSET = 1040;
    private static final int INDEX_ROOT_OFFSET = 1808;
    private static final int ROOT_DATA_END = 2064;
    public static final int INLINE_BLOB_SIZE = 120;
    public static final byte ROW_VALID = 1;
    public static final byte ROW_ALLOC = 2;
    public static final byte ROW_MASK = 3;
    private static final String DB_VERSION = "Resin-DB 4.0.28";
    private static final String MIN_VERSION = "Resin-DB 4.0.28";
    private final Row _row;
    private final int _rowLength;
    private final int _rowsPerBlock;
    private final int _rowEnd;
    private final Constraint[] _constraints;
    private final Column _identityColumn;
    private final Column _autoIncrementColumn;
    private long _startupTimestamp;
    private final TableRowAllocator _rowAllocator;
    private final AtomicLong _rowDeleteCount = new AtomicLong();
    private long _autoIncrementValue = -1L;
    private final Lifecycle _lifecycle;

    Table(Database database, String name, Row row, Constraint[] constraints) {
        super(database, name, null);
        this._lifecycle = new Lifecycle(log, name);
        this._row = row;
        this._constraints = constraints;
        this._rowLength = this._row.getLength();
        this._rowsPerBlock = 8192 / this._rowLength;
        this._rowEnd = this._rowLength * this._rowsPerBlock;
        Column[] columns = this._row.getColumns();
        Column autoIncrementColumn = null;
        Column identityColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            columns[i].setTable(this);
            if (columns[i].getAutoIncrement() >= 0) {
                autoIncrementColumn = columns[i];
            }
            if (!(columns[i] instanceof IdentityColumn)) continue;
            identityColumn = columns[i];
        }
        this._autoIncrementColumn = autoIncrementColumn;
        this._identityColumn = identityColumn;
        this._rowAllocator = new TableRowAllocator(this);
    }

    @Override
    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    Row getRow() {
        return this._row;
    }

    public int getRowLength() {
        return this._rowLength;
    }

    int getRowEnd() {
        return this._rowEnd;
    }

    int getRowsPerBlock() {
        return this._rowsPerBlock;
    }

    public final Column[] getColumns() {
        return this._row.getColumns();
    }

    public final Constraint[] getConstraints() {
        return this._constraints;
    }

    public Column getAutoIncrementColumn() {
        return this._autoIncrementColumn;
    }

    public Column getColumn(String name) {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return columns[i];
        }
        return null;
    }

    public int getColumnIndex(String name) throws SQLException {
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table loadFromFile(Database db, String name) throws IOException, SQLException {
        int ch;
        Path path = db.getPath().lookup(name + ".db");
        if (!path.exists()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(db + " '" + path.getNativePath() + "' is an unknown table");
            }
            return null;
        }
        String version = null;
        try (ReadStream is = path.openRead();){
            is.skip(9232L);
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) > 0) {
                sb.append((char)ch);
            }
            version = sb.toString();
            if (!version.startsWith("Resin-DB")) {
                throw new SQLException(L.l("table {0} is not a Resin DB.  Version '{1}'", (Object)name, (Object)version));
            }
            if (version.compareTo("Resin-DB 4.0.28") < 0 || "Resin-DB 4.0.28".compareTo(version) < 0) {
                throw new SQLException(L.l("table {0} is out of date.  Old version {1}.", (Object)name, (Object)version));
            }
        }
        is = path.openRead();
        try {
            is.skip(10256L);
            StringBuilder cb = new StringBuilder();
            while ((ch = is.read()) > 0) {
                cb.append((char)ch);
            }
            String sql = cb.toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Table[" + name + "] " + version + " loading\n" + sql);
            }
            try {
                CreateQuery query = (CreateQuery)Parser.parse(db, sql);
                TableFactory factory = query.getFactory();
                if (!factory.getName().equalsIgnoreCase(name)) {
                    throw new IOException(L.l("factory {0} does not match", (Object)name));
                }
                Table table = new Table(db, factory.getName(), factory.getRow(), factory.getConstraints());
                table.init();
                boolean isReadIndex = table.readIndexes();
                if (!table.isShutdownTimestampValid()) {
                    log.info(L.l("{0} validating indexes due to unclean shutdown.", (Object)table));
                } else {
                    log.fine(L.l("{0} validating indexes", (Object)table));
                }
                if (!isReadIndex || !table.validateIndexesSafe()) {
                    log.warning(L.l("rebuilding indexes for '{0}' because they did not properly validate on startup, total blocks={1}", (Object)table, (Object)table.getBlockCount()));
                    table.clearIndexes();
                    table.createIndexes();
                    table.rebuildIndexes();
                    log.warning(L.l("rebuilding indexes for '{0}' finished.", (Object)table));
                }
                if (table.getAllocation(0L) != 2) {
                    throw new IllegalStateException("Invalid table load");
                }
                table.writeStartupTimestamp();
                Table table2 = table;
                return table2;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                throw new SQLException(L.l("can't load table {0} in {1}.\n{2}", (Object)name, (Object)path.getNativePath(), (Object)e.toString()));
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws IOException, SQLException {
        super.create();
        this.createIndexes();
        byte[] tempBuffer = new byte[8192];
        this.getReadWrite().readBlock(8192L, tempBuffer, 0, 8192);
        TempStream ts = new TempStream();
        try (WriteStream os = new WriteStream(ts);){
            for (int i = 0; i < 1040; ++i) {
                os.write(tempBuffer[i]);
            }
            this.writeTableHeader(os);
        }
        int offset = 0;
        for (TempBuffer head = ts.getHead(); head != null; head = head.getNext()) {
            int length;
            byte[] buffer = head.getBuffer();
            System.arraycopy(buffer, 0, tempBuffer, offset, length);
            for (length = head.getLength(); length < buffer.length; ++length) {
                tempBuffer[offset + length] = 0;
            }
            offset += buffer.length;
        }
        while (offset < 8192) {
            tempBuffer[offset] = 0;
            ++offset;
        }
        boolean isPriority = false;
        this.getReadWrite().writeBlock(8192L, tempBuffer, 0, 8192, isPriority);
        this._database.addTable(this);
        this.writeStartupTimestamp();
        this.wakeWriter();
    }

    private void writeStartupTimestamp() throws IOException {
        this._startupTimestamp = CurrentTime.getCurrentTime();
        int offset = 1024;
        this.writeTimestamp(offset, this._startupTimestamp);
        this._lifecycle.toActive();
    }

    private void writeShutdownTimestamp() throws IOException {
        int offset = 1032;
        this.writeTimestamp(offset, this._startupTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimestamp(int offset, long timestamp) throws IOException {
        long metaBlockAddress = 8192L;
        Block metaBlock = this.readBlock(metaBlockAddress);
        try {
            byte[] buffer = metaBlock.getBuffer();
            this._startupTimestamp = CurrentTime.getCurrentTime();
            BitsUtil.writeLong(buffer, offset, timestamp);
            metaBlock.setDirty(offset, offset + 8);
            metaBlock.commit();
        }
        finally {
            metaBlock.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdownTimestampValid() throws IOException {
        long metaBlockAddress = 8192L;
        Block metaBlock = this.readBlock(metaBlockAddress);
        try {
            byte[] buffer = metaBlock.getBuffer();
            long startupTimestamp = BitsUtil.readLong(buffer, 1024);
            long shutdownTimestamp = BitsUtil.readLong(buffer, 1032);
            boolean bl = startupTimestamp == shutdownTimestamp && startupTimestamp != 0L;
            return bl;
        }
        finally {
            metaBlock.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexes() throws IOException, SQLException {
        int indexCount = 0;
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            KeyCompare keyCompare;
            Column column = columns[i];
            if (!column.isUnique() || (keyCompare = column.getIndexKeyCompare()) == null) continue;
            Block rootBlock = this.allocateIndexBlock();
            long rootBlockId = rootBlock.getBlockId();
            rootBlock.free();
            BTree btree = new BTree(this, rootBlockId, column.getLength(), keyCompare);
            column.setIndex(btree);
            long metaBlockAddress = 8192L;
            Block metaBlock = this.readBlock(metaBlockAddress);
            try {
                byte[] buffer = metaBlock.getBuffer();
                int newIndexCount = indexCount++;
                int offset = newIndexCount * 8 + 1808;
                BitsUtil.writeLong(buffer, offset, rootBlockId);
                continue;
            }
            finally {
                metaBlock.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIndexes() throws IOException, SQLException {
        int indexCount = 0;
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            KeyCompare keyCompare;
            Column column = columns[i];
            if (!column.isUnique() || (keyCompare = column.getIndexKeyCompare()) == null) continue;
            long rootBlockId = -1L;
            long metaBlockAddress = 8192L;
            Block metaBlock = this.readBlock(metaBlockAddress);
            try {
                byte[] buffer = metaBlock.getBuffer();
                int newIndexCount = indexCount++;
                int offset = newIndexCount * 8 + 1808;
                rootBlockId = BitsUtil.readLong(buffer, offset);
                if (!this.isIndexBlock(rootBlockId)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                metaBlock.free();
            }
            BTree btree = new BTree(this, rootBlockId, column.getLength(), keyCompare);
            column.setIndex(btree);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void clearIndexes() throws IOException {
        Column[] columns = this._row.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            BTree index = columns[i].getIndex();
            if (index == null) continue;
            long rootAddr = index.getIndexRoot();
            Block block = this.readBlock(this.addressToBlockId(rootAddr));
            try {
                byte[] blockBuffer;
                byte[] byArray = blockBuffer = block.getBuffer();
                // MONITORENTER : blockBuffer
                for (int j = 0; j < blockBuffer.length; ++j) {
                    blockBuffer[j] = 0;
                }
                block.setDirty(0, 8192);
                // MONITOREXIT : byArray
                continue;
            }
            finally {
                block.free();
            }
        }
        long blockAddr = 0L;
        while ((blockAddr = this.firstBlock(blockAddr + 8192L, 4)) > 0L) {
            this.deallocateBlock(blockAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndexes() throws IOException, SQLException {
        DbTransaction xa = DbTransaction.create();
        xa.setAutoCommit(true);
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(xa);
            Column[] columns = this._row.getColumns();
            int blockCount = 0;
            int rowCount = 0;
            while (iter.nextBlock()) {
                if (blockCount++ > 0 && blockCount % 10000 == 0) {
                    log.info(L.l("rebuilding indexes for '{0}': processed {1} blocks", (Object)this, blockCount));
                }
                iter.initRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    if (rowCount++ > 0 && rowCount % 100000 == 0) {
                        log.info(L.l("rebuilding indexes for '{0}': processed {1} rows", (Object)this, rowCount));
                    }
                    long rowAddress = iter.getRowAddress();
                    int rowOffset = iter.getRowOffset();
                    try {
                        if (!this.isValid(blockBuffer, rowOffset, columns)) {
                            log.warning(L.l("{0}: removing corrupted row (0x{1})", (Object)this, (Object)Long.toHexString(rowAddress)));
                            iter.delete();
                            continue;
                        }
                        for (int i = 0; i < columns.length; ++i) {
                            Column column = columns[i];
                            column.setIndex(xa, blockBuffer, rowOffset, rowAddress, null);
                        }
                    }
                    catch (Exception e) {
                        log.warning(L.l("{0} deleting row because of index rebuild failure: {1}\n  {2}", (Object)this, (Object)Long.toHexString(rowAddress), (Object)e));
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, e.toString(), e);
                        }
                        iter.deleteRowOnly();
                    }
                }
            }
        }
        finally {
            xa.commit();
        }
    }

    private boolean isValid(byte[] blockBuffer, int rowOffset, Column[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isValid(blockBuffer, rowOffset)) continue;
            return false;
        }
        return true;
    }

    public void validate() throws SQLException {
        try {
            this.validateIndexes();
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    private boolean validateIndexesSafe() {
        try {
            return this.validateIndexes();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, e.toString(), e);
            } else {
                log.warning(e.toString());
            }
            return false;
        }
    }

    private boolean validateIndexes() throws IOException, SQLException {
        Column[] columns = this._row.getColumns();
        boolean isIndex = false;
        for (Column column : columns) {
            if (column.getIndex() == null) continue;
            isIndex = true;
        }
        if (!isIndex) {
            return true;
        }
        return this.validateIndexByRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateIndexByRow() throws IOException, SQLException {
        Column[] columns = this._row.getColumns();
        boolean isValid = false;
        DbTransaction xa = DbTransaction.create();
        xa.setAutoCommit(true);
        TableIterator iter = null;
        try {
            iter = this.createTableIterator();
            iter.init(xa);
            while (iter.nextBlock()) {
                iter.initRow();
                byte[] blockBuffer = iter.getBuffer();
                while (iter.nextRow()) {
                    long rowAddress = iter.getRowAddress();
                    int rowOffset = iter.getRowOffset();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        column.validateIndex(xa, blockBuffer, rowOffset, rowAddress);
                    }
                }
            }
            isValid = true;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            } else {
                log.warning(e.toString());
            }
        }
        finally {
            if (iter != null) {
                iter.free();
            }
            xa.commit();
        }
        return isValid;
    }

    private void writeTableHeader(WriteStream os) throws IOException {
        int i;
        os.print("Resin-DB 4.0.28");
        os.write(0);
        while (os.getPosition() < 1808L) {
            os.write(0);
        }
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            if (!columns[i].isUnique()) continue;
            BTree index = columns[i].getIndex();
            if (index != null) {
                this.writeLong(os, index.getIndexRoot());
                continue;
            }
            this.writeLong(os, 0L);
        }
        while (os.getPosition() < 2064L) {
            os.write(0);
        }
        os.print("CREATE TABLE " + this.getName() + "(");
        for (i = 0; i < this._row.getColumns().length; ++i) {
            Expr defaultExpr;
            Column column = this._row.getColumns()[i];
            if (i != 0) {
                os.print(",");
            }
            os.print(column.getName());
            os.print(" ");
            switch (column.getTypeCode()) {
                case IDENTITY: {
                    os.print("IDENTITY");
                    break;
                }
                case VARCHAR: {
                    os.print("VARCHAR(" + column.getDeclarationSize() + ")");
                    break;
                }
                case VARBINARY: {
                    os.print("VARBINARY(" + column.getDeclarationSize() + ")");
                    break;
                }
                case BINARY: {
                    os.print("BINARY(" + column.getDeclarationSize() + ")");
                    break;
                }
                case SHORT: {
                    os.print("SMALLINT");
                    break;
                }
                case INT: {
                    os.print("INTEGER");
                    break;
                }
                case LONG: {
                    os.print("BIGINT");
                    break;
                }
                case DOUBLE: {
                    os.print("DOUBLE");
                    break;
                }
                case DATE: {
                    os.print("TIMESTAMP");
                    break;
                }
                case BLOB: {
                    os.print("BLOB");
                    break;
                }
                case NUMERIC: {
                    NumericColumn numeric = (NumericColumn)column;
                    os.print("NUMERIC(" + numeric.getPrecision() + "," + numeric.getScale() + ")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf(column));
                }
            }
            if (column.isPrimaryKey()) {
                os.print(" PRIMARY KEY");
            } else if (column.isUnique()) {
                os.print(" UNIQUE");
            }
            if (column.isNotNull()) {
                os.print(" NOT NULL");
            }
            if ((defaultExpr = column.getDefault()) != null) {
                os.print(" DEFAULT (");
                os.print(defaultExpr);
                os.print(")");
            }
            if (column.getAutoIncrement() < 0) continue;
            os.print(" auto_increment");
        }
        os.print(")");
    }

    public TableIterator createTableIterator() {
        this.assertStoreActive();
        return new TableIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextAutoIncrement(QueryContext context) throws SQLException {
        Table table = this;
        synchronized (table) {
            if (this._autoIncrementValue >= 0L) {
                return ++this._autoIncrementValue;
            }
        }
        long max = 0L;
        try {
            TableIterator iter = this.createTableIterator();
            iter.init(context);
            while (iter.next()) {
                byte[] buffer = iter.getBuffer();
                long blockId = iter.getBlockId();
                long value = this._autoIncrementColumn.getLong(blockId, buffer, iter.getRowOffset());
                if (max >= value) continue;
                max = value;
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        Table table2 = this;
        synchronized (table2) {
            if (this._autoIncrementValue < max) {
                this._autoIncrementValue = max;
            }
            return ++this._autoIncrementValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insert(QueryContext queryContext, DbTransaction xa, ArrayList<Column> columns, ArrayList<Expr> values) throws IOException, SQLException {
        if (log.isLoggable(Level.ALL)) {
            log.log(Level.ALL, "db table " + this.getName() + " insert row xa:" + xa);
        }
        Block block = null;
        try {
            while (true) {
                long blockId;
                int rowOffset;
                if ((rowOffset = this._rowAllocator.allocateRow(block = xa.loadBlock(this, blockId = this._rowAllocator.allocateInsertRowBlock()), xa)) >= 0) {
                    this.insertRow(queryContext, xa, columns, values, block, rowOffset);
                    block.saveAllocation();
                    this._rowAllocator.freeRowBlockId(blockId);
                    long l = Table.blockIdToAddress(blockId, rowOffset);
                    return l;
                }
                Block freeBlock = block;
                block = null;
                freeBlock.free();
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (block != null) {
                block.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(QueryContext queryContext, DbTransaction xa, ArrayList<Column> columns, ArrayList<Expr> values, Block block, int rowOffset) throws SQLException {
        byte[] buffer = block.getBuffer();
        long rowAddr = Table.blockIdToAddress(block.getBlockId(), rowOffset);
        TableIterator iter = this.createTableIterator();
        TableIterator[] iterSet = new TableIterator[]{iter};
        boolean isReadOnly = false;
        queryContext.init(xa, iterSet, isReadOnly);
        iter.init(queryContext);
        boolean isOkay = false;
        if (!queryContext.lock()) {
            log.warning("Unable to lock table");
            return;
        }
        try {
            Expr value;
            Column column;
            int i;
            iter.setRow(block, rowOffset);
            if (buffer[rowOffset] != 2) {
                throw new IllegalStateException(L.l("Expected ROW_ALLOC at '{0}'", buffer[rowOffset]));
            }
            for (i = rowOffset + this._rowLength - 1; rowOffset < i; --i) {
                buffer[i] = 0;
            }
            for (i = 0; i < columns.size(); ++i) {
                column = columns.get(i);
                value = values.get(i);
                column.setExpr(xa, buffer, rowOffset, value, queryContext);
            }
            for (i = 0; i < columns.size(); ++i) {
                column = columns.get(i);
                value = values.get(i);
                column.setExprBlob(xa, buffer, rowOffset, value, queryContext);
            }
            try {
                this.validate(block, rowOffset, queryContext, xa);
                for (i = 0; i < columns.size(); ++i) {
                    column = columns.get(i);
                    column.setIndex(xa, buffer, rowOffset, rowAddr, queryContext);
                }
                xa.writeData();
                buffer[rowOffset] = (byte)(buffer[rowOffset] & 0xFFFFFFFC | 1);
                xa.addUpdateBlock(block);
                long autoId = 0L;
                if (this._autoIncrementColumn != null) {
                    long blockId = iter.getBlockId();
                    autoId = this._autoIncrementColumn.getLong(blockId, buffer, rowOffset);
                    Table table = this;
                    synchronized (table) {
                        if (this._autoIncrementValue < autoId) {
                            this._autoIncrementValue = autoId;
                        }
                    }
                }
                block.setDirty(rowOffset, rowOffset + this._rowLength);
                GeneratedKeysResultSet rs = queryContext.getGeneratedKeysResultSet();
                if (rs != null) {
                    if (this._autoIncrementColumn != null) {
                        rs.setColumn(1, this._autoIncrementColumn);
                        rs.setLong(1, autoId);
                    } else if (this._identityColumn != null) {
                        rs.setColumn(1, this._identityColumn);
                        rs.setLong(1, rowAddr);
                    }
                }
                isOkay = true;
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                queryContext.unlock();
                if (!isOkay) {
                    this.delete(xa, block, buffer, rowOffset, false);
                    block.setDirty(rowOffset, rowOffset + this._rowLength);
                }
            }
        }
        finally {
            queryContext.unlock();
        }
    }

    private void validate(Block block, int rowOffset, QueryContext queryContext, DbTransaction xa) throws SQLException {
        TableIterator row = this.createTableIterator();
        TableIterator[] rows = new TableIterator[]{row};
        row.setRow(block, rowOffset);
        for (int i = 0; i < this._constraints.length; ++i) {
            this._constraints[i].validate(rows, queryContext, xa);
        }
    }

    boolean delete(DbTransaction xa, Block block, byte[] buffer, int rowOffset, boolean isDeleteIndex) throws SQLException {
        int i;
        byte rowState = buffer[rowOffset];
        if ((rowState & 3) != 1) {
            return false;
        }
        buffer[rowOffset] = (byte)(rowState & 0xFFFFFFFC | 2);
        Column[] columns = this._row.getColumns();
        for (i = 0; i < columns.length; ++i) {
            try {
                columns[i].deleteData(xa, buffer, rowOffset);
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (isDeleteIndex) {
            for (i = 0; i < columns.length; ++i) {
                try {
                    columns[i].deleteIndex(xa, buffer, rowOffset);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        Arrays.fill(buffer, rowOffset, rowOffset + this._row.getLength(), (byte)0);
        buffer[rowOffset] = 0;
        this._rowDeleteCount.incrementAndGet();
        return true;
    }

    public long getRowDeleteCount() {
        return this._rowDeleteCount.get();
    }

    @Override
    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            if (this.fsync()) {
                this.writeShutdownTimestamp();
                this.fsync();
            } else {
                log.warning(this + " fsync on close failed.");
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this._row.close();
        super.close();
        this._rowAllocator.close();
    }

    private void writeLong(WriteStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    @Override
    public String toString() {
        int id = CurrentTime.isTest() ? 1 : this.getId();
        String path = "";
        if (!CurrentTime.isTest()) {
            path = "," + this.getPath().getNativePath();
        }
        return this.getClass().getSimpleName() + "[" + this.getName() + ":" + id + path + "]";
    }
}

