/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.gen.LifecycleAspectBeanFactory;
import com.caucho.config.gen.XaCallback;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatefulAspectBeanFactory;
import com.caucho.ejb.session.StatefulHandle;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.AfterBegin;
import javax.ejb.AfterCompletion;
import javax.ejb.BeforeCompletion;
import javax.ejb.SessionBean;
import javax.ejb.Stateful;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class StatefulGenerator<X>
extends SessionGenerator<X> {
    private final AspectBeanFactory<X> _aspectBeanFactory;
    private final AspectBeanFactory<X> _lifecycleAspectFactory;

    public StatefulGenerator(String ejbName, AnnotatedType<X> beanType, ArrayList<AnnotatedType<? super X>> localApi, AnnotatedType<X> localBean, ArrayList<AnnotatedType<? super X>> remoteApi) {
        super(ejbName, beanType, localApi, localBean, remoteApi, Stateful.class.getSimpleName());
        InjectManager manager = InjectManager.create();
        this._aspectBeanFactory = new StatefulAspectBeanFactory(manager, this.getBeanType());
        this._lifecycleAspectFactory = new LifecycleAspectBeanFactory<X>(this._aspectBeanFactory, manager, this.getBeanType());
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectBeanFactory;
    }

    @Override
    protected AspectBeanFactory<X> getLifecycleAspectFactory() {
        return this._lifecycleAspectFactory;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    protected boolean isTimerSupported() {
        return false;
    }

    public String getContextClassName() {
        return this.getClassName();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public String getViewClassName() {
        return "StatefulProxy";
    }

    @Override
    public String getBeanClassName() {
        return this.getBeanType().getJavaClass().getName();
    }

    @Override
    protected AnnotatedType<? super X> introspectLocalDefault() {
        return this.getBeanType();
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.config.inject.CreationalContextImpl;");
        out.println("import com.caucho.ejb.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        this.generateClassHeader(out);
        out.println("{");
        out.pushDepth();
        this.generateClassStaticFields(out);
        this.generateClassContent(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    private void generateClassHeader(JavaWriter out) throws IOException {
        out.println();
        out.println("public class " + this.getClassName() + "<T>");
        if (this.hasNoInterfaceView()) {
            out.println("  extends " + this.getBeanType().getJavaClass().getName());
        }
        out.print("  implements SessionProxyFactory<T>");
        out.print(",\n  com.caucho.ejb.session.StatefulProxy");
        out.print(",\n  com.caucho.config.gen.CandiEnhancedBean");
        out.print(",\n  java.io.Serializable");
        for (AnnotatedType api : this.getLocalApi()) {
            out.print(",\n  ");
            out.printType(api.getBaseType());
        }
        for (AnnotatedType apiType : this.getRemoteApi()) {
            out.print(",\n  ");
            out.printType(apiType.getBaseType());
        }
        out.println();
    }

    @Override
    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private String _id;");
        out.println("private transient long _lastAccessTime;");
        out.println("private transient StatefulManager _manager;");
        out.println("private transient StatefulContext _context;");
        out.println("private " + this.getBeanClassName() + " _bean;");
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateContentImpl(out, map);
        this.generateSerialization(out);
    }

    @Override
    protected void generateContentImpl(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generateConstructor(out, map);
        this.generateProxyFactory(out);
        this.generateBeanPrologue(out, map);
        this.generateBusinessMethods(out, map);
        this.generateXa(out, map);
        this.generateEpilogue(out, map);
        this.generateInject(out, map);
        this.generateDelegate(out, map);
        this.generatePostConstruct(out, map);
        this.generateValidate(out, map);
        this.generateDestroy(out, map);
    }

    private void generateConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        out.println();
        out.print("public " + this.getClassName() + "(StatefulManager manager, ");
        out.println("StatefulContext context)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.println("_context = context;");
        out.println("if (__caucho_exception != null)");
        out.println("  throw __caucho_exception;");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("private " + this.getClassName() + "(StatefulManager manager, StatefulContext context, CreationalContextImpl<T> env)");
        out.println("{");
        out.pushDepth();
        out.println("_id = manager.generateKey();");
        out.println("_lastAccessTime = com.caucho.util.CurrentTime.getCurrentTime();");
        out.println("_manager = manager;");
        out.println("_context = context;");
        out.println("_bean = (" + this.getBeanClassName() + ") _manager.newInstance(env);");
        if (SessionBean.class.isAssignableFrom(this.getBeanType().getJavaClass())) {
            out.println("_bean.setSessionContext(context);");
        }
        this.generateContextObjectConstructor(out);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("@Override");
        out.println("public String __caucho_getId()");
        out.println("{");
        out.println("  return _id;");
        out.println("}");
    }

    private void generateProxyFactory(JavaWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("public T __caucho_createProxy(CreationalContextImpl<T> env)");
        out.println("{");
        out.println("  return (T) new " + this.getClassName() + "(_manager, _context, env);");
        out.println("}");
    }

    public void generateValidate(JavaWriter out, HashMap<String, Object> map) throws IOException {
        out.println();
        out.println("public void __caucho_validate()");
        out.println("{");
        out.pushDepth();
        out.println("long now = com.caucho.util.CurrentTime.getCurrentTime();");
        out.println("if (_manager.getIdleTimeout() < now - _lastAccessTime) {");
        out.println("  __caucho_destroy(null);");
        out.println("}");
        out.println();
        out.println("if (_bean == null)");
        out.println("  throw new javax.ejb.NoSuchEJBException(\"Stateful instance " + this.getClassName() + " is no longer valid\");");
        out.println();
        out.println("_lastAccessTime = now;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        super.generateDestroy(out, map);
        out.println();
        out.println("@Override");
        out.println("public void __caucho_destroy()");
        out.println("{");
        out.pushDepth();
        out.println("try {");
        out.println("  __caucho_preDestroyImpl();");
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    protected void generateDestroyImpl(JavaWriter out) throws IOException {
        super.generateDestroyImpl(out);
        out.println("_manager.destroy(_bean, env);");
        out.println("_bean = null;");
    }

    public void generateXa(JavaWriter out, HashMap<String, Object> map) throws IOException {
        AnnotatedType beanType = this.getBeanType();
        if (!beanType.isAnnotationPresent(XaCallback.class)) {
            return;
        }
        this.generateXaCallbackReflection(out);
        out.println("class __caucho_synchronization");
        out.println("  implements javax.ejb.SessionSynchronization {");
        out.pushDepth();
        out.println("Object _syncBean = _bean;");
        out.println("@Override");
        out.println("public void afterBegin()");
        out.println("  throws javax.ejb.EJBException, java.rmi.RemoteException");
        out.println("{");
        out.pushDepth();
        this.generateXaCallbackMethods(out, AfterBegin.class);
        out.popDepth();
        out.println("}");
        out.println("@Override");
        out.println("public void beforeCompletion()");
        out.println("  throws javax.ejb.EJBException, java.rmi.RemoteException");
        out.println("{");
        out.pushDepth();
        this.generateXaCallbackMethods(out, BeforeCompletion.class);
        out.popDepth();
        out.println("}");
        out.println("@Override");
        out.println("public void afterCompletion(boolean isCommitted)");
        out.println("  throws javax.ejb.EJBException, java.rmi.RemoteException");
        out.println("{");
        out.pushDepth();
        this.generateXaAfterCompletion(out, AfterCompletion.class);
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateXaCallbackMethods(JavaWriter out, Class<? extends Annotation> annType) throws IOException {
        for (AnnotatedMethod m : this.getBeanType().getMethods()) {
            if (!m.isAnnotationPresent(annType)) continue;
            Method javaMethod = m.getJavaMember();
            Class<?> declClass = javaMethod.getDeclaringClass();
            out.println("try {");
            out.pushDepth();
            String name = "__caucho_xa_" + declClass.getSimpleName() + "_" + javaMethod.getName();
            out.println(name + ".invoke(_syncBean);");
            out.popDepth();
            out.println("} catch (RuntimeException e) {");
            out.println("  throw e;");
            out.println("} catch (java.lang.reflect.InvocationTargetException e) {");
            out.println("  if (e.getCause() instanceof RuntimeException)");
            out.println("    throw (RuntimeException) e.getCause();");
            out.println("  else");
            out.println("    throw new javax.ejb.EJBException(e);");
            out.println("} catch (Exception e) {");
            out.println("  throw new javax.ejb.EJBException(e);");
            out.println("}");
        }
    }

    private void generateXaCallbackReflection(JavaWriter out) throws IOException {
        for (AnnotatedMethod m : this.getBeanType().getMethods()) {
            if (!m.isAnnotationPresent(AfterBegin.class) && !m.isAnnotationPresent(BeforeCompletion.class) && !m.isAnnotationPresent(AfterCompletion.class)) continue;
            Method javaMethod = m.getJavaMember();
            Class<?> declClass = javaMethod.getDeclaringClass();
            String name = "__caucho_xa_" + declClass.getSimpleName() + "_" + javaMethod.getName();
            out.print("static final java.lang.reflect.Method");
            out.println("  " + name);
            out.print("  = " + CandiUtil.class.getName() + ".findAccessibleMethod(");
            out.print(declClass.getName() + ".class");
            out.print(", \"" + javaMethod.getName() + "\"");
            for (Class<?> param : javaMethod.getParameterTypes()) {
                out.print(", ");
                out.printClass(param);
                out.print(".class");
            }
            out.println(");");
        }
    }

    private void generateXaAfterCompletion(JavaWriter out, Class<? extends Annotation> annType) throws IOException {
        for (AnnotatedMethod m : this.getBeanType().getMethods()) {
            if (!m.isAnnotationPresent(annType)) continue;
            Method javaMethod = m.getJavaMember();
            Class<?> declClass = javaMethod.getDeclaringClass();
            out.println("try {");
            out.pushDepth();
            String name = "__caucho_xa_" + declClass.getSimpleName() + "_" + javaMethod.getName();
            out.println(name + ".invoke(_syncBean, isCommitted);");
            out.popDepth();
            out.println("} catch (RuntimeException e) {");
            out.println("  throw e;");
            out.println("} catch (java.lang.reflect.InvocationTargetException e) {");
            out.println("  if (e.getCause() instanceof RuntimeException)");
            out.println("    throw (RuntimeException) e.getCause();");
            out.println("  else");
            out.println("    throw new javax.ejb.EJBException(e);");
            out.println("} catch (Exception e) {");
            out.println("  throw new javax.ejb.EJBException(e);");
            out.println("}");
        }
    }

    private void generateSerialization(JavaWriter out) throws IOException {
        out.println("private Object writeReplace()");
        out.println("{");
        out.pushDepth();
        out.print("return new ");
        out.printClass(StatefulHandle.class);
        out.println("(_manager.getEJBName(), null);");
        out.popDepth();
        out.println("}");
    }
}

