/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import com.caucho.env.git.GitCommitTree;
import com.caucho.env.git.GitWorkingTree;
import com.caucho.java.WorkDir;
import com.caucho.util.CurrentTime;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Jar;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class GitCommitJar {
    private static final L10N L = new L10N(GitCommitJar.class);
    private static final Logger log = Logger.getLogger(GitCommitJar.class.getName());
    private GitCommitTree _commit = new GitCommitTree();
    private JarPath _jar;
    private Path _tempJar;

    public GitCommitJar(Path jar) throws IOException {
        this(jar.getTail(), jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitCommitJar(String pathName, Path jar) throws IOException {
        if (jar.getScheme().equals("memory")) {
            try (ReadStream is = jar.openRead();){
                this.init(is);
            }
        } else {
            this.init(pathName, jar);
        }
    }

    private GitCommitJar(String pathName, Path jar, boolean isTemp) throws IOException {
        this.init(pathName, jar);
        this._tempJar = jar;
    }

    public GitCommitJar(InputStream is) throws IOException {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitCommitJar createDirectory(Path dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(L.l("'{0}' must be a directory", (Object)dir));
        }
        Path workDir = WorkDir.getLocalWorkDir();
        workDir.mkdirs();
        Path tmpPath = workDir.createTempFile("git", ".jar");
        WriteStream os = null;
        try {
            os = tmpPath.openWrite();
            ZipOutputStream zos = new ZipOutputStream(os);
            int count = GitCommitJar.fillDirectory(zos, dir, "");
            if (count > 0) {
                zos.close();
            } else {
                try {
                    zos.close();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            os.close();
            GitCommitJar gitCommitJar = new GitCommitJar(tmpPath.getTail(), tmpPath, true);
            tmpPath = null;
            GitCommitJar gitCommitJar2 = gitCommitJar;
            return gitCommitJar2;
        }
        finally {
            IoUtil.close(os);
            if (tmpPath != null) {
                tmpPath.remove();
            }
        }
    }

    private static int fillDirectory(ZipOutputStream zos, Path dir, String pathName) throws IOException {
        int count = 0;
        Object[] list = dir.list();
        Arrays.sort(list);
        for (Object name : list) {
            if (((String)name).startsWith(".")) continue;
            Object subPath = "".equals(pathName) ? name : pathName + "/" + (String)name;
            Path path = dir.lookup((String)name);
            if (path.isFile()) {
                ZipEntry entry = new ZipEntry((String)subPath);
                if (CurrentTime.isTest()) {
                    entry.setTime(CurrentTime.getCurrentTime());
                } else {
                    entry.setTime(path.getLastModified());
                }
                zos.putNextEntry(entry);
                path.writeToStream(zos);
                zos.closeEntry();
                ++count;
                continue;
            }
            if (!path.isDirectory()) continue;
            int subcount = GitCommitJar.fillDirectory(zos, path, (String)subPath);
            count += subcount;
        }
        return count;
    }

    private void init(InputStream is) throws IOException {
        Path dir = WorkDir.getLocalWorkDir();
        dir.mkdirs();
        Path path = dir.createTempFile("git", ".jar");
        try {
            WriteStream os = path.openWrite();
            os.writeStream(is);
            os.close();
            this.init(path.getTail(), path);
            this._tempJar = path;
        }
        catch (IOException e) {
            path.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String pathName, Path path) throws IOException {
        this._jar = JarPath.create(path);
        ReadStream is = null;
        try {
            is = path.openRead();
            this._commit.addFile(pathName, 436, is, path.getLength());
        }
        finally {
            IoUtil.close(is);
        }
        this._commit.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCommit(HashMap<String, Long> lengthMap, InputStream is) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(is);
            while ((entry = zin.getNextEntry()) != null) {
                String path = entry.getName();
                long length = entry.getSize();
                if (entry.isDirectory()) continue;
                Long lengthValue = lengthMap.get(path);
                if (lengthValue != null) {
                    length = lengthValue;
                }
                this._commit.addFile(path, 436, zin, length);
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(zin);
            is.close();
            throw throwable;
        }
        IoUtil.close(zin);
        is.close();
    }

    public String[] getCommitList() {
        return this._commit.getCommitList();
    }

    public String getDigest() {
        return this._commit.getDigest();
    }

    public String findPath(String sha1) {
        return this._commit.findPath(sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLengthMap(HashMap<String, Long> lengthMap, Path jar) throws IOException {
        ReadStream is = jar.openRead();
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(is);
            while ((entry = zin.getNextEntry()) != null) {
                String path = entry.getName();
                long length = entry.getSize();
                if (entry.isDirectory()) continue;
                if (length < 0L) {
                    length = 0L;
                    while (zin.read() >= 0) {
                        ++length;
                    }
                }
                lengthMap.put(path, length);
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(zin);
            IoUtil.close(is);
            throw throwable;
        }
        IoUtil.close(zin);
        IoUtil.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLength(String path) throws IOException {
        long l;
        ReadStream is = null;
        try {
            Jar.ZipStreamImpl zipIs = this._jar.getJar().openReadImpl(path);
            is = new ReadStream(zipIs);
            long length = 0L;
            while (((InputStream)is).read() >= 0) {
                ++length;
            }
            l = length;
        }
        catch (Throwable throwable) {
            IoUtil.close(is);
            throw throwable;
        }
        IoUtil.close(is);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openFile(String sha1) throws IOException {
        String path = this._commit.findPath(sha1);
        if (path.endsWith("/")) {
            GitWorkingTree tree = this._commit.findTree(path);
            return tree.openFile();
        }
        Path jar = this._jar.getContainer();
        ReadStream is = null;
        try {
            is = jar.openRead();
            InputStream inputStream = GitCommitTree.writeBlob(is, jar.getLength());
            return inputStream;
        }
        finally {
            IoUtil.close(is);
        }
    }

    public void close() {
        if (this._jar != null) {
            this._jar.closeJar();
        }
        if (this._tempJar != null) {
            try {
                this._tempJar.remove();
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

