/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.CountSensor;
import com.caucho.util.ConcurrentArrayList;
import java.util.concurrent.atomic.AtomicLong;

public final class CountMeter
extends AbstractMeter
implements CountSensor {
    private final AtomicLong _totalCount = new AtomicLong();
    private ConcurrentArrayList<CountSensor> _listeners;
    private long _lastTotal;
    private long _value;

    public CountMeter(String name) {
        super(name);
    }

    @Override
    public final void start() {
        this._totalCount.incrementAndGet();
        if (this._listeners != null) {
            for (CountSensor sensor : this._listeners.toArray()) {
                sensor.start();
            }
        }
    }

    @Override
    public final void sample() {
        long totalCount = this._totalCount.get();
        long lastTotal = this._lastTotal;
        this._lastTotal = totalCount;
        this._value = totalCount - lastTotal;
    }

    @Override
    public final double calculate() {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CountSensor sensor) {
        CountMeter countMeter = this;
        synchronized (countMeter) {
            if (this._listeners == null) {
                this._listeners = new ConcurrentArrayList<CountSensor>(CountSensor.class);
            }
            this._listeners.add(sensor);
        }
    }

    public void removeListener(CountSensor sensor) {
        if (this._listeners != null) {
            this._listeners.remove(sensor);
        }
    }
}

