/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.TimeSensor;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeMeter
extends AbstractMeter
implements TimeSensor {
    private final AtomicLong _count = new AtomicLong();
    private final AtomicLong _time = new AtomicLong();
    private double _value;

    public TimeMeter(String name) {
        super(name);
    }

    @Override
    public final void add(long time) {
        this._count.incrementAndGet();
        this._time.addAndGet(time);
    }

    @Override
    public final void sample() {
        long count = this._count.getAndSet(0L);
        long time = this._time.getAndSet(0L);
        this._value = count == 0L ? 0.0 : (double)time / (double)count;
    }

    @Override
    public final double calculate() {
        return this._value;
    }
}

