/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitObjectStream;
import com.caucho.env.git.GitSystem;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.RepositoryException;
import com.caucho.env.repository.RepositoryTagMap;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class FileRepository
extends AbstractRepository {
    private static final L10N L = new L10N(FileRepository.class);
    private GitSystem _git;
    private AtomicReference<String> _rootHash = new AtomicReference();
    private Lifecycle _lifecycle = new Lifecycle();
    private long _expireTime = CurrentTime.isTest() ? 15000L : 3600000L;
    private Alarm _alarm;

    public FileRepository() {
        this(GitSystem.getCurrent());
    }

    public FileRepository(GitSystem git) {
        this._git = git;
        if (this._git == null) {
            throw new IllegalStateException(L.l("{0} is required for {1}", (Object)GitSystem.class.getSimpleName(), (Object)this.getClass().getSimpleName()));
        }
    }

    @Override
    public void checkForUpdate(boolean isExact) {
        this.update(this.getRepositoryRootHash(), false);
    }

    @Override
    public boolean putTag(String tagName, String contentHash, Map<String, String> commitMetaData) {
        RepositoryTagMap tagMap;
        while (!this.setTagMap(tagMap = this.addTagData(tagName, contentHash, commitMetaData))) {
        }
        return true;
    }

    @Override
    public boolean removeTag(String tagName, Map<String, String> commitMetaData) {
        RepositoryTagMap tagMap;
        while (!this.setTagMap(tagMap = this.removeTagData(tagName, commitMetaData))) {
        }
        return true;
    }

    @Override
    public String getRepositoryRootHash() {
        String rootHash = this._rootHash.get();
        if (rootHash != null && rootHash.length() > 6) {
            return rootHash;
        }
        String value = this._git.getTag(this.getRepositoryTag());
        this._rootHash.compareAndSet(null, value);
        value = this._rootHash.get();
        if (value != null && value.length() > 6) {
            return value;
        }
        return null;
    }

    @Override
    public void setRepositoryRootHash(String sha1) {
        if (sha1 != null) {
            this._rootHash.set(sha1);
            this._git.writeTag(this.getRepositoryTag(), sha1);
            this._git.writeTag(this.getRepositoryDebugTag(), sha1);
            this._git.setHead(this.getRepositoryDebugTag());
            this._git.gc(this._expireTime);
        }
    }

    @Override
    public boolean exists(String hash) {
        if (hash == null) {
            throw new NullPointerException();
        }
        return this._git.contains(hash);
    }

    @Override
    public GitType getType(String sha1) {
        try {
            return this._git.contains(sha1) ? this._git.objectType(sha1) : null;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public String addBlob(InputStream is) {
        try {
            return this._git.writeInputStream(is);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public String addBlob(InputStream is, long length) {
        try {
            return this._git.writeInputStream(is, length);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public InputStream openBlob(String sha1) throws IOException {
        return this._git.openBlob(sha1);
    }

    @Override
    public InputStream openRawGitFile(String sha1) throws IOException {
        return this._git.openRawGitFile(sha1);
    }

    @Override
    public GitTree readTree(String sha1) throws IOException {
        return this._git.parseTree(sha1);
    }

    @Override
    public String addTree(GitTree tree) throws IOException {
        return this._git.writeTree(tree);
    }

    @Override
    public GitCommit readCommit(String sha1) throws IOException {
        return this._git.parseCommit(sha1);
    }

    @Override
    public String addCommit(GitCommit commit) throws IOException {
        return this._git.writeCommit(commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRawGitFile(String sha1, InputStream is) throws IOException {
        GitSystem gitSystem = this._git;
        synchronized (gitSystem) {
            this._git.writeRawGitFile(sha1, is);
        }
    }

    @Override
    public void validateRawGitFile(String sha1) {
        this._git.validateRawGitFile(sha1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBlobToStream(String blobHash, OutputStream os) {
        try (GitObjectStream is = null;){
            is = this._git.open(blobHash);
            if (is.getType() != GitType.BLOB) {
                throw new RepositoryException(L.l("'{0}' is an unexpected type, expected 'blob'", (Object)is.getType()));
            }
            WriteStream out = null;
            out = os instanceof WriteStream ? (WriteStream)os : Vfs.openWrite(os);
            try {
                out.writeStream(is.getInputStream());
            }
            finally {
                if (out != null && out != os) {
                    out.close();
                }
            }
        }
    }

    @Override
    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    @Override
    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        super.start();
        this._git.gc(this._expireTime);
        this._alarm = new Alarm(new GcListener());
        this._alarm.queue(this._expireTime);
    }

    @Override
    public void stop() {
        super.stop();
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
    }

    @Override
    public void expandToPath(String contentHash, Path path) {
        try {
            this._git.expandToPath(path, contentHash);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    private class GcListener
    implements AlarmListener {
        private GcListener() {
        }

        @Override
        public void handleAlarm(Alarm alarm) {
            if (FileRepository.this.isActive()) {
                try {
                    FileRepository.this._git.gc(FileRepository.this._expireTime);
                }
                finally {
                    if (FileRepository.this.isActive()) {
                        alarm.queue(FileRepository.this._expireTime);
                    }
                }
            }
        }
    }
}

