/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.thread.TaskWorker;
import com.caucho.env.warning.WarningService;
import com.caucho.loader.Environment;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTaskWorker2
implements Runnable,
TaskWorker,
Closeable {
    private static Logger _log;
    private static final long PERMANENT_TIMEOUT = 30000L;
    private static final AtomicLong _idGen;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.IDLE);
    private final WeakReference<ClassLoader> _classLoaderRef;
    private String _threadName;
    private long _workerIdleTimeout = 500L;
    private volatile Thread _thread;

    protected AbstractTaskWorker2(ClassLoader classLoader) {
        this._classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        if (this.isWeakClose()) {
            Environment.addWeakCloseListener(this, classLoader);
        }
    }

    protected boolean isWeakClose() {
        return true;
    }

    protected boolean isPermanent() {
        return false;
    }

    protected void setWorkerIdleTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this._workerIdleTimeout = timeout;
    }

    public final boolean isTaskActive() {
        return this._state.get().isActive() || this._state.get().isPark();
    }

    public boolean isClosed() {
        return this._state.get().isClosed();
    }

    public String getState() {
        return String.valueOf((Object)this._state.get());
    }

    protected ClassLoader getClassLoader() {
        return (ClassLoader)this._classLoaderRef.get();
    }

    public abstract long runTask();

    @Override
    public void close() {
        this._state.getAndSet(State.CLOSED);
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public final void wake() {
        Thread thread;
        State newState;
        State oldState;
        while (!this._state.compareAndSet(oldState = this._state.get(), newState = oldState.toWake())) {
        }
        if (oldState.isIdle()) {
            this.startWorkerThread();
        } else if (oldState.isPark() && (thread = this._thread) != null) {
            this.unpark(thread);
        }
    }

    protected abstract void startWorkerThread();

    protected void unpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    protected String getThreadName() {
        if (this._threadName == null) {
            this._threadName = this.toString() + "-" + _idGen.incrementAndGet();
        }
        return this._threadName;
    }

    protected boolean isRetry() {
        return false;
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    private long getIdleTimeout() {
        if (this.isPermanent()) {
            return 30000L;
        }
        return this._workerIdleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        try {
            Thread oldThread = this._thread;
            this._thread = thread;
            if (oldThread != null) {
                System.out.println("DOUBLE_THREAD: " + oldThread);
            }
            thread.setContextClassLoader(this.getClassLoader());
            thread.setName(this.getThreadName());
            this.onThreadStart();
            long now = this.getCurrentTimeActual();
            long idleTimeout = this.getIdleTimeout();
            long expires = idleTimeout > 0L ? now + idleTimeout : 0L;
            boolean isExpireRetry = false;
            do {
                State oldState;
                isExpireRetry = false;
                do {
                    if (!(oldState = this._state.get()).isClosed()) continue;
                    return;
                } while (!this._state.compareAndSet(oldState, State.ACTIVE));
                do {
                    if (this._state.get().isClosed()) {
                        return;
                    }
                    thread.setContextClassLoader(this.getClassLoader());
                    isExpireRetry = false;
                    long delta = this.runTask();
                    now = this.getCurrentTimeActual();
                    if (delta > 0L) {
                        expires = now + delta;
                        isExpireRetry = true;
                        continue;
                    }
                    expires = idleTimeout > 0L ? now + idleTimeout : 0L;
                } while (this._state.compareAndSet(State.ACTIVE_WAKE, State.ACTIVE));
                if (expires > 0L && this._state.compareAndSet(State.ACTIVE, State.PARK)) {
                    thread.setName(this.getThreadName());
                    Thread.interrupted();
                    if (!this.isRetry() && this._state.get() == State.PARK) {
                        LockSupport.parkUntil(expires);
                    }
                    this._state.compareAndSet(State.PARK, State.ACTIVE);
                }
                now = this.getCurrentTimeActual();
                if (!this.isPermanent() && !isExpireRetry) continue;
                expires = now + idleTimeout;
            } while (this.isPermanent() || isExpireRetry || now < expires || this._state.get() == State.ACTIVE_WAKE || this.isRetry());
        }
        catch (Throwable e) {
            System.err.println(this.getClass().getSimpleName() + ": " + e);
            WarningService.sendCurrentWarning((Object)this, e);
            this.log().log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._thread = null;
            this.completeThread(thread, oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeThread(Thread thread, String oldName) {
        try {
            this.onThreadComplete();
        }
        finally {
            State newState;
            State oldState;
            while (!this._state.compareAndSet(oldState = this._state.get(), newState = oldState.toIdle())) {
            }
            if (newState.isWake()) {
                boolean isValid = false;
                try {
                    this.startWorkerThread();
                    isValid = true;
                }
                finally {
                    if (!isValid) {
                        System.err.println("Warning: resetting actor. " + this);
                        this.log().warning("Warning: resetting actor. " + this);
                        this._state.set(State.IDLE);
                    }
                }
            }
            thread.setName(oldName);
        }
    }

    protected long getCurrentTimeActual() {
        return System.currentTimeMillis();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(AbstractTaskWorker2.class.getName());
        }
        return _log;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        _idGen = new AtomicLong();
    }

    static enum State {
        IDLE{

            @Override
            boolean isIdle() {
                return true;
            }

            @Override
            State toWake() {
                return ACTIVE_WAKE;
            }
        }
        ,
        ACTIVE{

            @Override
            boolean isActive() {
                return true;
            }

            @Override
            State toWake() {
                return ACTIVE_WAKE;
            }

            @Override
            State toIdle() {
                return IDLE;
            }
        }
        ,
        ACTIVE_WAKE{

            @Override
            boolean isActive() {
                return true;
            }

            @Override
            boolean isWake() {
                return true;
            }

            @Override
            State toWake() {
                return ACTIVE_WAKE;
            }

            @Override
            State toIdle() {
                return ACTIVE_WAKE;
            }
        }
        ,
        PARK{

            @Override
            boolean isPark() {
                return true;
            }

            @Override
            State toWake() {
                return ACTIVE_WAKE;
            }

            @Override
            State toIdle() {
                return IDLE;
            }
        }
        ,
        CLOSED{

            @Override
            boolean isClosed() {
                return true;
            }

            @Override
            State toWake() {
                return CLOSED;
            }

            @Override
            State toIdle() {
                return CLOSED;
            }
        };


        boolean isIdle() {
            return false;
        }

        boolean isActive() {
            return false;
        }

        boolean isWake() {
            return false;
        }

        boolean isPark() {
            return false;
        }

        boolean isClosed() {
            return false;
        }

        State toWake() {
            System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ": invalid toWake from " + (Object)((Object)this));
            throw new UnsupportedOperationException(this.toString());
        }

        State toIdle() {
            System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ": invalid toIdle from " + (Object)((Object)this));
            throw new UnsupportedOperationException(this.toString());
        }
    }
}

