/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.config.Configurable;
import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CsrfFilter
implements Filter {
    private static final L10N L = new L10N(CsrfFilter.class);
    private static final Logger log = Logger.getLogger(CsrfFilter.class.getName());
    public static final String PARAMETER = "cr_csrf";
    public static final String NONCE_MAP = "caucho.resin.csrf.nonce";
    private HashSet<String> _allowSet = new HashSet();
    private int _lruSize = 8;

    @Configurable
    public void addAllow(String entry) {
        this._allowSet.add(entry);
    }

    public void init(FilterConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        String nonceValue;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        HttpSession session = req.getSession();
        LruCache nonceMap = (LruCache)session.getAttribute(NONCE_MAP);
        if (nonceMap == null) {
            nonceMap = new LruCache(this._lruSize);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (session.getAttribute(NONCE_MAP) == null) {
                    session.setAttribute(NONCE_MAP, nonceMap);
                }
                nonceMap = (LruCache)session.getAttribute(NONCE_MAP);
            }
        }
        String url = req.getServletPath();
        if (req.getPathInfo() != null) {
            url = url + req.getPathInfo();
        }
        if (!this._allowSet.contains(url) && nonceMap.get(nonceValue = req.getParameter(PARAMETER)) == null) {
            res.sendError(403);
            return;
        }
        String nonce = this.generateNonce();
        nonceMap.put(nonce, nonce);
        try (CsrfResponse csrfResponse = new CsrfResponse(res, nonce);){
            nextFilter.doFilter(request, (ServletResponse)csrfResponse);
        }
    }

    private String generateNonce() {
        long nonceValue = RandomUtil.getRandomLong();
        StringBuilder sb = new StringBuilder();
        this.fillBase64(sb, nonceValue);
        this.fillBase64(sb, nonceValue >> 6);
        this.fillBase64(sb, nonceValue >> 12);
        this.fillBase64(sb, nonceValue >> 18);
        this.fillBase64(sb, nonceValue >> 24);
        this.fillBase64(sb, nonceValue >> 30);
        this.fillBase64(sb, nonceValue >> 36);
        this.fillBase64(sb, nonceValue >> 42);
        this.fillBase64(sb, nonceValue >> 48);
        this.fillBase64(sb, nonceValue >> 54);
        this.fillBase64(sb, nonceValue >> 60);
        return sb.toString();
    }

    private void fillBase64(StringBuilder sb, long longValue) {
        int value = (int)(longValue & 0x3FL);
        if (value < 26) {
            sb.append((char)(97 + value));
        } else if (value < 52) {
            sb.append((char)(65 + value - 26));
        } else if (value < 62) {
            sb.append((char)(48 + value - 52));
        } else if (value == 62) {
            sb.append('_');
        } else {
            sb.append('-');
        }
    }

    public void destroy() {
    }

    static class CsrfResponse
    extends CauchoResponseWrapper {
        private String _nonce;

        CsrfResponse(HttpServletResponse response, String nonce) {
            super(response);
            this._nonce = nonce;
        }

        @Override
        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        @Override
        public String encodeURL(String url) {
            return super.encodeURL(this.rewriteUrl(url));
        }

        @Override
        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        @Override
        public String encodeRedirectURL(String url) {
            return super.encodeRedirectURL(this.rewriteUrl(url));
        }

        String rewriteUrl(String url) {
            int q = url.indexOf(63);
            int a = url.indexOf(35);
            url = q < 0 ? url + "?" + CsrfFilter.PARAMETER + "=" + this._nonce : (a < 0 ? url + "&" + CsrfFilter.PARAMETER + "=" + this._nonce : url.substring(0, a) + "&" + CsrfFilter.PARAMETER + "=" + this._nonce + url.substring(a));
            return url;
        }
    }
}

