/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.util.L10N;

public class ClientStubManager {
    private static final L10N L = new L10N(ClientStubManager.class);
    private final ManagedBroker _broker;
    private final Mailbox _toLinkMailbox;
    private Mailbox _clientStub;

    public ClientStubManager(ManagedBroker broker, Mailbox toLinkMailbox) {
        this._broker = broker;
        this._toLinkMailbox = toLinkMailbox;
    }

    public Mailbox getToLinkMailbox() {
        return this._toLinkMailbox;
    }

    public String getAddress() {
        if (this._clientStub != null) {
            return this._clientStub.getAddress();
        }
        throw new IllegalStateException(L.l("{0}: Client stub has not been registered", (Object)this));
    }

    public boolean isActive() {
        return this._clientStub != null;
    }

    public void login(String uid, String resource) {
        if (this._clientStub != null) {
            throw new IllegalStateException(L.l("{0}: Client stub alread exists", (Object)this));
        }
        this._clientStub = this._broker.createClient(this._toLinkMailbox, uid, resource);
    }

    public void logout() {
        Mailbox clientStub = this._clientStub;
        this._clientStub = null;
        if (clientStub != null) {
            this._broker.removeMailbox(clientStub);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._toLinkMailbox + "]";
    }
}

