/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.ConfigException;
import com.caucho.env.dbpool.ConnectionPool;
import com.caucho.jca.ra.WorkManagerImpl;
import com.caucho.loader.CloseListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;

public class ResourceManagerImpl
implements BootstrapContext {
    private static final L10N L = new L10N(ResourceManagerImpl.class);
    private static final Logger log = Logger.getLogger(ResourceManagerImpl.class.getName());
    private static EnvironmentLocal<ResourceManagerImpl> _localManager = new EnvironmentLocal();
    private final EnvironmentClassLoader _loader;
    private UserTransactionProxy _tm;
    private ArrayList<ResourceAdapter> _resources = new ArrayList();
    private ArrayList<ConnectionPool> _connectionManagers = new ArrayList();
    private ArrayList<SoftReference<Timer>> _timers = new ArrayList();
    private WorkManagerImpl _workManager;
    private boolean _isInit;
    private boolean _isClosed;

    private ResourceManagerImpl() {
        this._loader = Environment.getEnvironmentClassLoader();
        Environment.addClassLoaderListener(new CloseListener(this));
        this._tm = UserTransactionProxy.getInstance();
        if (this._tm == null) {
            throw new IllegalStateException();
        }
    }

    public static ResourceManagerImpl createLocalManager() {
        return ResourceManagerImpl.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceManagerImpl create() {
        ResourceManagerImpl rm;
        EnvironmentLocal<ResourceManagerImpl> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            rm = _localManager.getLevel();
            if (rm == null) {
                rm = new ResourceManagerImpl();
                _localManager.set(rm);
            }
        }
        return rm;
    }

    public static ResourceManagerImpl getLocalManager() {
        return _localManager.getLevel();
    }

    public static void addResource(ResourceAdapter resource) throws ConfigException {
        ResourceManagerImpl rm = ResourceManagerImpl.createLocalManager();
        rm.addResourceImpl(resource);
    }

    private void addResourceImpl(ResourceAdapter resource) {
        try {
            resource.start((BootstrapContext)this);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._resources.add(resource);
    }

    public ConnectionPool createConnectionPool() {
        ConnectionPool cm = new ConnectionPool();
        cm.setTransactionManager(this._tm);
        this._connectionManagers.add(cm);
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkManager getWorkManager() {
        ResourceManagerImpl resourceManagerImpl = this;
        synchronized (resourceManagerImpl) {
            if (this._workManager == null) {
                this._workManager = new WorkManagerImpl();
            }
        }
        return this._workManager;
    }

    public XATerminator getXATerminator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer createTimer() throws UnavailableException {
        TimerImpl timer = new TimerImpl(this);
        ArrayList<SoftReference<Timer>> arrayList = this._timers;
        synchronized (arrayList) {
            SoftReference<TimerImpl> timerRef = new SoftReference<TimerImpl>(timer);
            this._timers.add(timerRef);
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer timer) {
        if (this._timers == null) {
            return;
        }
        ArrayList<SoftReference<Timer>> arrayList = this._timers;
        synchronized (arrayList) {
            for (int i = this._timers.size(); i >= 0; --i) {
                SoftReference<Timer> timerRef = this._timers.get(i);
                Timer oldTimer = timerRef.get();
                if (oldTimer == null) {
                    this._timers.remove(i);
                    continue;
                }
                if (oldTimer != timer) continue;
                this._timers.remove(i);
            }
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        int i;
        ArrayList<SoftReference<Timer>> timers;
        ArrayList<ResourceAdapter> resources;
        ArrayList<ConnectionPool> connectionManagers;
        ResourceManagerImpl resourceManagerImpl = this;
        synchronized (resourceManagerImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            connectionManagers = this._connectionManagers;
            this._connectionManagers = null;
            resources = this._resources;
            this._resources = null;
            timers = this._timers;
            this._timers = null;
        }
        for (i = 0; i < timers.size(); ++i) {
            SoftReference<Timer> timerRef = timers.get(i);
            Timer timer = timerRef.get();
            try {
                if (timer == null) continue;
                timer.cancel();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._workManager != null) {
            this._workManager.destroy();
        }
        for (i = 0; i < connectionManagers.size(); ++i) {
            ConnectionPool connectionManager = connectionManagers.get(i);
            try {
                connectionManager.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (i = 0; i < resources.size(); ++i) {
            ResourceAdapter resource = resources.get(i);
            try {
                resource.stop();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        if (this._loader != null) {
            return this.getClass().getSimpleName() + "[" + this._loader.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    public class TimerImpl
    extends Timer {
        private ResourceManagerImpl _rm;

        TimerImpl(ResourceManagerImpl rm) {
            super(true);
            this._rm = rm;
        }

        @Override
        public void cancel() {
            this._rm.removeTimer(this);
            super.cancel();
        }
    }
}

