/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class BytesMessageInputStream
extends InputStream {
    protected static Logger log = Logger.getLogger(BytesMessageInputStream.class.getName());
    private BytesMessage _message;

    public BytesMessageInputStream(BytesMessage message) {
        this._message = message;
    }

    @Override
    public int read() throws IOException {
        try {
            return this._message.readByte();
        }
        catch (JMSException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        try {
            if (offset == 0) {
                return this._message.readBytes(buffer, length);
            }
            return super.read(buffer, offset, length);
        }
        catch (JMSException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        try {
            return this._message.readBytes(buffer);
        }
        catch (JMSException e) {
            throw new IOException(e.toString());
        }
    }
}

