/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.env.thread.ThreadPool;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.LineMap;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.QJspFactory;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CompileException;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.jsp.JspFactory;

public class JspPrecompileResource {
    private static final Logger log = Logger.getLogger(JspPrecompileResource.class.getName());
    private static final L10N L = new L10N(JspPrecompileResource.class);
    private FileSetType _fileSet;
    private WebApp _webApp;
    private final Lifecycle _lifecycle = new Lifecycle();
    private int _threadCount = 1;
    private int _completeCount;
    private long _timeout = 60000L;

    public void setWebApp(WebApp app) {
        this._webApp = app;
    }

    public FileSetType createFileset() {
        if (this._fileSet == null) {
            this._fileSet = new FileSetType();
            this._fileSet.setDir(Vfs.lookup());
        }
        return this._fileSet;
    }

    public FileSetType createFileSet() {
        return this.createFileset();
    }

    public void setThreadCount(int count) {
    }

    public void setTimeoutMs(long timeout) {
        this._timeout = timeout;
    }

    @PostConstruct
    public void init() throws ConfigException {
        Path pwd = Vfs.lookup();
        if (this._fileSet == null) {
            this.createFileset().addInclude(new PathPatternType("**/*.jsp"));
        }
        if (this._webApp == null) {
            this._webApp = WebApp.getLocal();
        }
        if (this._webApp == null) {
            throw new ConfigException(L.l("JspPrecompileResource must be used in a web-app context."));
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
        ArrayList<Path> paths = this._fileSet.getPaths();
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < this._threadCount; ++i) {
            CompileTask task = new CompileTask(paths, classes);
            ThreadPool.getThreadPool().schedule(task);
        }
        long expire = CurrentTime.getCurrentTime() + this._timeout;
        JspPrecompileResource jspPrecompileResource = this;
        synchronized (jspPrecompileResource) {
            while (this._completeCount < this._threadCount) {
                try {
                    long timeout = expire - CurrentTime.getCurrentTime();
                    if (timeout <= 0L) {
                        log.fine(this.getClass().getSimpleName() + " timeout occured");
                        return;
                    }
                    this.wait(timeout);
                }
                catch (Exception exception) {}
            }
        }
    }

    class CompileTask
    implements Runnable {
        private int _chunkCount;
        private ArrayList<Path> _paths;
        private ArrayList<String> _classes;
        private JspCompiler _compiler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompileTask(ArrayList<Path> paths, ArrayList<String> classes) {
            this._paths = paths;
            this._classes = classes;
            ArrayList<Path> arrayList = this._paths;
            synchronized (arrayList) {
                this._chunkCount = (this._paths.size() + JspPrecompileResource.this._threadCount) / JspPrecompileResource.this._threadCount;
            }
            this._compiler = new JspCompiler();
            this._compiler.setWebApp(JspPrecompileResource.this._webApp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.compilePath()) {
                }
                while (this.compileClasses()) {
                }
            }
            finally {
                JspPrecompileResource jspPrecompileResource = JspPrecompileResource.this;
                synchronized (jspPrecompileResource) {
                    JspPrecompileResource.this._completeCount++;
                    JspPrecompileResource.this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean compilePath() {
            String contextPath = JspPrecompileResource.this._webApp.getContextPath();
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            Path pwd = Vfs.lookup();
            Path path = null;
            ArrayList<Path> arrayList = this._paths;
            synchronized (arrayList) {
                if (this._paths.size() == 0) {
                    return false;
                }
                path = this._paths.remove(0);
            }
            String uri = path.getPath().substring(pwd.getPath().length());
            if (JspPrecompileResource.this._webApp.getContext(contextPath + uri) != JspPrecompileResource.this._webApp) {
                return true;
            }
            String className = JspCompiler.urlToClassName(uri);
            try {
                CauchoPage page = (CauchoPage)this._compiler.loadClass(className, true);
                page.init(pwd);
                if (!page._caucho_isModified()) {
                    log.fine("pre-loaded " + uri);
                    return true;
                }
            }
            catch (ClassNotFoundException page) {
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
            log.fine("compiling " + uri);
            try {
                JspCompilerInstance compilerInst = this._compiler.getCompilerInstance(path, uri, className);
                JspGenerator generator = compilerInst.generate();
                if (generator.isStatic()) {
                    return true;
                }
                LineMap lineMap = generator.getLineMap();
                ArrayList<String> arrayList2 = this._classes;
                synchronized (arrayList2) {
                    this._classes.add(className.replace('.', '/') + ".java");
                }
            }
            catch (Exception e) {
                if (e instanceof CompileException) {
                    log.warning(e.getMessage());
                }
                log.log(Level.WARNING, e.toString(), e);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean compileClasses() {
            String[] files;
            ArrayList<String> arrayList = this._classes;
            synchronized (arrayList) {
                if (this._classes.size() == 0) {
                    return false;
                }
                files = new String[this._classes.size()];
                this._classes.toArray(files);
                this._classes.clear();
            }
            try {
                JavaCompilerUtil javaCompiler = JavaCompilerUtil.create(null);
                javaCompiler.setClassDir(this._compiler.getClassDir());
                javaCompiler.compileBatch(files);
            }
            catch (Exception e) {
                if (e instanceof CompileException) {
                    log.warning(e.getMessage());
                }
                log.log(Level.WARNING, e.toString(), e);
            }
            return true;
        }
    }
}

