/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.util.CaseInsensitiveHashMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.el.ELContext;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class ServletELContext
extends ELContext {
    public abstract ServletContext getApplication();

    public abstract Object getApplicationScope();

    public Object getCookie() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        HashMap<String, Cookie> map = new HashMap<String, Cookie>();
        Cookie[] cookies = this.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (map.get(cookies[i].getName()) != null) continue;
            map.put(cookies[i].getName(), cookies[i]);
        }
        return map;
    }

    public Object getHeader() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        CaseInsensitiveHashMap<String> map = new CaseInsensitiveHashMap<String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getHeader(name);
            ((HashMap)map).put(name, value);
        }
        return map;
    }

    public Object getHeader(String field) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getHeader(field);
        }
        return null;
    }

    public Object getHeaderValues() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        CaseInsensitiveHashMap<String[]> map = new CaseInsensitiveHashMap<String[]>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Enumeration values = request.getHeaders(name);
            ArrayList<String> list = new ArrayList<String>();
            while (values.hasMoreElements()) {
                list.add((String)values.nextElement());
            }
            ((HashMap)map).put(name, list.toArray(new String[list.size()]));
        }
        return map;
    }

    public Object getHeaderValues(String field) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            Enumeration values = request.getHeaders(field);
            ArrayList<String> list = new ArrayList<String>();
            while (values != null && values.hasMoreElements()) {
                list.add((String)values.nextElement());
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public Object getParameter() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    public Object getParameter(String field) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getParameter(field);
        }
        return null;
    }

    public Object getParameterValues() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = request.getParameterValues(name);
            map.put(name, values);
        }
        return map;
    }

    public Object getParameterValues(String field) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            String[] values = request.getParameterValues(field);
            return values;
        }
        return null;
    }

    public abstract HttpServletRequest getRequest();

    public abstract Object getRequestScope();

    public Object getSessionScope() {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = request.getAttribute(name);
            map.put(name, value);
        }
        return map;
    }
}

