/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class CoreUrlTag
extends TagSupport
implements NameValueTag {
    private static L10N L;
    private static String[] _shortEncoding;
    private String _value;
    private String _context;
    private String _var;
    private String _scope;
    private CharBuffer _url;

    public void setValue(String value) {
        this._value = value;
    }

    public void setContext(String context) {
        this._context = context;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    @Override
    public void addParam(String name, String value) {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        CoreUrlTag.addParam(this._url, name, value, encoding);
    }

    public int doStartTag() throws JspException {
        String value = this._value;
        String context = this._context;
        this._url = CoreUrlTag.normalizeURL(this.pageContext, value, context);
        return 1;
    }

    public int doEndTag() throws JspException {
        String value = CoreUrlTag.encodeURL(this.pageContext, this._url);
        try {
            if (this._var == null) {
                JspWriter out = this.pageContext.getOut();
                out.print(value);
            } else {
                CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public static CharBuffer normalizeURL(PageContext pageContext, String url, String context) throws JspException {
        if (context != null && context.length() != 0 && !context.startsWith("/")) {
            throw new JspException(L.l("URL context '{0}' must start with '/'", (Object)context));
        }
        if (!(context == null || url != null && url.startsWith("/"))) {
            throw new JspException(L.l("URL '{0}' must start with '/'", (Object)url));
        }
        CharBuffer value = new CharBuffer();
        if (url == null) {
            url = "";
        }
        int slash = url.indexOf(47);
        int colon = url.indexOf(58);
        if (colon > 0 && colon < slash) {
            value.append(url);
        } else if (slash == 0) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            if (context != null) {
                if (context.length() > 1) {
                    value.append(context);
                }
                value.append(url);
            } else {
                value.append(request.getContextPath());
                value.append(url);
            }
        } else if (context != null) {
            value.append(context);
            value.append(url);
        } else {
            value.append(url);
        }
        return value;
    }

    public static CharBuffer addParam(CharBuffer url, String name, String value, String encoding) {
        if (url.indexOf('?') < 0) {
            url.append('?');
        } else {
            url.append("&");
        }
        CoreUrlTag.addEncodedString(url, name, encoding);
        url.append('=');
        CoreUrlTag.addEncodedString(url, value, encoding);
        return url;
    }

    public static CharBuffer addEncodedString(CharBuffer cb, String value, String encoding) {
        if (encoding == null || encoding.equalsIgnoreCase("iso-8859-1")) {
            return CoreUrlTag.addEncodedLatin1(cb, value);
        }
        if (encoding.equalsIgnoreCase("utf8") || encoding.equalsIgnoreCase("utf-8")) {
            return CoreUrlTag.addEncodedUTF8(cb, value);
        }
        try {
            cb.append(URLEncoder.encode(value, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return cb;
    }

    public static CharBuffer addEncodedLatin1(CharBuffer cb, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                cb.append(_shortEncoding[ch]);
                continue;
            }
            cb.append('%');
            cb.append(CoreUrlTag.hex(ch >> 4));
            cb.append(CoreUrlTag.hex(ch & 0xF));
        }
        return cb;
    }

    public static CharBuffer addEncodedUTF8(CharBuffer cb, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            int d2;
            int d1;
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                cb.append(_shortEncoding[ch]);
                continue;
            }
            if (ch < '\u0800') {
                d1 = 192 + (ch >> 6 & 0x1F);
                d2 = 128 + (ch & 0x3F);
                cb.append('%');
                cb.append(CoreUrlTag.hex(d1 >> 4));
                cb.append(CoreUrlTag.hex(d1 & 0xF));
                cb.append('%');
                cb.append(CoreUrlTag.hex(d2 >> 4));
                cb.append(CoreUrlTag.hex(d2 & 0xF));
                continue;
            }
            d1 = 224 + (ch >> 12 & 0xF);
            d2 = 128 + (ch >> 6 & 0x3F);
            int d3 = 128 + (ch & 0x3F);
            cb.append('%');
            cb.append(CoreUrlTag.hex(d1 >> 4));
            cb.append(CoreUrlTag.hex(d1 & 0xF));
            cb.append('%');
            cb.append(CoreUrlTag.hex(d2 >> 4));
            cb.append(CoreUrlTag.hex(d2 & 0xF));
            cb.append('%');
            cb.append(CoreUrlTag.hex(d3 >> 4));
            cb.append(CoreUrlTag.hex(d3 & 0xF));
        }
        return cb;
    }

    public static String encodeURL(PageContext pageContext, CharBuffer url) {
        int slash;
        String value = url.toString();
        int colon = value.indexOf(58);
        if (colon < (slash = value.indexOf(47)) && slash > 0) {
            return value;
        }
        return ((HttpServletResponse)pageContext.getResponse()).encodeURL(value);
    }

    private static char hex(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(65 + d - 10);
    }

    static {
        int i;
        L = new L10N(CoreUrlTag.class);
        _shortEncoding = new String[128];
        for (i = 0; i < _shortEncoding.length; ++i) {
            CoreUrlTag._shortEncoding[i] = "%" + CoreUrlTag.hex(i / 16) + CoreUrlTag.hex(i);
        }
        for (i = 97; i <= 122; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 65; i <= 90; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 48; i <= 57; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        CoreUrlTag._shortEncoding[32] = "+";
        CoreUrlTag._shortEncoding[45] = "-";
        CoreUrlTag._shortEncoding[95] = "_";
        CoreUrlTag._shortEncoding[46] = ".";
        CoreUrlTag._shortEncoding[33] = "!";
        CoreUrlTag._shortEncoding[126] = "~";
        CoreUrlTag._shortEncoding[39] = "'";
    }
}

