/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.PathPatternType;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarListLoader;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Configurable
public class LibraryLoader
extends JarListLoader {
    private Path _path;
    private FileSetType _fileSet;
    private ArrayList<Path> _pathList = new ArrayList();
    private ArrayList<Path> _newPathList = new ArrayList();

    public LibraryLoader() {
    }

    public LibraryLoader(ClassLoader loader) {
        super(loader);
    }

    public LibraryLoader(ClassLoader loader, Path path) {
        this(loader);
        this._path = path;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setFileset(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        LibraryLoader dirLoader = new LibraryLoader(loader, path);
        dirLoader.init();
        loader.init();
        return loader;
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        super.init();
        try {
            if (this._fileSet == null) {
                if (this._path.getPath().endsWith(".jar") || this._path.getPath().endsWith(".zip")) {
                    this._fileSet = new FileSetType();
                    this._fileSet.setDir(this._path.getParent());
                    this._fileSet.addInclude(new PathPatternType(this._path.getTail()));
                } else {
                    this._fileSet = new FileSetType();
                    this._fileSet.setDir(this._path);
                    this._fileSet.addInclude(new PathPatternType("*.jar"));
                    this._fileSet.addInclude(new PathPatternType("*.zip"));
                }
            }
            this.fillJars();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public synchronized boolean isModified() {
        this._newPathList.clear();
        this._fileSet.getPaths(this._newPathList);
        return !this._newPathList.equals(this._pathList);
    }

    @Override
    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._path.getNativePath() + " has modified jar files");
            return true;
        }
        return false;
    }

    private void fillJars() {
        this._pathList.clear();
        this._jarList.clear();
        this._fileSet.getPaths(this._pathList);
        Collections.sort(this._pathList);
        for (int i = 0; i < this._pathList.size(); ++i) {
            Path jar = this._pathList.get(i);
            this.addJar(jar);
        }
    }

    public Path getCodePath() {
        return this._fileSet.getDir();
    }

    @Override
    protected void destroy() {
        super.destroy();
        this.clearJars();
    }

    @Override
    public String toString() {
        if (this._fileSet != null) {
            return this.getClass().getSimpleName() + "[" + this._fileSet + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }
}

