/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.bytecode.ByteCodeClassScanner;
import com.caucho.inject.Module;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Jar;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Module
public class ScanManager {
    private static final Logger log = Logger.getLogger(ScanManager.class.getName());
    private static ConcurrentHashMap<Path, Depend> _nullScanPathMap = new ConcurrentHashMap();
    private final ScanListener[] _listeners;

    public ScanManager(ArrayList<ScanListener> listeners) {
        this._listeners = new ScanListener[listeners.size()];
        listeners.toArray(this._listeners);
    }

    public void scan(EnvironmentClassLoader loader, URL url, String packageRoot) {
        this.scan(loader, Vfs.lookup(url), packageRoot);
    }

    public void scan(EnvironmentClassLoader loader, Path root, String packageRoot) {
        if (root.getPath().endsWith(".jar") && !(root instanceof JarPath)) {
            root = JarPath.create(root);
        }
        ScanListener[] listeners = new ScanListener[this._listeners.length];
        boolean hasListener = false;
        for (int i = 0; i < this._listeners.length; ++i) {
            if (!this._listeners[i].isRootScannable(root, packageRoot)) continue;
            listeners[i] = this._listeners[i];
            hasListener = true;
        }
        if (!hasListener) {
            return;
        }
        ByteCodeClassScanner scanner = new ByteCodeClassScanner();
        String packagePath = null;
        if (packageRoot != null) {
            packagePath = packageRoot.replace('.', '/');
        }
        if (root instanceof JarPath) {
            JarPath jarRoot = (JarPath)root;
            Path jar = jarRoot.getContainer();
            JarByteCodeMatcher matcher = new JarByteCodeMatcher(loader, root, packageRoot, listeners);
            this.scanForJarClasses(jar, packageRoot, scanner, matcher);
        } else {
            PathByteCodeMatcher matcher = new PathByteCodeMatcher(loader, root, packageRoot, listeners);
            Path scanRoot = root;
            if (packagePath != null) {
                scanRoot = scanRoot.lookup(packagePath);
            }
            this.scanForClasses(root, scanRoot, scanner, matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForClasses(Path root, Path path, ByteCodeClassScanner classScanner, PathByteCodeMatcher matcher) {
        try {
            if (path.isDirectory()) {
                for (String name : path.list()) {
                    if (name.indexOf(58) >= 0) continue;
                    this.scanForClasses(root, path.lookup(name), classScanner, matcher);
                }
                return;
            }
            if (!path.getPath().endsWith(".class")) {
                return;
            }
            matcher.init(root, path);
            try (ReadStream is = path.openRead();){
                classScanner.init(path.getPath(), is, matcher);
                classScanner.scan();
            }
        }
        catch (Exception e) {
            log.info(e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForJarClasses(Path path, String packagePath, ByteCodeClassScanner classScanner, JarByteCodeMatcher matcher) {
        if (this.isNullScanPath(path)) {
            return;
        }
        ZipFile zipFile = null;
        Jar jar = JarPath.create(path).getJar();
        try {
            zipFile = jar.getZipFile();
            if (zipFile == null) {
                return;
            }
            boolean isScanMatch = false;
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || packagePath != null && !entryName.startsWith(packagePath) || entryName.indexOf("-info") > 0) continue;
                matcher.init();
                ReadStream is = null;
                try {
                    is = Vfs.openRead(zipFile.getInputStream(entry));
                    classScanner.init(entryName, is, matcher);
                    if (!classScanner.scan()) continue;
                    isScanMatch = true;
                }
                catch (Exception e1) {
                    log.info(e1.toString());
                    log.log(Level.FINE, e1.toString(), e1);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (!isScanMatch) {
                this.addNullScanPath(path);
            }
        }
        catch (Exception e) {
            log.info(e.toString());
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            jar.closeZipFile(zipFile);
        }
    }

    private void addNullScanPath(Path path) {
        _nullScanPathMap.put(path, new Depend(path));
    }

    private boolean isNullScanPath(Path path) {
        Depend depend = _nullScanPathMap.get(path);
        return depend != null && !depend.isModified();
    }

    static abstract class ScanByteCodeMatcher
    implements ByteCodeClassMatcher {
        private Path _root;
        private String _packageRoot;
        private final ScanListener[] _listeners;
        private final ScanListener[] _currentListeners;
        private final ScanClass[] _currentClasses;

        ScanByteCodeMatcher(EnvironmentClassLoader loader, Path root, String packageRoot, ScanListener[] listeners) {
            this._root = root;
            this._packageRoot = packageRoot;
            this._listeners = listeners;
            this._currentListeners = new ScanListener[listeners.length];
            this._currentClasses = new ScanClass[listeners.length];
        }

        void init() {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._currentListeners[i] = this._listeners[i];
                this._currentClasses[i] = null;
            }
        }

        @Override
        public boolean scanClass(String className, int modifiers) {
            int activeCount = 0;
            for (int i = this._listeners.length - 1; i >= 0; --i) {
                ScanListener listener = this._currentListeners[i];
                if (listener == null) continue;
                ScanClass scanClass = null;
                try {
                    scanClass = listener.scanClass(this._root, this._packageRoot, className, modifiers);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.getMessage(), e);
                }
                if (scanClass != null) {
                    ++activeCount;
                    this._currentClasses[i] = scanClass;
                    continue;
                }
                this._currentListeners[i] = null;
            }
            return activeCount > 0;
        }

        @Override
        public void addInterface(char[] buffer, int offset, int length) {
            for (ScanClass scanClass : this._currentClasses) {
                if (scanClass == null) continue;
                scanClass.addInterface(buffer, offset, length);
            }
        }

        @Override
        public void addSuperClass(char[] buffer, int offset, int length) {
            for (ScanClass scanClass : this._currentClasses) {
                if (scanClass == null) continue;
                scanClass.addSuperClass(buffer, offset, length);
            }
        }

        @Override
        public void addClassAnnotation(char[] buffer, int offset, int length) {
            for (ScanClass scanClass : this._currentClasses) {
                if (scanClass == null) continue;
                scanClass.addClassAnnotation(buffer, offset, length);
            }
        }

        @Override
        public void addPoolString(char[] buffer, int offset, int length) {
            for (ScanClass scanClass : this._currentClasses) {
                if (scanClass == null) continue;
                scanClass.addPoolString(buffer, offset, length);
            }
        }

        @Override
        public boolean finishScan() {
            boolean isScanValue = false;
            for (ScanClass scanClass : this._currentClasses) {
                if (scanClass == null || !scanClass.finishScan()) continue;
                isScanValue = true;
            }
            return isScanValue;
        }

        @Override
        public boolean isAnnotationMatch(CharBuffer annotationClassName) {
            int activeCount = 0;
            for (int i = this._listeners.length - 1; i >= 0; --i) {
                ScanListener listener = this._currentListeners[i];
                if (listener == null) continue;
                if (listener.isScanMatchAnnotation(annotationClassName)) {
                    this._currentListeners[i] = null;
                    continue;
                }
                ++activeCount;
            }
            return activeCount == 0;
        }
    }

    static class PathByteCodeMatcher
    extends ScanByteCodeMatcher {
        private Path _root;
        private Path _path;

        PathByteCodeMatcher(EnvironmentClassLoader loader, Path root, String packageName, ScanListener[] listeners) {
            super(loader, root, packageName, listeners);
        }

        void init(Path root, Path path) {
            super.init();
            this._root = root;
            this._path = path;
        }

        String getClassName() {
            String rootName = this._root.getFullPath();
            String name = this._path.getFullPath();
            int p = name.lastIndexOf(46);
            String className = name.substring(rootName.length(), p);
            return className.replace('/', '.');
        }
    }

    static class JarByteCodeMatcher
    extends ScanByteCodeMatcher {
        JarByteCodeMatcher(EnvironmentClassLoader loader, Path root, String packageName, ScanListener[] listeners) {
            super(loader, root, packageName, listeners);
        }
    }
}

