/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class RotateStream
extends StreamImpl {
    private static HashMap<Path, WeakReference<RotateStream>> _streams = new HashMap();
    private static HashMap<String, WeakReference<RotateStream>> _formatStreams = new HashMap();
    private final AbstractRolloverLog _rolloverLog = new AbstractRolloverLog();
    private volatile AtomicBoolean _isInit = new AtomicBoolean();

    private RotateStream(Path path) {
        this._rolloverLog.setPath(path);
    }

    private RotateStream(String formatPath) throws ConfigException {
        this._rolloverLog.setPathFormat(formatPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(Path path) {
        HashMap<Path, WeakReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            RotateStream stream;
            WeakReference<RotateStream> ref = _streams.get(path);
            RotateStream rotateStream = stream = ref != null ? (RotateStream)ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _streams.put(path, new WeakReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(String path) throws ConfigException {
        HashMap<String, WeakReference<RotateStream>> hashMap = _formatStreams;
        synchronized (hashMap) {
            RotateStream stream;
            WeakReference<RotateStream> ref = _formatStreams.get(path);
            RotateStream rotateStream = stream = ref != null ? (RotateStream)ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _formatStreams.put(path, new WeakReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RotateStream stream2;
        HashMap<Object, WeakReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            for (WeakReference<RotateStream> streamRef : _streams.values()) {
                try {
                    stream2 = (RotateStream)streamRef.get();
                    if (stream2 == null) continue;
                    stream2.closeImpl();
                }
                catch (Throwable stream2) {}
            }
            _streams.clear();
        }
        hashMap = _formatStreams;
        synchronized (hashMap) {
            for (WeakReference<RotateStream> streamRef : _formatStreams.values()) {
                try {
                    stream2 = (RotateStream)streamRef.get();
                    if (stream2 == null) continue;
                    stream2.closeImpl();
                }
                catch (Throwable throwable) {}
            }
            _formatStreams.clear();
        }
    }

    public AbstractRolloverLog getRolloverLog() {
        return this._rolloverLog;
    }

    public void setMaxRolloverCount(int count) {
        this._rolloverLog.setRolloverCount(count);
    }

    public void setRolloverPeriod(long period) {
        this._rolloverLog.setRolloverPeriod(new Period(period));
    }

    public void setRolloverSize(long size) {
        this._rolloverLog.setRolloverSize(new Bytes(size));
    }

    public void setArchiveFormat(String format) {
        this._rolloverLog.setArchiveFormat(format);
    }

    public void init() throws IOException {
        this._rolloverLog.init();
    }

    @Override
    public Path getPath() {
        return this._rolloverLog.getPath();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        this._rolloverLog.rollover();
        this._rolloverLog.write(buffer, offset, length);
        this._rolloverLog.rollover();
    }

    public WriteStream getStream() {
        return new WriteStream(this);
    }

    @Override
    public void flush() throws IOException {
        this._rolloverLog.flush();
        this._rolloverLog.rollover();
    }

    @Override
    public void close() {
    }

    private void closeImpl() {
        try {
            this._rolloverLog.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.closeImpl();
    }
}

