/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.mail.smtp;

import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SmtpTransport
extends Transport {
    private static final L10N L = new L10N(SmtpTransport.class);
    private static final Logger log = Logger.getLogger(SmtpTransport.class.getName());
    private Socket _socket;
    private ReadStream _is;
    private WriteStream _os;

    public SmtpTransport(Session session, URLName urlName) {
        super(session, urlName);
    }

    protected boolean protocolConnect(String host, int port, String user, String password) throws MessagingException {
        if (host == null) {
            host = "localhost";
        }
        if (port < 0) {
            port = 25;
        }
        if (this._socket != null) {
            throw new MessagingException(L.l("Attempted to connect to open connection."));
        }
        try {
            this._socket = new Socket(host, port);
            this._socket.setSoTimeout(10000);
            SocketStream s = new SocketStream(this._socket);
            this._os = new WriteStream(s);
            this._is = new ReadStream(s, this._os);
            String line = this._is.readLine();
            log.fine("smtp connection to " + host + ":" + port + " succeeded");
            log.fine("smtp: " + line);
            this._os.print("EHLO " + CauchoSystem.getLocalHost() + "\r\n");
            this._os.flush();
            this.readResponse();
            this.setConnected(true);
        }
        catch (IOException e) {
            log.fine("smtp connection to " + host + ":" + port + " failed: " + e);
            log.log(Level.FINER, e.toString(), e);
            throw new MessagingException("smtp connection to " + host + ":" + port + " failed.\n" + e);
        }
        return true;
    }

    public void sendMessage(Message msg, Address[] addresses) throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Transport does not have an active connection.");
        }
        if (!(msg instanceof MimeMessage)) {
            throw new MessagingException("message must be a MimeMessage at '" + msg.getClass().getName() + "'");
        }
        MimeMessage mimeMsg = (MimeMessage)msg;
        try {
            String[] fromList = mimeMsg.getHeader("From");
            if (fromList == null || fromList.length < 1) {
                throw new MessagingException("message should have a sender");
            }
            String from = fromList[0];
            this._os.print("MAIL FROM:<" + from + ">\r\n");
            this._os.flush();
            if (log.isLoggable(Level.FINER)) {
                log.finer("mail from:<" + from + ">");
            }
            this.readResponse();
            for (int i = 0; i < addresses.length; ++i) {
                InternetAddress addr = (InternetAddress)addresses[i];
                if (log.isLoggable(Level.FINER)) {
                    log.finer("mail to:<" + addr.getAddress() + ">");
                }
                this._os.print("RCPT TO:<" + addr.getAddress() + ">\r\n");
                this._os.flush();
                this.readResponse();
            }
            this._os.print("DATA\r\n");
            this._os.flush();
            String line = this._is.readLine();
            if (!line.startsWith("354 ")) {
                throw new MessagingException("Data not accepted: " + line);
            }
            mimeMsg.writeTo((OutputStream)new DataFilter(this._os));
            this._os.print("\r\n.\r\n");
            this._os.flush();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            throw new MessagingException(e.toString());
        }
    }

    private int readResponse() throws IOException, MessagingException {
        int status;
        String line;
        do {
            if ((line = this._is.readLine()).length() < 4) {
                throw new MessagingException(line);
            }
            status = 0;
            for (int i = 0; i < 3; ++i) {
                char ch = line.charAt(i);
                if ('0' > ch || ch > '9') continue;
                status = 10 * status + ch - 48;
            }
            if (status / 100 % 10 == 2) continue;
            throw new MessagingException(line);
        } while (line.charAt(3) == '-');
        return status;
    }

    public void close() throws MessagingException {
        Socket socket = this._socket;
        this._socket = null;
        WriteStream os = this._os;
        this._os = null;
        this.setConnected(false);
        try {
            if (os != null) {
                os.print("QUIT\r\n");
                os.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class DataFilter
    extends OutputStream {
        private OutputStream _os;
        private boolean _isCr;
        private boolean _isLf;

        DataFilter(OutputStream os) {
            this._os = os;
        }

        @Override
        public void write(int ch) throws IOException {
            switch (ch) {
                case 13: {
                    this._isCr = true;
                    this._isLf = false;
                    break;
                }
                case 10: {
                    this._isLf = this._isCr;
                    this._isCr = false;
                    break;
                }
                case 46: {
                    if (this._isLf) {
                        this._os.write(46);
                    }
                    this._isLf = false;
                    this._isCr = false;
                    break;
                }
                default: {
                    this._isLf = false;
                    this._isCr = false;
                }
            }
            this._os.write(ch);
        }
    }
}

