/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.memcached;

import com.caucho.distcache.ClusterCache;
import com.caucho.distcache.ResinCacheBuilder;
import com.caucho.memcached.MemcachedConnection;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import javax.annotation.PostConstruct;

public class MemcachedProtocol
implements Protocol {
    private ClusterCache _cache = new ClusterCache();

    public MemcachedProtocol() {
        this._cache.setName("memcache");
        this._cache.setLocalExpireTimeoutMillis(1000L);
        this._cache.setLeaseExpireTimeoutMillis(3600000L);
    }

    public void setMode(ResinCacheBuilder.Scope scope) {
        this._cache.setScopeMode(scope);
    }

    @PostConstruct
    public void init() {
        this._cache.init();
    }

    ClusterCache getCache() {
        return this._cache;
    }

    @Override
    public ProtocolConnection createConnection(SocketLink link) {
        return new MemcachedConnection(this, link);
    }

    @Override
    public String getProtocolName() {
        return "memcache";
    }
}

