/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.bam;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.bam.broker.Broker;
import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.ResinQuercus;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.bam.BamEventType;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class BamPhpActor
extends SimpleActor {
    private static final L10N L = new L10N(BamPhpActor.class);
    private static final Logger log = Logger.getLogger(BamPhpActor.class.getName());
    private final QuercusContext _quercus = new ResinQuercus();
    private final HashMap<String, BamPhpActor> _children = new HashMap();
    private ArrayList<String> _featureNames = new ArrayList();
    private Path _script;
    private QuercusPage _page;
    private String _encoding = "ISO-8859-1";
    @Inject
    private Broker _broker;

    public BamPhpActor() {
    }

    public BamPhpActor(Path script, String encoding) {
        this._script = script;
        this._encoding = encoding;
    }

    public Path getScript() {
        return this._script;
    }

    public void setScript(Path script) {
        this._script = script;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._script == null) {
            throw new ConfigException(L.l("script path not specified"));
        }
        this._quercus.init();
        this._quercus.start();
        try {
            this._page = this._quercus.parse(this._script);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasChild(String address) {
        HashMap<String, BamPhpActor> hashMap = this._children;
        synchronized (hashMap) {
            return this._children.containsKey(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(String address, BamPhpActor child) {
        HashMap<String, BamPhpActor> hashMap = this._children;
        synchronized (hashMap) {
            this._children.put(address, child);
        }
    }

    private void setId(Env env, long id) {
        env.setGlobalValue("_quercus_bam_id", (Value)LongValue.create((long)id));
    }

    private void setError(Env env, BamError error) {
        NullValue errorValue = NullValue.NULL;
        if (error != null) {
            JavaClassDef errorClassDef = env.getJavaClassDefinition(BamError.class);
            errorValue = errorClassDef.wrap(env, (Object)error);
        }
        env.setGlobalValue("_quercus_bam_error", (Value)errorValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(String to, String from, Serializable value) {
        try (Env env = this.createEnv(this._page, BamEventType.MESSAGE, to, from, value);){
            this._page.executeTop(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageError(String to, String from, Serializable value, BamError error) {
        try (Env env = this.createEnv(this._page, BamEventType.MESSAGE_ERROR, to, from, value);){
            this.setError(env, error);
            this._page.executeTop(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(long id, String to, String from, Serializable value) {
        BamEventType eventType = BamEventType.QUERY_GET;
        boolean understood = false;
        try (Env env = this.createEnv(this._page, eventType, to, from, value);){
            this.setId(env, id);
            this._page.executeTop(env);
            if (eventType == BamEventType.GET_DISCO_FEATURES) {
                this._featureNames.clear();
                Value returnValue = env.getGlobalValue("_quercus_bam_function_return");
                if (returnValue.isArray()) {
                    this._featureNames = (ArrayList)returnValue.toJavaList(env, ArrayList.class);
                }
            } else {
                understood = env.getGlobalValue("_quercus_bam_function_return").toBoolean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryResult(long id, String to, String from, Serializable value) {
        try (Env env = this.createEnv(this._page, BamEventType.QUERY_RESULT, to, from, value);){
            this.setId(env, id);
            this._page.executeTop(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryError(long id, String to, String from, Serializable value, BamError error) {
        try (Env env = this.createEnv(this._page, BamEventType.QUERY_ERROR, to, from, value);){
            this.setId(env, id);
            this.setError(env, error);
            this._page.executeTop(env);
        }
    }

    private Env createEnv(QuercusPage page, BamEventType type, String to, String from, Serializable value) {
        NullWriteStream out = new NullWriteStream();
        Env env = new Env(this._quercus, page, (WriteStream)out, null, null);
        JavaClassDef actorClassDef = env.getJavaClassDefinition(BamPhpActor.class);
        env.setGlobalValue("_quercus_bam_actor", actorClassDef.wrap(env, (Object)this));
        env.start();
        JavaClassDef eventClassDef = env.getJavaClassDefinition(BamEventType.class);
        Value typeValue = eventClassDef.wrap(env, (Object)type);
        env.setGlobalValue("_quercus_bam_event_type", typeValue);
        env.setGlobalValue("_quercus_bam_to", StringValue.create((String)to));
        env.setGlobalValue("_quercus_bam_from", StringValue.create((String)from));
        NullValue javaValue = NullValue.NULL;
        if (value != null) {
            JavaClassDef classDef = env.getJavaClassDefinition(value.getClass());
            javaValue = classDef.wrap(env, (Object)value);
        }
        env.setGlobalValue("_quercus_bam_value", (Value)javaValue);
        return env;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[address=" + this.getAddress() + ",script=" + this._script + "]";
    }
}

