/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.AnyNamePattern;
import com.caucho.relaxng.pattern.AttributePattern;
import com.caucho.relaxng.pattern.ChoiceNamePattern;
import com.caucho.relaxng.pattern.ChoicePattern;
import com.caucho.relaxng.pattern.DataPattern;
import com.caucho.relaxng.pattern.ElementPattern;
import com.caucho.relaxng.pattern.EmptyPattern;
import com.caucho.relaxng.pattern.GrammarPattern;
import com.caucho.relaxng.pattern.GroupPattern;
import com.caucho.relaxng.pattern.InterleavePattern;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.pattern.NamePattern;
import com.caucho.relaxng.pattern.NsNamePattern;
import com.caucho.relaxng.pattern.Pattern;
import com.caucho.relaxng.pattern.RefPattern;
import com.caucho.relaxng.pattern.TextPattern;
import com.caucho.relaxng.pattern.ZeroOrMorePattern;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompactParser {
    private static final L10N L = new L10N(CompactParser.class);
    private static final Logger log = Logger.getLogger(CompactParser.class.getName());
    private static final boolean[] NAME_CHAR;
    private static final int IDENTIFIER = 256;
    private static final int NAMESPACE = 257;
    private static final int DEFAULT = 258;
    private static final int START = 259;
    private static final int DIV = 260;
    private static final int INCLUDE = 261;
    private static final int ELEMENT = 262;
    private static final int ATTRIBUTE = 263;
    private static final int TEXT = 264;
    private static final int STRING = 265;
    private static final int TOKEN = 266;
    private static final int LITERAL = 267;
    private static final int EMPTY = 268;
    private static final int COMMENT = 269;
    private static final IntMap _tokenMap;
    private GrammarPattern _grammar;
    private Pattern _pattern;
    private String _ns = "";
    private HashMap<String, String> _nsMap;
    private Path _pwd;
    private ReadStream _is;
    private String _filename;
    private int _line;
    private int _peekToken = -1;
    private final byte[] _buffer = new byte[256];
    private int _offset;
    private int _length;
    private CharBuffer _cb = new CharBuffer(256);
    private String _lexeme;
    private int _generatedId;

    CompactParser() {
    }

    public GrammarPattern getGrammar() {
        return this._grammar;
    }

    public void setGeneratedId(int id) {
        this._generatedId = id;
    }

    public String generateId() {
        this._cb.setLength(0);
        this._cb.append("__caucho_");
        this._cb.append(this._generatedId++);
        return this._cb.toString();
    }

    public void parse(InputSource source) throws SAXException, IOException, RelaxException {
        InputStream is = source.getByteStream();
        this._pwd = null;
        if (is instanceof ReadStream) {
            this._is = (ReadStream)is;
            this._filename = this._is.getUserPath();
            this._pwd = this._is.getPath().getParent();
        }
        this._is = is != null ? Vfs.openRead(is) : Vfs.openRead(source.getSystemId());
        if (this._filename == null) {
            this._filename = source.getSystemId();
        }
        this._line = 1;
        if (this._pwd == null) {
            this._pwd = Vfs.lookup(this._filename).getParent();
        }
        try {
            this.parse();
        }
        catch (RelaxException e) {
            log.log(Level.FINER, e.toString(), e);
            throw new SAXException(this._filename + ":" + this._line + ": " + e.getMessage());
        }
        finally {
            this._is.close();
        }
    }

    private void parse() throws SAXException, IOException, RelaxException {
        int token;
        this._grammar = new GrammarPattern();
        this._nsMap = new HashMap();
        this.parseDeclarations();
        this._peekToken = token = this.parseToken();
        switch (token) {
            case 256: 
            case 259: 
            case 261: {
                this.parseGrammar(this._grammar);
                break;
            }
            case 269: {
                break;
            }
            default: {
                this._grammar.setStart(this.parsePattern(this._grammar));
            }
        }
    }

    private void parseDeclarations() throws SAXException, IOException, RelaxException {
        block4: while (true) {
            int token;
            this._peekToken = token = this.parseToken();
            switch (token) {
                case 257: 
                case 258: {
                    this.parseNamespace();
                    continue block4;
                }
                case 269: {
                    continue block4;
                }
            }
            break;
        }
    }

    private void parseNamespace() throws SAXException, IOException, RelaxException {
        boolean isDefault = false;
        int token = this.parseToken();
        if (token == 258) {
            isDefault = true;
            token = this.parseToken();
        }
        if (token != 257) {
            throw this.error(L.l("expected 'namespace' at {0}", (Object)this.errorToken(token)));
        }
        token = this.parseToken();
        if (token != 256) {
            throw this.error(L.l("expected identifier at {0}", (Object)this.errorToken(token)));
        }
        String prefix = this._lexeme;
        token = this.parseToken();
        if (token != 61) {
            throw this.error(L.l("expected '=' at {0}", (Object)this.errorToken(token)));
        }
        String value = this.parseLiteral();
        if (isDefault) {
            this._ns = value;
        }
        this._nsMap.put(prefix, value);
    }

    private void parseGrammar(GrammarPattern grammar) throws IOException, SAXException, RelaxException, RelaxException {
        int token;
        block7: while (true) {
            token = this.parseToken();
            switch (token) {
                case -1: {
                    return;
                }
                case 269: {
                    continue block7;
                }
                case 259: {
                    int next = this.parseToken();
                    if (next == 61) {
                        grammar.setStart(this.parsePattern(grammar));
                        continue block7;
                    }
                    throw this.error(L.l("expected '=' at {0}", (Object)this.errorToken(next)));
                }
                case 256: {
                    String name = this._lexeme;
                    int next = this.parseToken();
                    if (next == 61) {
                        if (grammar.getDefinition(name) != null) {
                            throw this.error(L.l("duplicate definition of {0}", (Object)name));
                        }
                        grammar.setDefinition(name, this.parsePattern(grammar));
                        continue block7;
                    }
                    throw this.error(L.l("expected '=' at {0}", (Object)this.errorToken(next)));
                }
                case 261: {
                    this.parseInclude(grammar);
                    continue block7;
                }
            }
            break;
        }
        throw this.error(L.l("unexpected token {0}", (Object)this.errorToken(token)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInclude(GrammarPattern grammar) throws IOException, SAXException, RelaxException {
        String uri = this.parseLiteral();
        Path sub = this._pwd.lookup(uri);
        try (ReadStream is = null;){
            is = sub.openRead();
            InputSource source = new InputSource(is);
            source.setSystemId(uri);
            CompactParser parser = new CompactParser();
            parser.setGeneratedId(this._generatedId);
            parser.parse(source);
            GrammarPattern subGrammar = parser.getGrammar();
            this._generatedId = parser._generatedId;
            grammar.mergeInclude(subGrammar);
        }
    }

    private Pattern parsePattern(GrammarPattern grammar) throws IOException, SAXException, RelaxException {
        Pattern pattern = this.parseTerm(grammar);
        int token = this.parseToken();
        switch (token) {
            case 124: {
                return this.parseChoicePattern(grammar, pattern);
            }
            case 38: {
                return this.parseInterleavePattern(grammar, pattern);
            }
            case 44: {
                return this.parseGroupPattern(grammar, pattern);
            }
        }
        this._peekToken = token;
        return pattern;
    }

    private Pattern parseInterleavePattern(GrammarPattern grammar, Pattern pattern) throws IOException, SAXException, RelaxException {
        int token;
        do {
            if (!(pattern instanceof InterleavePattern)) {
                Pattern child = pattern;
                pattern = new InterleavePattern();
                pattern.addChild(child);
            }
            pattern.addChild(this.parseTerm(grammar));
        } while ((token = this.parseToken()) == 38);
        this._peekToken = token;
        return pattern;
    }

    private Pattern parseGroupPattern(GrammarPattern grammar, Pattern pattern) throws IOException, SAXException, RelaxException {
        int token;
        do {
            if (!(pattern instanceof GroupPattern)) {
                Pattern child = pattern;
                pattern = new GroupPattern();
                pattern.addChild(child);
            }
            pattern.addChild(this.parseTerm(grammar));
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
        return pattern;
    }

    private Pattern parseChoicePattern(GrammarPattern grammar, Pattern pattern) throws IOException, SAXException, RelaxException {
        int token;
        do {
            if (!(pattern instanceof ChoicePattern)) {
                Pattern child = pattern;
                pattern = new ChoicePattern();
                pattern.addChild(child);
            }
            pattern.addChild(this.parseTerm(grammar));
        } while ((token = this.parseToken()) == 124);
        this._peekToken = token;
        return pattern;
    }

    private Pattern parseTerm(GrammarPattern grammar) throws IOException, SAXException, RelaxException {
        Pattern pattern;
        int token = this.parseToken();
        while (token == 269) {
            token = this.parseToken();
        }
        switch (token) {
            case 268: {
                return new EmptyPattern();
            }
            case 264: {
                return new TextPattern();
            }
            case 265: 
            case 267: {
                return new DataPattern("string");
            }
            case 266: {
                return new DataPattern("token");
            }
            case 262: {
                pattern = this.parseElement(grammar);
                break;
            }
            case 263: {
                pattern = this.parseAttribute(grammar);
                break;
            }
            case 40: {
                pattern = this.parsePattern(grammar);
                token = this.parseToken();
                if (token == 41) break;
                throw this.error(L.l("expected ')' at {0}", (Object)this.errorToken(token)));
            }
            case 256: {
                pattern = new RefPattern(this._grammar, this._lexeme);
                pattern.setFilename(this._filename);
                pattern.setLine(this._line);
                break;
            }
            default: {
                throw this.error(L.l("unknown token {0}", (Object)this.errorToken(token)));
            }
        }
        token = this.parseToken();
        if (token == 42) {
            pattern = new ZeroOrMorePattern(pattern);
        } else {
            if (token == 63) {
                ChoicePattern choice = new ChoicePattern();
                choice.addChild(new EmptyPattern());
                choice.addChild(pattern);
                return choice;
            }
            if (token == 43) {
                GroupPattern group = new GroupPattern();
                group.addChild(pattern);
                group.addChild(new ZeroOrMorePattern(pattern));
                return group;
            }
            this._peekToken = token;
        }
        return pattern;
    }

    private Pattern parseElement(GrammarPattern grammar) throws IOException, SAXException, RelaxException {
        String id = this.generateId();
        ElementPattern elt = new ElementPattern(id);
        grammar.setDefinition(id, elt);
        elt.addNameChild(this.parseNameClass(grammar, true));
        int token = this.parseToken();
        if (token == 123) {
            elt.addChild(this.parsePattern(grammar));
            token = this.parseToken();
            if (token != 125) {
                throw this.error(L.l("expected '}' at {0}", (Object)this.errorToken(token)));
            }
        }
        return elt;
    }

    private Pattern parseAttribute(GrammarPattern grammar) throws IOException, SAXException, RelaxException {
        AttributePattern elt = new AttributePattern();
        elt.addNameChild(this.parseNameClass(grammar, false));
        int token = this.parseToken();
        if (token == 123) {
            token = this.parseToken();
            if (token == 125) {
                return elt;
            }
            this._peekToken = token;
            elt.addChild(this.parsePattern(grammar));
            token = this.parseToken();
            if (token != 125) {
                throw this.error(L.l("expected '}' at {0}", (Object)this.errorToken(token)));
            }
        }
        return elt;
    }

    private NameClassPattern parseNameClass(GrammarPattern grammar, boolean isElement) throws IOException, SAXException, RelaxException {
        int ch;
        NameClassPattern left = this.parseName(grammar, isElement);
        ChoiceNamePattern choice = null;
        while ((ch = this.skipWhitespace()) == 124) {
            NameClassPattern right = this.parseName(grammar, isElement);
            if (choice == null) {
                choice = new ChoiceNamePattern();
                choice.addNameChild(left);
            }
            choice.addNameChild(right);
        }
        this.unread();
        if (choice != null) {
            return choice;
        }
        return left;
    }

    private NameClassPattern parseName(GrammarPattern grammar, boolean isElement) throws IOException, SAXException, RelaxException {
        NameClassPattern namePattern;
        String localName;
        int ch = this.skipWhitespace();
        if (ch == 40) {
            NameClassPattern name = this.parseNameClass(grammar, isElement);
            ch = this.skipWhitespace();
            if (ch != 41) {
                throw this.error(L.l("expected ')' at '{0}'", (Object)String.valueOf((char)ch)));
            }
            return name;
        }
        char[] cbuf = this._cb.getBuffer();
        byte[] buffer = this._buffer;
        int i = 0;
        int offset = this._offset;
        int length = this._length;
        while (ch > 0 && ch < 256 && NAME_CHAR[ch]) {
            cbuf[i++] = (char)ch;
            if (offset < length) {
                if ((ch = buffer[offset++] & 0xFF) != 10) continue;
                ++this._line;
                continue;
            }
            this._offset = offset;
            this._length = length;
            ch = this.read();
            offset = this._offset;
            length = this._length;
        }
        this._offset = offset;
        this._length = length;
        this._cb.setLength(i);
        if (ch == 42) {
            this._cb.append('*');
        } else {
            this.unread();
        }
        if (this._cb.length() == 0) {
            throw this.error(L.l("expected name at '{0}'", (Object)String.valueOf((char)ch)));
        }
        String lexeme = this._cb.toString();
        int p = lexeme.lastIndexOf(58);
        String ns = this._ns;
        if (p < 0) {
            localName = lexeme;
            if (!isElement) {
                ns = null;
            }
        } else {
            String prefix = lexeme.substring(0, p);
            localName = lexeme.substring(p + 1);
            ns = this._nsMap.get(prefix);
            if (ns == null && localName.equals("*")) {
                throw this.error(L.l("'{0}' does not match a defined namespace.", (Object)lexeme));
            }
            if (ns == null) {
                NamePattern pattern = this.createNamePattern(lexeme, "");
                return pattern;
            }
        }
        if (lexeme.equals("*")) {
            namePattern = new AnyNamePattern();
            ((AnyNamePattern)namePattern).setExcept(this.parseExcept(grammar, isElement));
            return namePattern;
        }
        if (localName.equals("*")) {
            namePattern = new NsNamePattern(lexeme, ns);
            ((NsNamePattern)namePattern).setExcept(this.parseExcept(grammar, isElement));
            return namePattern;
        }
        if ("".equals(ns) || ns == null) {
            NamePattern pattern = this.createNamePattern(localName, "");
            return pattern;
        }
        NamePattern pattern = this.createNamePattern(lexeme, ns);
        return pattern;
    }

    private NamePattern createNamePattern(String localName, String namespace) {
        return new NamePattern(new QName(localName, namespace));
    }

    private NameClassPattern parseExcept(GrammarPattern grammar, boolean isElement) throws IOException, SAXException, RelaxException {
        int ch = this.skipWhitespace();
        if (ch != 45) {
            this.unread();
            return null;
        }
        return this.parseName(grammar, isElement);
    }

    private int parseToken() throws IOException, SAXException, RelaxException {
        int ch = this._peekToken;
        if (ch >= 0) {
            this._peekToken = -1;
            return ch;
        }
        CharBuffer cb = this._cb;
        cb.clear();
        byte[] buffer = this._buffer;
        block7: while (true) {
            if (this._offset < this._length) {
                if ((ch = buffer[this._offset++]) == 10) {
                    ++this._line;
                }
            } else {
                ch = this.read();
            }
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block7;
                }
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 63: 
                case 123: 
                case 124: 
                case 125: {
                    return ch;
                }
                case 34: 
                case 39: {
                    this.unread();
                    this._lexeme = this.parseLiteral();
                    return 267;
                }
                case 35: {
                    do {
                        if ((ch = this.read()) != 35) {
                            throw this.error(L.l("expected '#' at '{0}'", (Object)String.valueOf((char)ch)));
                        }
                        if (cb.length() > 0) {
                            cb.append('\n');
                        }
                        ch = this.read();
                        while (ch > 0 && ch != 10 && ch != 13) {
                            cb.append((char)ch);
                            ch = this.read();
                        }
                        if (ch != 13 || (ch = this.read()) == 10) continue;
                        this.unread();
                    } while ((ch = this.read()) == 35);
                    this.unread();
                    return 269;
                }
                case -1: {
                    cb.append("end of file");
                    return -1;
                }
            }
            break;
        }
        if (XmlChar.isNameStart(ch)) {
            char[] cbuf = cb.getBuffer();
            int i = 0;
            while (ch > 0 && ch < 256 && NAME_CHAR[ch]) {
                cbuf[i++] = (char)ch;
                if (this._offset < this._length) {
                    if ((ch = buffer[this._offset++] & 0xFF) != 10) continue;
                    ++this._line;
                    continue;
                }
                ch = this.read();
            }
            cb.setLength(i);
            this.unread();
            int token = _tokenMap.get(cb);
            if (token > 0) {
                this._lexeme = null;
                return token;
            }
            this._lexeme = this._cb.toString().intern();
            return 256;
        }
        if (ch < 0) {
            cb.append("end of file");
            return -1;
        }
        throw this.error(L.l("Unknown character '{0}'", (Object)String.valueOf((char)ch)));
    }

    private String parseLiteral() throws IOException, SAXException, RelaxException {
        int end = this.skipWhitespace();
        if (end != 34 && end != 39) {
            throw this.error(L.l("expected '\"' at '{0}'", (Object)String.valueOf((char)end)));
        }
        this._cb.clear();
        int ch = this.read();
        while (ch >= 0 && ch != end) {
            this._cb.append((char)ch);
            ch = this.read();
        }
        if (ch != end) {
            throw this.error(L.l("expected '\"' at '{0}'", (Object)String.valueOf((char)ch)));
        }
        return this._cb.toString();
    }

    private String parseIdentifier() throws IOException, SAXException, RelaxException {
        int ch = this.skipWhitespace();
        if (!XmlChar.isNameChar(ch)) {
            throw this.error(L.l("expected identifier character at '{0}'", (Object)String.valueOf((char)ch)));
        }
        this._cb.clear();
        while (XmlChar.isNameChar(ch)) {
            this._cb.append((char)ch);
            ch = this.read();
        }
        return this._cb.toString();
    }

    private int skipWhitespace() throws IOException, SAXException {
        int ch = this.read();
        while (XmlChar.isWhitespace(ch)) {
            ch = this.read();
        }
        return ch;
    }

    private String errorToken(int ch) {
        switch (ch) {
            case -1: {
                return "end of file";
            }
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: 
            case 63: 
            case 123: 
            case 124: 
            case 125: {
                return String.valueOf((char)ch);
            }
        }
        return this._cb.toString();
    }

    private SAXException error(String msg) {
        return new SAXException(this._filename + ":" + this._line + ": " + msg);
    }

    private int read() throws IOException {
        int offset = this._offset;
        if (this._length <= offset) {
            this.fillBuffer();
            offset = this._offset;
            if (this._length < 0) {
                return -1;
            }
        }
        int ch = this._buffer[offset++];
        this._offset = offset;
        if (ch == 10) {
            ++this._line;
        } else if (ch == 13) {
            ++this._line;
            if (this._length <= this._offset) {
                this.fillBuffer();
            }
            if ((ch = this._buffer[this._offset++]) != 10) {
                this.unread();
                ch = 10;
            }
        }
        return ch;
    }

    private void fillBuffer() throws IOException {
        this._length = this._is.read(this._buffer, 0, this._buffer.length);
        this._offset = 0;
    }

    private void unread() {
        if (this._offset > 0) {
            --this._offset;
            byte ch = this._buffer[this._offset];
            if (ch == 10) {
                --this._line;
            }
        }
    }

    static {
        _tokenMap = new IntMap();
        _tokenMap.put(new CharBuffer("namespace"), 257);
        _tokenMap.put(new CharBuffer("default"), 258);
        _tokenMap.put(new CharBuffer("start"), 259);
        _tokenMap.put(new CharBuffer("div"), 260);
        _tokenMap.put(new CharBuffer("element"), 262);
        _tokenMap.put(new CharBuffer("attribute"), 263);
        _tokenMap.put(new CharBuffer("text"), 264);
        _tokenMap.put(new CharBuffer("string"), 265);
        _tokenMap.put(new CharBuffer("token"), 266);
        _tokenMap.put(new CharBuffer("empty"), 268);
        _tokenMap.put(new CharBuffer("include"), 261);
        NAME_CHAR = new boolean[256];
        for (int i = 0; i < NAME_CHAR.length; ++i) {
            if (!XmlChar.isNameChar((char)i)) continue;
            CompactParser.NAME_CHAR[i] = true;
        }
    }
}

