/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.config.ConfigException;
import com.caucho.relaxng.CompactParser;
import com.caucho.relaxng.Schema;
import com.caucho.relaxng.SchemaImpl;
import com.caucho.relaxng.VerifierFactory;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompactVerifierFactoryImpl
implements VerifierFactory {
    private static HashMap<String, SoftReference<Schema>> _schemaMap = new HashMap();

    public static Schema compileFromResource(String schemaName) throws SAXException, IOException {
        CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
        MergePath mp = new MergePath();
        mp.addClassPath();
        return factory.compileSchema(mp.lookup(schemaName));
    }

    public static Schema compileFromPath(Path path) throws SAXException, IOException {
        return new CompactVerifierFactoryImpl().compileSchema(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema compileSchema(Path path) throws SAXException, IOException {
        String nativePath = path.getNativePath();
        SoftReference<Schema> schemaRef = _schemaMap.get(nativePath);
        Schema schema = null;
        if (schemaRef != null && (schema = schemaRef.get()) != null) {
            return schema;
        }
        try (ReadStream is = path.openRead();){
            InputSource source = new InputSource(is);
            source.setSystemId(path.getUserPath());
            schema = this.compileSchema(source);
            if (schema != null) {
                _schemaMap.put(nativePath, new SoftReference<Schema>(schema));
            }
        }
        return schema;
    }

    @Override
    public Schema compileSchema(InputSource is) throws SAXException, IOException {
        try {
            CompactParser parser = new CompactParser();
            parser.parse(is);
            SchemaImpl schema = new SchemaImpl(parser.getGrammar());
            schema.setFilename(is.getSystemId());
            return schema;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

