/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnmaskedFrameInputStream
extends FrameInputStream {
    private static final Logger log = Logger.getLogger(UnmaskedFrameInputStream.class.getName());
    private InputStream _is;
    private boolean _isFinal = true;
    private int _op;
    private long _length;

    @Override
    public void init(WebSocketContext cxt, InputStream is) {
        super.init(cxt, is);
        if (is == null) {
            throw new NullPointerException();
        }
        this._is = is;
    }

    @Override
    public int getOpcode() {
        return this._op;
    }

    @Override
    public boolean isFinal() {
        return this._isFinal;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public int read() throws IOException {
        long length = this._length;
        if (length == 0L && !this._isFinal) {
            this.readFrameHeader();
            if (this._length == 0L) {
                return -1;
            }
            length = this._length;
        }
        int ch = this._is.read();
        this._length = length - 1L;
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen;
        if (this._length == 0L && !this._isFinal) {
            this.readFrameHeader();
            if (this._length == 0L) {
                return -1;
            }
        }
        if (this._length < (long)(sublen = length)) {
            sublen = (int)this._length;
        }
        if ((sublen = this._is.read(buffer, offset, sublen)) < 0) {
            return sublen;
        }
        this._length -= (long)sublen;
        return sublen;
    }

    @Override
    protected boolean readFrameHeaderImpl() throws IOException {
        InputStream is = this._is;
        int frame1 = is.read();
        int frame2 = is.read();
        if (frame2 < 0) {
            return false;
        }
        boolean isFinal = (frame1 & 0x80) == 128;
        this._op = frame1 & 0xF;
        int rsv = frame1 & 0x70;
        if (rsv != 0) {
            if (this.getContext() != null) {
                this.getContext().close(1002, "illegal request");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " WebSocket BAD_REQ:" + Integer.toHexString(frame1) + " " + Integer.toHexString(frame2));
            }
            return false;
        }
        this._isFinal = isFinal;
        long length = frame2 & 0x7F;
        if (length >= 126L) {
            length = length == 126L ? ((long)is.read() << 8) + (long)is.read() : ((long)is.read() << 56) + ((long)is.read() << 48) + ((long)is.read() << 40) + ((long)is.read() << 32) + ((long)is.read() << 24) + ((long)is.read() << 16) + ((long)is.read() << 8) + (long)is.read();
        }
        this._length = length;
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }
}

