/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.WebSocketConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WebSocketWriter
extends Writer
implements WebSocketConstants {
    private final OutputStream _os;
    private byte[] _buffer;
    private int _offset;
    private MessageState _state = MessageState.IDLE;
    private boolean _isAutoFlush = true;
    private char _savedPair;

    public WebSocketWriter(OutputStream os, byte[] buffer) throws IOException {
        if (os == null) {
            throw new NullPointerException();
        }
        this._os = os;
        this._buffer = buffer;
    }

    public void init() throws IOException {
        if (this._state != MessageState.IDLE) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        this._state = MessageState.FIRST;
        this._savedPair = '\u0000';
        if (this._buffer.length <= this._offset) {
            this._os.flush();
        }
        this._offset = 4;
    }

    @Override
    public void write(int ch) throws IOException {
        if (!this._state.isActive()) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        byte[] buffer = this._buffer;
        if (this._offset == buffer.length) {
            this.complete(false);
        }
        if (ch < 128) {
            buffer[this._offset++] = (byte)ch;
        } else if (ch < 2048) {
            if (buffer.length <= this._offset + 1) {
                this.complete(false);
            }
            buffer[this._offset++] = (byte)(192 + (ch >> 6));
            buffer[this._offset++] = (byte)(128 + (ch & 0x3F));
        } else if (55296 <= ch && ch <= 56319) {
            this._savedPair = (char)ch;
        } else if (56320 <= ch && ch <= 57343) {
            int cp = ((this._savedPair & 0x3FF) << 10) + (ch & 0x3FF);
            this._savedPair = '\u0000';
            if (buffer.length <= this._offset + 4) {
                this.complete(false);
            }
            buffer[this._offset++] = (byte)(240 + ((cp += 65536) >> 18));
            buffer[this._offset++] = (byte)(128 + (cp >> 12 & 0x3F));
            buffer[this._offset++] = (byte)(128 + (cp >> 6 & 0x3F));
            buffer[this._offset++] = (byte)(128 + (cp & 0x3F));
        } else {
            if (buffer.length <= this._offset + 2) {
                this.complete(false);
            }
            buffer[this._offset++] = (byte)(224 + (ch >> 12));
            buffer[this._offset++] = (byte)(128 + (ch >> 6 & 0x3F));
            buffer[this._offset++] = (byte)(128 + (ch & 0x3F));
        }
    }

    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        if (!this._state.isActive()) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        byte[] wsBuffer = this._buffer;
        int wsOffset = this._offset;
        while (length > 0) {
            char ch;
            if (wsBuffer.length <= wsOffset + 2) {
                this._offset = wsOffset;
                this.complete(false);
                wsOffset = this._offset;
            }
            if ((ch = buffer[offset++]) < '\u0080') {
                wsBuffer[wsOffset++] = (byte)ch;
            } else if (ch < '\u0800') {
                wsBuffer[wsOffset++] = (byte)(192 + (ch >> 6));
                wsBuffer[wsOffset++] = (byte)(128 + (ch & 0x3F));
            } else if ('\ud800' <= ch && ch <= '\udbff') {
                this._savedPair = ch;
            } else if ('\udc00' <= ch && ch <= '\udfff') {
                int cp = ((this._savedPair & 0x3FF) << 10) + (ch & 0x3FF);
                this._savedPair = '\u0000';
                if (buffer.length <= this._offset + 4) {
                    this.complete(false);
                }
                wsBuffer[wsOffset++] = (byte)(240 + ((cp += 65536) >> 18));
                wsBuffer[wsOffset++] = (byte)(128 + (cp >> 12 & 0x3F));
                wsBuffer[wsOffset++] = (byte)(128 + (cp >> 6 & 0x3F));
                wsBuffer[wsOffset++] = (byte)(128 + (cp & 0x3F));
            } else {
                wsBuffer[wsOffset++] = (byte)(224 + (ch >> 12));
                wsBuffer[wsOffset++] = (byte)(128 + (ch >> 6 & 0x3F));
                wsBuffer[wsOffset++] = (byte)(128 + (ch & 0x3F));
            }
            --length;
        }
        this._offset = wsOffset;
    }

    @Override
    public void flush() throws IOException {
        this.complete(false);
        this._os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._state == MessageState.IDLE) {
            return;
        }
        this.complete(true);
        this._state = MessageState.IDLE;
        if (this._isAutoFlush) {
            this._os.flush();
        }
    }

    private void complete(boolean isFinal) throws IOException {
        byte[] buffer = this._buffer;
        int offset = this._offset;
        this._offset = 4;
        int length = offset - 4;
        if (length == 0 && !isFinal) {
            return;
        }
        int code1 = this._state == MessageState.FIRST ? 1 : 0;
        this._state = MessageState.CONT;
        if (isFinal) {
            code1 |= 0x80;
        }
        if (length < 126) {
            buffer[2] = (byte)code1;
            buffer[3] = (byte)length;
            this._os.write(buffer, 2, offset - 2);
        } else {
            buffer[0] = (byte)code1;
            buffer[1] = 126;
            buffer[2] = (byte)(length >> 8);
            buffer[3] = (byte)length;
            this._os.write(buffer, 0, offset);
        }
    }

    public void destroy() throws IOException {
        this._state = MessageState.DESTROYED;
    }

    static class DummyWriter
    extends Writer {
        DummyWriter() {
        }

        @Override
        public void write(int ch) throws IOException {
        }

        @Override
        public void write(char[] data, int offset, int length) throws IOException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    static enum MessageState {
        IDLE,
        FIRST{

            @Override
            public boolean isActive() {
                return true;
            }
        }
        ,
        CONT{

            @Override
            public boolean isActive() {
                return true;
            }
        }
        ,
        DESTROYED;


        public boolean isActive() {
            return false;
        }
    }
}

