/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.inject.ThreadContext;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.ResourceLoader;
import com.caucho.resin.BeanContainerRequest;
import com.caucho.server.webbeans.ResinCdiProducer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public class ResinBeanContainer {
    private static final Logger log = Logger.getLogger(ResinBeanContainer.class.getName());
    private static final L10N L = new L10N(ResinBeanContainer.class);
    private EnvironmentClassLoader _classLoader;
    private InjectManager _cdiManager;
    private ThreadLocal<BeanContainerRequest> _localContext = new ThreadLocal();
    private Path _modulePath;
    private Lifecycle _lifecycle = new Lifecycle();

    public ResinBeanContainer() {
        this._classLoader = EnvironmentClassLoader.create("resin-context");
        this._cdiManager = InjectManager.create(this._classLoader);
        this._cdiManager.replaceContext(new RequestScope());
        this._cdiManager.replaceContext(ThreadContext.getContext());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            EjbManager.create(this._classLoader);
            Environment.init();
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            Environment.addChildLoaderListener(new EjbEnvironmentListener());
            Environment.addCloseListener(this);
            this._classLoader.addScanRoot();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void setId(String id) {
        this._classLoader.setId(id);
    }

    public InjectManager getCdiManager() {
        return this._cdiManager;
    }

    public void setModule(String modulePath) {
        this._modulePath = Vfs.lookup(modulePath);
    }

    public void addClassPath(String classPath) {
        Path path = Vfs.lookup(classPath);
        if (classPath.endsWith(".jar")) {
            this._classLoader.addJar(path);
        } else {
            CompilingLoader loader = new CompilingLoader(this._classLoader);
            loader.setPath(path);
            loader.init();
        }
    }

    public void addPackageModule(String modulePath, String packageName) {
        Path root = Vfs.lookup(modulePath);
        try {
            URL url = new URL(root.getURL());
            this._classLoader.addScanPackage(url, packageName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public void addPackageModule(String packageName) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> e = loader.getResources(packageName.replace('.', '/'));
            URL bestUrl = null;
            block2: while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (bestUrl == null) {
                    bestUrl = url;
                    continue;
                }
                URL urlA = bestUrl;
                Path pathA = Vfs.lookup(urlA);
                Path pathB = Vfs.lookup(url);
                for (String name : pathA.list()) {
                    if (!name.endsWith(".class")) continue;
                    bestUrl = urlA;
                    break;
                }
                for (String name : pathB.list()) {
                    if (!name.endsWith(".class")) continue;
                    bestUrl = url;
                    continue block2;
                }
            }
            if (bestUrl == null) {
                throw new NullPointerException(packageName);
            }
            Path path = Vfs.lookup(bestUrl);
            String moduleName = path.getNativePath();
            if (moduleName.endsWith(packageName.replace('.', '/'))) {
                int prefixLength = moduleName.length() - packageName.length();
                moduleName = moduleName.substring(0, prefixLength);
            }
            this.addResourceRoot(path);
            this.addPackageModule(moduleName, packageName);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeansXml(String pathName) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            Path path = Vfs.lookup(pathName);
            this._cdiManager.addXmlPath(path);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void addResourceRoot(Path path) {
        ResourceLoader loader = new ResourceLoader(this._classLoader, path);
        loader.init();
    }

    public void setWorkDirectory(String path) {
        WorkDir.setLocalWorkDir(Vfs.lookup(path), this._classLoader);
    }

    public void start() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (this._lifecycle.toActive()) {
                this.addCdiProducer();
            }
            this._classLoader.start();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public Object getInstance(String className, Annotation ... qualifiers) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Class<?> cl = Class.forName(className, false, this._classLoader);
            Object obj = this.getInstance(cl, qualifiers);
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public <T> T getInstance(Class<T> type, Annotation ... qualifiers) {
        if (type == null) {
            throw new NullPointerException();
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Set beans = this._cdiManager.getBeans(type, qualifiers);
            if (beans.size() > 0) {
                Bean bean = this._cdiManager.resolve(beans);
                Object x = this._cdiManager.getReference(bean);
                return (T)x;
            }
            T t = type.newInstance();
            return t;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBeanByName(String name) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Set beans = this._cdiManager.getBeans(name);
            if (beans.size() > 0) {
                Bean bean = this._cdiManager.resolve(beans);
                Object x = this._cdiManager.getReference(bean);
                return x;
            }
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Runnable runnable) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        BeanContainerRequest oldContext = this._localContext.get();
        BeanContainerRequest context = new BeanContainerRequest(this, oldLoader, oldContext);
        thread.setContextClassLoader(this._classLoader);
        this._localContext.set(context);
        try {
            runnable.run();
        }
        finally {
            context.close();
        }
    }

    public BeanContainerRequest beginRequest() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        BeanContainerRequest oldContext = this._localContext.get();
        BeanContainerRequest context = new BeanContainerRequest(this, oldLoader, oldContext);
        thread.setContextClassLoader(this._classLoader);
        this._localContext.set(context);
        return context;
    }

    public void completeRequest(BeanContainerRequest context) {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(context.getOldClassLoader());
        this._localContext.set(context.getOldContext());
    }

    public void close() {
        EnvironmentClassLoader loader = this._classLoader;
        this._classLoader = null;
        if (loader != null) {
            loader.destroy();
        }
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCdiProducer() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            Class<?> resinCdiProducer = this.getResinCdiProducerClass();
            if (resinCdiProducer != null) {
                this._cdiManager.addManagedBean(this._cdiManager.createManagedBean(resinCdiProducer));
            }
            Class<?> resinValidatorClass = ResinCdiProducer.createResinValidatorProducer();
            if (this._cdiManager != null && resinValidatorClass != null) {
                this._cdiManager.addManagedBean(this._cdiManager.createManagedBean(resinValidatorClass));
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private Class<?> getResinCdiProducerClass() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName("com.caucho.server.webbeans.ResinCdiProducer", false, loader);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }

    private class RequestScope
    implements Context {
        private RequestScope() {
        }

        public <T> T get(Contextual<T> bean) {
            BeanContainerRequest cxt = (BeanContainerRequest)ResinBeanContainer.this._localContext.get();
            if (cxt == null) {
                throw new IllegalStateException(L.l("No RequestScope is active"));
            }
            return cxt.get(bean);
        }

        public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
            BeanContainerRequest cxt = (BeanContainerRequest)ResinBeanContainer.this._localContext.get();
            if (cxt == null) {
                throw new IllegalStateException(L.l("No RequestScope is active"));
            }
            return cxt.get(bean, creationalContext, ResinBeanContainer.this._cdiManager);
        }

        public Class<? extends Annotation> getScope() {
            return RequestScoped.class;
        }

        public boolean isActive() {
            return ResinBeanContainer.this._localContext.get() != null;
        }
    }
}

