/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.AbstractRegexpDispatchRule;
import com.caucho.util.L10N;
import java.util.regex.Matcher;

@Configurable
public abstract class AbstractTargetDispatchRule
extends AbstractRegexpDispatchRule {
    private static final L10N L = new L10N(AbstractTargetDispatchRule.class);
    private String _target;
    private boolean _targetIsAbsolute;

    public void setTarget(String target) {
        this._target = target;
        if (target != null && target.indexOf("://") >= 0) {
            this._targetIsAbsolute = true;
        }
    }

    public void setAbsoluteTarget(String target) {
        this.setTarget(target);
    }

    public void setTargetHost(String target) {
    }

    public String getTarget() {
        return this._target;
    }

    @Override
    protected String rewriteTarget(Matcher matcher, String uri, String queryString) {
        if (this._target == null) {
            return this.rewriteDefault(uri, queryString);
        }
        if (matcher != null) {
            return matcher.replaceFirst(this._target);
        }
        return this._target;
    }

    protected String rewriteDefault(String uri, String queryString) {
        return uri;
    }

    public void init() throws ConfigException {
        if (this._target == null) {
            throw new ConfigException(L.l("'target' is a required attribute of '{0}' because Resin needs to know the destination URL.", (Object)this.getClass().getSimpleName()));
        }
    }
}

