/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.http.HttpServletResponseImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MovedFilterChain
implements FilterChain {
    private int _code;
    private String _url;
    private String _queryString;

    public MovedFilterChain(int code, String url) {
        this._code = code;
        this._url = url;
    }

    public MovedFilterChain(int code, String url, String queryString) {
        this._code = code;
        this._url = url;
        this._queryString = queryString;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String queryString = this._queryString;
        if (queryString == null) {
            queryString = req.getQueryString();
        }
        String url = queryString != null && this._url.indexOf(63) < 0 ? res.encodeURL(this._url + '?' + queryString) : res.encodeURL(this._url);
        url = HttpServletResponseImpl.escapeUrl(url, req.getCharacterEncoding());
        res.setHeader("Location", url);
        res.setStatus(this._code);
        PrintWriter out = response.getWriter();
        out.println("The URL has moved to <a href=\"" + url + "\">" + url + "</a>");
    }
}

