/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.cloud.bam.BamSystem;
import com.caucho.cloud.hmtp.HmtpRequest;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.hmux.HmuxDispatchRequest;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.server.hmux.HmuxResponse;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HmuxRequest
extends AbstractHttpRequest
implements ProtocolConnection {
    private static final Logger log = Logger.getLogger(HmuxRequest.class.getName());
    public static final int HMUX_CHANNEL = 67;
    public static final int HMUX_ACK = 65;
    public static final int HMUX_ERROR = 69;
    public static final int HMUX_YIELD = 89;
    public static final int HMUX_QUIT = 81;
    public static final int HMUX_EXIT = 88;
    public static final int HMUX_DATA = 68;
    public static final int HMUX_URI = 85;
    public static final int HMUX_STRING = 83;
    public static final int HMUX_HEADER = 72;
    public static final int HMUX_BINARY = 66;
    public static final int HMUX_PROTOCOL = 80;
    public static final int HMUX_META_HEADER = 77;
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_REMOTE_USER = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int HMUX_FLUSH = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int HMUX_METHOD = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int HMUX_STATUS = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_SERVER_TYPE = 117;
    public static final int HMUX_SERVER_NAME = 118;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_END = 90;
    public static final int CSE_QUERY = 81;
    public static final int HMUX_TO_UNIDIR_HMTP = 55;
    public static final int HMUX_SWITCH_TO_HMTP = 56;
    public static final int HMUX_HMTP_OK = 57;
    public static final int HMUX_DISPATCH_PROTOCOL = 258;
    public static final int HMUX_JMS_PROTOCOL = 259;
    public static final int HMUX_HTTP_PROXY_PROTOCOL = 260;
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    private static final int HEADER_CAPACITY = 256;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    private final CharBuffer _method;
    private String _methodString;
    private CharBuffer _host;
    private ByteBuffer _uri;
    private CharBuffer _protocol;
    private int _version;
    private CharBuffer _remoteAddr;
    private CharBuffer _remoteHost;
    private CharBuffer _serverName;
    private CharBuffer _serverPort;
    private CharBuffer _remotePort;
    private boolean _isSecure;
    private ByteBuffer _clientCert;
    private CharBuffer[] _headerKeys;
    private CharBuffer[] _headerValues;
    private int _headerSize;
    private int _serverType;
    private WriteStream _rawWrite;
    private int _bufferStartOffset;
    private ServletFilter _filter;
    private int _pendingData;
    private CharBuffer _cb1;
    private CharBuffer _cb2;
    private boolean _hasRequest;
    private final HmuxDispatchRequest _dispatchRequest;
    private HmtpRequest _hmtpRequest;
    private ProtocolConnection _subProtocol;
    private HmuxProtocol _hmuxProtocol;
    private ErrorPageManager _errorManager;

    public HmuxRequest(ServletService server, SocketLink conn, HmuxProtocol protocol) {
        super(server, conn);
        this._errorManager = new ErrorPageManager(server);
        this._hmuxProtocol = protocol;
        this._rawWrite = conn.getWriteStream();
        this._dispatchRequest = new HmuxDispatchRequest(this);
        this._uri = new ByteBuffer();
        this._method = new CharBuffer();
        this._host = new CharBuffer();
        this._protocol = new CharBuffer();
        this._headerKeys = new CharBuffer[256];
        this._headerValues = new CharBuffer[this._headerKeys.length];
        for (int i = 0; i < this._headerKeys.length; ++i) {
            this._headerKeys[i] = new CharBuffer();
            this._headerValues[i] = new CharBuffer();
        }
        this._remoteHost = new CharBuffer();
        this._remoteAddr = new CharBuffer();
        this._serverName = new CharBuffer();
        this._serverPort = new CharBuffer();
        this._remotePort = new CharBuffer();
        this._clientCert = new ByteBuffer();
        this._cb1 = new CharBuffer();
        this._cb2 = new CharBuffer();
        this._filter = new ServletFilter();
        BamSystem bamService = BamSystem.getCurrent();
        this._hmtpRequest = new HmtpRequest(conn, bamService);
    }

    @Override
    public HmuxResponse createResponse() {
        return new HmuxResponse(this, this.getConnection().getWriteStream());
    }

    @Override
    public boolean isWaitForRead() {
        return true;
    }

    @Override
    public boolean hasRequest() {
        return this._hasRequest;
    }

    @Override
    public boolean isSuspend() {
        return super.isSuspend() || this._subProtocol != null;
    }

    @Override
    public boolean handleRequest() throws IOException {
        try {
            ProtocolConnection subProtocol = this._subProtocol;
            if (subProtocol != null) {
                return subProtocol.handleRequest();
            }
            return this.handleRequestImpl();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequestImpl() throws IOException {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(this.getServer().getClassLoader());
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "start request");
        }
        this._filter.init(this, this.getRawRead(), this.getRawWrite());
        try {
            this.startRequest();
            this.startInvocation();
            boolean bl = this.handleInvocation();
            return bl;
        }
        finally {
            if (!this._hasRequest) {
                this.getResponse().setHeaderWritten(true);
            }
            if (this._subProtocol == null) {
                this.finishInvocation();
            }
            try {
                if (!this.isSuspend()) {
                    this.finishRequest();
                }
            }
            catch (ClientDisconnectException e) {
                throw e;
            }
            catch (Exception e) {
                this.killKeepalive("hmux finishRequest exception " + e);
                log.log(Level.FINE, this.dbgId() + e, e);
            }
            if (this._subProtocol == null && !this.isSuspend()) {
                try {
                    ReadStream is = this.getReadStream();
                    is.setDisableClose(false);
                    is.close();
                }
                catch (Exception e) {
                    this.killKeepalive("hmux close exception: " + e);
                    log.log(Level.FINE, this.dbgId() + e, e);
                }
            }
        }
    }

    private boolean handleInvocation() throws IOException {
        try {
            this._hasRequest = false;
            if (!this.scanHeaders() || !this.getConnection().isPortActive()) {
                this._hasRequest = false;
                this.killKeepalive("hmux scanHeaders failure");
                return false;
            }
            if (!this._hasRequest) {
                return true;
            }
        }
        catch (InterruptedIOException e) {
            this.killKeepalive("hmux parse header exception: " + e);
            log.fine(this.dbgId() + "interrupted keepalive");
            return false;
        }
        if (this._isSecure) {
            this.getClientCertificate();
        }
        this._hasRequest = true;
        ServletService server = this.getServer();
        if (server == null || server.isDestroyed()) {
            log.fine(this.dbgId() + "server is closed");
            ReadStream is = this.getRawRead();
            try {
                is.setDisableClose(false);
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        this._filter.setPending(this._pendingData);
        try {
            if (this._method.getLength() == 0) {
                throw new RuntimeException("HTTP protocol exception, expected method");
            }
            if (!this.getServer().waitForActive(5000L)) {
                return this.sendBusyResponse();
            }
            Invocation invocation = this.getInvocation(this.getHost(), this._uri.getBuffer(), this._uri.getLength());
            this.getRequestFacade().setInvocation(invocation);
            this.startInvocation();
            if (this.getServer().isPreview() && !"resin.admin".equals(this.getHost())) {
                return this.sendBusyResponse();
            }
            invocation.service((ServletRequest)this.getRequestFacade(), (ServletResponse)this.getResponseFacade());
        }
        catch (ClientDisconnectException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            try {
                this._errorManager.sendServletError(e, (ServletRequest)this.getRequestFacade(), (ServletResponse)this.getResponseFacade());
            }
            catch (ClientDisconnectException e1) {
                throw e1;
            }
            catch (Exception e1) {
                log.log(Level.FINE, e1.toString(), e1);
            }
        }
        return true;
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawStream) throws IOException {
        readStream.init(this._filter, null);
        return true;
    }

    private void getClientCertificate() {
        String keySize;
        HttpServletRequestImpl request = this.getRequestFacade();
        String cipher = this.getHeader("SSL_CIPHER");
        if (cipher == null) {
            cipher = this.getHeader("HTTPS_CIPHER");
        }
        if (cipher != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", cipher);
        }
        if ((keySize = this.getHeader("SSL_CIPHER_USEKEYSIZE")) == null) {
            keySize = this.getHeader("SSL_SECRETKEYSIZE");
        }
        if (keySize != null) {
            request.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        if (this._clientCert.size() == 0) {
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = this._clientCert.createInputStream();
            X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
            is.close();
            request.setAttribute("javax.servlet.request.X509Certificate", new X509Certificate[]{cert});
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    public void onStartConnection() {
        super.onStartConnection();
        this._hmtpRequest.onStartConnection();
        this._subProtocol = null;
    }

    @Override
    protected void startRequest() throws IOException {
        super.startRequest();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._version = 0;
        this._uri.clear();
        this._host.clear();
        this._headerSize = 0;
        this._remoteHost.clear();
        this._remoteAddr.clear();
        this._serverName.clear();
        this._serverPort.clear();
        this._remotePort.clear();
        this._clientCert.clear();
        this._pendingData = 0;
        this._bufferStartOffset = 0;
        this._isSecure = this.getConnection().isSecure();
    }

    private boolean sendBusyResponse() throws IOException {
        HttpServletResponseImpl response = this.getResponseFacade();
        response.sendError(503);
        return true;
    }

    private boolean scanHeaders() throws IOException {
        boolean isLoggable = log.isLoggable(Level.FINE);
        ReadStream is = this.getRawRead();
        WriteStream os = this.getRawWrite();
        CharBuffer cb = this.getCharBuffer();
        block28: while (true) {
            this._rawWrite.flush();
            int code = is.read();
            ServletService server = this.getServer();
            if (server == null || server.isDestroyed()) {
                log.fine(this.dbgId() + " request after server close");
                this.killKeepalive("after server close");
                return false;
            }
            switch (code) {
                case -1: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "r: end of file");
                    }
                    this._filter.setClientClosed(true);
                    this.killKeepalive("hmux end of file");
                    return false;
                }
                case 67: {
                    int channel = (is.read() << 8) + is.read();
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + "channel-r " + channel);
                    break;
                }
                case 89: {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this.dbgId() + (char)code + "-r: yield");
                    }
                    os.write(65);
                    os.write(0);
                    os.write(0);
                    os.flush();
                    break;
                }
                case 81: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + "-r: end of request");
                    }
                    return true;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + "-r: end of socket");
                    }
                    this.killKeepalive("hmux exit");
                    return true;
                }
                case 80: {
                    int len = (is.read() << 8) + is.read();
                    if (len != 4) {
                        log.fine(this.dbgId() + (char)code + "-r: protocol length (" + len + ") must be 4.");
                        this.killKeepalive("hmux protocol");
                        return false;
                    }
                    int value = (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
                    this.dispatchProtocol(is, code, value);
                    return true;
                }
                case 85: {
                    int len = (is.read() << 8) + is.read();
                    this._uri.setLength(len);
                    is.readAll(this._uri.getBuffer(), 0, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ":uri " + this._uri);
                    }
                    this._hasRequest = true;
                    break;
                }
                case 109: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._method, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + ":method " + this._method);
                    break;
                }
                case 107: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    is.readAll(this._cb1, len);
                    code = is.read();
                    if (code != 83) {
                        throw new IOException("protocol expected HMUX_STRING");
                    }
                    this._cb2.clear();
                    is.readAll(this._cb2, this.readLength(is));
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " " + this._cb1.toString() + "->" + this._cb2.toString());
                    break;
                }
                case 104: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._remoteHost, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " " + this._remoteHost);
                    break;
                }
                case 105: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._remoteAddr, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " " + this._remoteAddr);
                    break;
                }
                case 118: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._serverName, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " server-host: " + this._serverName);
                    break;
                }
                case 106: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._remotePort, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " remote-port: " + this._remotePort);
                    break;
                }
                case 103: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._serverPort, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " server-port: " + this._serverPort);
                    break;
                }
                case 101: {
                    int len = (is.read() << 8) + is.read();
                    if (len <= 0) continue block28;
                    this._uri.add(63);
                    this._uri.ensureCapacity(this._uri.getLength() + len);
                    is.readAll(this._uri.getBuffer(), this._uri.getLength(), len);
                    this._uri.setLength(this._uri.getLength() + len);
                    break;
                }
                case 99: {
                    int len = (is.read() << 8) + is.read();
                    is.readAll(this._protocol, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " protocol: " + this._protocol);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= len) continue block28;
                        char ch = this._protocol.charAt(i);
                        if ('0' <= ch && ch <= '9') {
                            this._version = 16 * this._version + ch - 48;
                        } else if (ch == '.') {
                            this._version = 16 * this._version;
                        }
                        ++i;
                    }
                }
                case 72: {
                    int len = (is.read() << 8) + is.read();
                    int headerSize = this._headerSize;
                    CharBuffer key = this._headerKeys[headerSize];
                    key.clear();
                    CharBuffer valueCb = this._headerValues[headerSize];
                    valueCb.clear();
                    is.readAll(key, len);
                    code = is.read();
                    if (code != 83) {
                        throw new IOException("protocol expected HMUX_STRING at " + (char)code);
                    }
                    is.readAll(valueCb, this.readLength(is));
                    if (isLoggable) {
                        log.fine(this.dbgId() + "H " + key + "=" + valueCb);
                    }
                    if (!this.addHeaderInt(key.getBuffer(), 0, key.length(), valueCb)) continue block28;
                    ++this._headerSize;
                    break;
                }
                case 112: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Length");
                    this._headerValues[this._headerSize].clear();
                    is.readAll(this._headerValues[this._headerSize], len);
                    this.setContentLength(this._headerValues[this._headerSize]);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " content-length=" + this._headerValues[this._headerSize]);
                    }
                    ++this._headerSize;
                    break;
                }
                case 113: {
                    int len = (is.read() << 8) + is.read();
                    if (this._headerKeys.length <= this._headerSize) {
                        this.resizeHeaders();
                    }
                    this._headerKeys[this._headerSize].clear();
                    this._headerKeys[this._headerSize].append("Content-Type");
                    this._headerValues[this._headerSize].clear();
                    is.readAll(this._headerValues[this._headerSize], len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " content-type=" + this._headerValues[this._headerSize]);
                    }
                    ++this._headerSize;
                    break;
                }
                case 114: {
                    int len = (is.read() << 8) + is.read();
                    this._isSecure = true;
                    if (isLoggable) {
                        log.fine(this.dbgId() + "secure");
                    }
                    is.skip(len);
                    break;
                }
                case 116: {
                    int len = (is.read() << 8) + is.read();
                    this._clientCert.clear();
                    this._clientCert.setLength(len);
                    is.readAll(this._clientCert.getBuffer(), 0, len);
                    if (!isLoggable) continue block28;
                    log.fine(this.dbgId() + (char)code + " cert=" + this._clientCert + " len:" + len);
                    break;
                }
                case 117: {
                    int len = (is.read() << 8) + is.read();
                    this._cb1.clear();
                    is.readAll(this._cb1, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " server=" + this._cb1);
                    }
                    if (this._cb1.length() <= 0) continue block28;
                    this._serverType = this._cb1.charAt(0);
                    break;
                }
                case 100: {
                    int len = (is.read() << 8) + is.read();
                    cb.clear();
                    is.readAll(cb, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " " + cb);
                    }
                    this.getRequestFacade().setAttribute("caucho.user", new BasicPrincipal(cb.toString()));
                    break;
                }
                case 68: {
                    int len;
                    this._pendingData = len = (is.read() << 8) + is.read();
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " post-data: " + len);
                    }
                    if (len <= 0) continue block28;
                    return true;
                }
                case 55: 
                case 56: {
                    if (this._hasRequest) {
                        throw new IllegalStateException();
                    }
                    is.unread();
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + "-r switch-to-hmtp");
                    }
                    this._subProtocol = this._hmtpRequest;
                    boolean result = this._hmtpRequest.handleRequest();
                    return result;
                }
                case 10: 
                case 32: {
                    break;
                }
                default: {
                    int d1 = is.read();
                    int d2 = is.read();
                    if (d2 < 0) {
                        if (isLoggable) {
                            log.fine(this.dbgId() + "r: unexpected end of file");
                        }
                        this.killKeepalive("hmux data end of file");
                        return false;
                    }
                    int len = (d1 << 8) + d2;
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + " " + len);
                    }
                    is.skip(len);
                    break;
                }
            }
        }
    }

    private void dispatchProtocol(ReadStream is, int code, int value) throws IOException {
        int result = 88;
        boolean isKeepalive = false;
        if (value == 258) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + (char)code + "-r: dispatch protocol");
            }
            this._filter.setClientClosed(true);
            isKeepalive = this._dispatchRequest.handleRequest(is, this._rawWrite);
            result = isKeepalive ? 81 : 88;
        } else {
            Protocol ext = this._hmuxProtocol.getExtension(value);
            if (ext != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + (char)code + "-r: extension " + ext);
                }
                this._filter.setClientClosed(true);
                this._subProtocol = ext.createConnection(this.getTcpSocketLink());
                this._subProtocol.handleRequest();
                return;
            }
            log.fine(this.dbgId() + (char)code + "-r: unknown protocol (" + value + ")");
            result = 88;
        }
        if (result == 89) {
            this._rawWrite.write(65);
            this._rawWrite.write(0);
            this._rawWrite.write(0);
            this._rawWrite.flush();
            return;
        }
        if (result == 81 && !this.isKeepalive()) {
            result = 88;
        }
        if (result == 81) {
            this._rawWrite.write(81);
            this._rawWrite.flush();
        } else {
            this.killKeepalive("hmux failed result: " + (char)result);
            this._rawWrite.write(88);
            this._rawWrite.close();
        }
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this._headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this._headerSize * 2];
        for (i = 0; i < this._headerSize; ++i) {
            newKeys[i] = this._headerKeys[i];
            newValues[i] = this._headerValues[i];
        }
        for (i = this._headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this._headerKeys = newKeys;
        this._headerValues = newValues;
    }

    private int readLength(ReadStream is) throws IOException {
        return (is.read() << 8) + is.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFlush() throws IOException {
        WriteStream out;
        WriteStream writeStream = out = this._rawWrite;
        synchronized (writeStream) {
            out.flush();
        }
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals(_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals(_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals(_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    protected CharBuffer getHost() {
        if (this._host.length() > 0) {
            return this._host;
        }
        this._host.append(this._serverName);
        this._host.toLowerCase();
        return this._host;
    }

    @Override
    public final byte[] getUriBuffer() {
        return this._uri.getBuffer();
    }

    @Override
    public final int getUriLength() {
        return this._uri.getLength();
    }

    @Override
    public String getProtocol() {
        return this._protocol.toString();
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    final int getVersion() {
        return this._version;
    }

    @Override
    public boolean isSecure() {
        return super.isSecure() || this._isSecure;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this._headerSize; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this._headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this._headerSize; ++i) {
            int j;
            CharBuffer test = this._headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void setHeader(String key, String value) {
        if (this._headerKeys.length <= this._headerSize) {
            this.resizeHeaders();
        }
        this._headerKeys[this._headerSize].clear();
        this._headerKeys[this._headerSize].append(key);
        this._headerValues[this._headerSize].clear();
        this._headerValues[this._headerSize].append(value);
        ++this._headerSize;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        CharBuffer cb = this.getCharBuffer();
        cb.clear();
        cb.append(key);
        int size = this._headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this._headerKeys[i];
            if (!test.equalsIgnoreCase(cb)) continue;
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            names.add(this._headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public String getRequestURI() {
        if (this._serverType == 82) {
            return super.getRequestURI();
        }
        String _rawURI = super.getRequestURI();
        if (_rawURI == null) {
            return null;
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < _rawURI.length(); ++i) {
            char ch = _rawURI.charAt(i);
            if (ch <= ' ' || ch >= '\u0080' || ch == '%') {
                this.addHex(cb, ch);
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    private void addHex(CharBuffer cb, int ch) {
        cb.append('%');
        int d = ch >> 4 & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = ch & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
    }

    @Override
    public String getServerName() {
        CharBuffer host = this.getHost();
        if (host == null) {
            InetAddress addr = this.getConnection().getRemoteAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    @Override
    public int getServerPort() {
        int len = this._serverPort.length();
        int port = 0;
        for (int i = 0; i < len; ++i) {
            char ch = this._serverPort.charAt(i);
            port = 10 * port + ch - 48;
        }
        return port;
    }

    @Override
    public String getRemoteAddr() {
        return this._remoteAddr.toString();
    }

    public void getRemoteAddr(CharBuffer cb) {
        cb.append(this._remoteAddr);
    }

    @Override
    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        char[] buf = this._remoteAddr.getBuffer();
        int len = this._remoteAddr.getLength();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)buf[i];
        }
        return offset + len;
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost.toString();
    }

    @Override
    protected void handleConnectionClose() {
    }

    @Override
    public void finishRequest() throws IOException {
        try {
            super.finishRequest();
        }
        finally {
            this._filter.close();
        }
    }

    void writeStatus(CharBuffer message) throws IOException {
        this.writeString(115, message);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String key, String value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void writeHeader(String key, CharBuffer value) throws IOException {
        this.writeString(72, key);
        this.writeString(83, value);
    }

    void flushResponseBuffer() throws IOException {
        HttpServletRequestImpl request = this.getRequestFacade();
        if (request != null) {
            AbstractResponseStream stream = request.getResponse().getResponseStream();
            stream.flushNext();
        }
    }

    protected byte[] getNextBuffer() {
        return this._rawWrite.getBuffer();
    }

    protected int getNextStartOffset() {
        if (this._bufferStartOffset == 0) {
            int startOffset;
            int bufferLength = this._rawWrite.getBuffer().length;
            if (bufferLength <= (startOffset = this._rawWrite.getBufferOffset() + 3)) {
                try {
                    this._rawWrite.flush();
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                startOffset = this._rawWrite.getBufferOffset() + 3;
            }
            this._rawWrite.setBufferOffset(startOffset);
            this._bufferStartOffset = startOffset;
        }
        return this._bufferStartOffset;
    }

    protected int getNextBufferOffset() throws IOException {
        if (this._bufferStartOffset == 0) {
            int startOffset;
            int bufferLength = this._rawWrite.getBuffer().length;
            if (bufferLength <= (startOffset = this._rawWrite.getBufferOffset() + 3)) {
                this._rawWrite.flush();
                startOffset = this._rawWrite.getBufferOffset() + 3;
            }
            this._rawWrite.setBufferOffset(startOffset);
            this._bufferStartOffset = startOffset;
        }
        return this._rawWrite.getBufferOffset();
    }

    protected void setNextBufferOffset(int offset) throws IOException {
        offset = this.fillDataBuffer(offset);
        this._rawWrite.setBufferOffset(offset);
    }

    protected byte[] writeNextBuffer(int offset) throws IOException {
        offset = this.fillDataBuffer(offset);
        return this._rawWrite.nextBuffer(offset);
    }

    protected void flushNext() throws IOException {
        if (this.flushNextBuffer()) {
            this._rawWrite.write(102);
            this._rawWrite.write(0);
            this._rawWrite.write(0);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + "flush-w()");
            }
        }
        this._rawWrite.flush();
    }

    protected final boolean flushNextBuffer() throws IOException {
        WriteStream next = this._rawWrite;
        int startOffset = this._bufferStartOffset;
        if (startOffset > 0) {
            this._bufferStartOffset = 0;
            if (startOffset == next.getBufferOffset()) {
                next.setBufferOffset(startOffset - 3);
                return startOffset != 3;
            }
            throw new IllegalStateException();
        }
        return false;
    }

    protected void writeTail() throws IOException {
        WriteStream next = this._rawWrite;
        int offset = next.getBufferOffset();
        offset = this.fillDataBuffer(offset);
        next.setBufferOffset(offset);
    }

    private int fillDataBuffer(int offset) throws IOException {
        int bufferStart = this._bufferStartOffset;
        if (bufferStart == 0) {
            return offset;
        }
        byte[] buffer = this._rawWrite.getBuffer();
        int length = offset - bufferStart;
        this._bufferStartOffset = 0;
        if (length == 0) {
            offset = bufferStart - 3;
        } else {
            buffer[bufferStart - 3] = 68;
            buffer[bufferStart - 2] = (byte)(length >> 8);
            buffer[bufferStart - 1] = (byte)length;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + 'D' + "-w(" + length + ")");
            }
        }
        this._bufferStartOffset = 0;
        return offset;
    }

    void writeString(int code, String value) throws IOException {
        int len = value.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + "-w " + value);
        }
    }

    void writeString(int code, CharBuffer cb) throws IOException {
        int len = cb.length();
        WriteStream os = this._rawWrite;
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(cb.getBuffer(), 0, len);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + "-w: " + cb);
        }
    }

    @Override
    public void onCloseConnection() {
        this._subProtocol = null;
        this._hmtpRequest.onCloseConnection();
        super.onCloseConnection();
    }

    protected String getRequestId() {
        String id = this.getServer().getServerId();
        if (id.equals("")) {
            return "server-" + this.getConnection().getId();
        }
        return "server-" + id + ":" + this.getConnection().getId();
    }

    @Override
    public final String dbgId() {
        String id = this.getServer().getServerId();
        if (id.equals("")) {
            return "Hmux[" + this.getConnection().getId() + "] ";
        }
        return "Hmux[" + id + ":" + this.getConnection().getId() + "] ";
    }

    public String toString() {
        return "HmuxRequest" + this.dbgId();
    }

    static class ServletFilter
    extends StreamImpl {
        HmuxRequest _request;
        ReadStream _is;
        WriteStream _os;
        byte[] _buffer = new byte[16];
        int _pendingData;
        boolean _needsAck;
        boolean _isClosed;
        boolean _isClientClosed;

        ServletFilter() {
        }

        void init(HmuxRequest request, ReadStream nextRead, WriteStream nextWrite) {
            this._request = request;
            this._is = nextRead;
            this._os = nextWrite;
            this._pendingData = 0;
            this._isClosed = false;
            this._isClientClosed = false;
            this._needsAck = false;
        }

        void setPending(int pendingData) {
            this._pendingData = pendingData;
        }

        void setClientClosed(boolean isClientClosed) {
            this._isClientClosed = isClientClosed;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public int getAvailable() {
            return this._pendingData;
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int sublen = this._pendingData;
            ReadStream is = this._is;
            if (sublen <= 0) {
                return -1;
            }
            if (length < sublen) {
                sublen = length;
            }
            this._os.flush();
            int readLen = is.read(buf, offset, sublen);
            this._pendingData -= readLen;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(new String(buf, offset, readLen));
            }
            block8: while (this._pendingData == 0) {
                int len;
                this._os.flush();
                int code = is.read();
                switch (code) {
                    case 68: {
                        len = (is.read() << 8) + is.read();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this._request.dbgId() + "D-r:post-data " + len);
                        }
                        this._pendingData = len;
                        if (len <= 0) continue block8;
                        return readLen;
                    }
                    case 81: {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this._request.dbgId() + "Q-r:quit");
                        }
                        return readLen;
                    }
                    case 88: {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this._request.dbgId() + "X-r:exit");
                        }
                        this._request.killKeepalive("hmux request exit");
                        return readLen;
                    }
                    case 89: {
                        this._request.flushResponseBuffer();
                        this._os.write(65);
                        this._os.write(0);
                        this._os.write(0);
                        this._os.flush();
                        if (!log.isLoggable(Level.FINE)) continue block8;
                        log.fine(this._request.dbgId() + "Y-r:yield");
                        log.fine(this._request.dbgId() + "A-w:ack");
                        continue block8;
                    }
                    case 67: {
                        int channel = (is.read() << 8) + is.read();
                        if (!log.isLoggable(Level.FINE)) continue block8;
                        log.fine(this._request.dbgId() + "channel-r " + channel);
                        continue block8;
                    }
                    case 10: 
                    case 32: {
                        continue block8;
                    }
                }
                if (code < 0) {
                    this._request.killKeepalive("hmux request end-of-file");
                    return readLen;
                }
                this._request.killKeepalive("hmux unknown request: " + (char)code);
                len = (is.read() << 8) + is.read();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._request.dbgId() + "unknown-r '" + (char)code + "' " + len);
                }
                is.skip(len);
            }
            return readLen;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            this._request.flushResponseBuffer();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'D' + ":data " + length);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this._request.dbgId() + "data <" + new String(buf, offset, length) + ">");
                }
            }
            byte[] tempBuf = this._buffer;
            Thread.dumpStack();
            while (length > 0) {
                int sublen = length;
                if (32768 < sublen) {
                    sublen = 32768;
                }
                tempBuf[0] = 68;
                tempBuf[1] = (byte)(sublen >> 8);
                tempBuf[2] = (byte)sublen;
                this._os.write(tempBuf, 0, 3);
                this._os.write(buf, offset, sublen);
                length -= sublen;
                offset += sublen;
            }
        }

        @Override
        public void flush() throws IOException {
            if (!this._request._hasRequest) {
                return;
            }
            System.out.println("HMUX_FLUSH:");
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + 'f' + "-w:flush");
            }
            this._os.write(102);
            this._os.write(0);
            this._os.write(0);
            this._os.flush();
        }

        @Override
        public void close() throws IOException {
            HmuxRequest request;
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            if (this._pendingData > 0) {
                this._is.skip(this._pendingData);
                this._pendingData = 0;
            }
            if ((request = this._request) == null) {
                return;
            }
            boolean keepalive = request.isKeepalive();
            if (!this._isClientClosed) {
                if (log.isLoggable(Level.FINE)) {
                    if (keepalive) {
                        log.fine(request.dbgId() + 'Q' + "-w: quit channel");
                    } else {
                        log.fine(request.dbgId() + 'X' + "-w: exit socket");
                    }
                }
                if (keepalive) {
                    this._os.write(81);
                } else {
                    this._os.write(88);
                }
            }
            if (keepalive) {
                this._os.flush();
            } else {
                this._os.close();
            }
        }
    }

    public static enum ProtocolResult {
        QUIT,
        EXIT,
        YIELD;

    }
}

