/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.env.deploy.DeployException;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.server.webapp.WebAppController;
import com.caucho.vfs.Path;

public class HostAdmin
extends DeployControllerAdmin<HostController>
implements HostMXBean {
    public HostAdmin(HostController controller) {
        super(controller);
    }

    @Override
    public String getName() {
        String name = ((HostController)this.getController()).getName();
        if (name == null || name.equals("")) {
            return "default";
        }
        return name;
    }

    @Override
    public String getHostName() {
        return ((HostController)this.getController()).getHostName();
    }

    @Override
    public String getURL() {
        Host host = this.getHost();
        if (host != null) {
            return host.getURL();
        }
        return null;
    }

    @Override
    public String getRootDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getRootDirectory();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    public String getDocumentDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getWebAppContainer().getDocumentDirectory();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public String getWarDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getWebAppContainer().getWarDir();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public String getWarExpandDirectory() {
        Path path = null;
        Host host = this.getHost();
        if (host != null) {
            path = host.getWebAppContainer().getWarExpandDir();
        }
        if (path != null) {
            return path.getNativePath();
        }
        return null;
    }

    @Override
    public void updateWebAppDeploy(String name) throws DeployException {
        Host host = this.getHost();
        try {
            if (host != null) {
                host.getWebAppContainer().updateWebAppDeploy(name);
            }
        }
        catch (Throwable e) {
            throw new DeployException(e);
        }
    }

    @Override
    public void updateEarDeploy(String name) throws DeployException {
        Host host = this.getHost();
        try {
            if (host != null) {
                host.getWebAppContainer().updateEarDeploy(name);
            }
        }
        catch (Throwable e) {
            throw new DeployException(e);
        }
    }

    @Override
    public void expandEarDeploy(String name) {
        Host host = this.getHost();
        if (host != null) {
            host.getWebAppContainer().expandEarDeploy(name);
        }
    }

    @Override
    public void startEarDeploy(String name) {
        Host host = this.getHost();
        if (host != null) {
            host.getWebAppContainer().startEarDeploy(name);
        }
    }

    @Override
    public WebAppMXBean[] getWebApps() {
        Host host = this.getHost();
        if (host == null) {
            return new WebAppMXBean[0];
        }
        WebAppController[] webappList = host.getWebAppContainer().getWebAppList();
        WebAppMXBean[] webapps = new WebAppMXBean[webappList.length];
        for (int i = 0; i < webapps.length; ++i) {
            WebAppController controller = webappList[i];
            webapps[i] = controller.getAdmin();
        }
        return webapps;
    }

    protected Host getHost() {
        return (Host)((HostController)this.getController()).getDeployInstance();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

