/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.VersionFactory;
import com.caucho.server.http.AbstractCauchoResponse;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ContentType;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.server.httpcache.AbstractCacheFilterChain;
import com.caucho.server.session.CookieImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.HTTPUtil;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public final class HttpServletResponseImpl
extends AbstractCauchoResponse
implements CauchoResponse {
    private static final Logger log = Logger.getLogger(HttpServletResponseImpl.class.getName());
    private static final L10N L = new L10N(HttpServletResponseImpl.class);
    private static final HashMap<Integer, String> _errors = new HashMap();
    private final HttpServletRequestImpl _request;
    private AbstractHttpResponse _response;
    private int _status = 200;
    private String _statusMessage = "OK";
    private String _sessionId;
    private ArrayList<Cookie> _cookiesOut;
    private AbstractResponseStream _responseStream;
    private ServletOutputStreamImpl _outputStream;
    private ResponseWriter _writer;
    private String _setCharEncoding;
    private String _charEncoding;
    private String _contentType;
    private Locale _locale;
    private boolean _hasError;
    private boolean _forbidForward;
    private AbstractCacheFilterChain _cacheInvocation;
    private boolean _isNoCache;
    private boolean _isPrivateCache;
    private boolean _isCacheControl;
    private boolean _isNoCacheUnlessVary;
    private boolean _isDisableCache;

    public HttpServletResponseImpl(HttpServletRequestImpl request, AbstractHttpResponse response) {
        this._request = request;
        this._response = response;
        this._responseStream = response.getResponseStream();
    }

    public HttpServletRequestImpl getRequest() {
        return this._request;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputStream != null) {
            return this._outputStream;
        }
        if (this._writer != null) {
            throw new IllegalStateException(L.l("getOutputStream() can't be called after getWriter()."));
        }
        try {
            this._responseStream.clearBuffer();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._outputStream = this._response.getResponseOutputStream();
        this._outputStream.init(this._responseStream);
        return this._outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer != null) {
            return this._writer;
        }
        if (this._outputStream != null) {
            if (this._response.isClosed()) {
                this._writer = this._response.getResponsePrintWriter();
                this._writer.init(this._responseStream);
                return this._writer;
            }
            throw new IllegalStateException(L.l("getWriter() can't be called after getOutputStream()."));
        }
        String encoding = this.getCharacterEncoding();
        this._writer = this._response.getResponsePrintWriter();
        this._writer.init(this._responseStream);
        if (encoding != null) {
            this._responseStream.setEncoding(encoding);
        }
        return this._writer;
    }

    public void setBufferSize(int size) {
        this._responseStream.setBufferSize(size);
    }

    public int getBufferSize() {
        return this._responseStream.getBufferSize();
    }

    public int getRemaining() {
        return this._responseStream.getRemaining();
    }

    public void flushBuffer() throws IOException {
        this._responseStream.flush();
    }

    public final boolean isCommitted() {
        AbstractHttpResponse response = this._response;
        if (response != null) {
            return response.isCommitted();
        }
        return true;
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean force) {
        if (!force && this.isCommitted()) {
            throw new IllegalStateException(L.l("response cannot be reset() after committed"));
        }
        this._responseStream.clearBuffer();
        this._status = 200;
        this._statusMessage = "OK";
        this._setCharEncoding = null;
        this._charEncoding = null;
        this._locale = null;
        this._outputStream = null;
        this._writer = null;
        try {
            this._responseStream.setLocale(null);
            this._responseStream.setEncoding(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._cookiesOut != null) {
            this._cookiesOut.clear();
        }
        this._response.reset();
    }

    public void resetBuffer() {
        this._responseStream.clearBuffer();
        if (this._responseStream.isCommitted()) {
            this._responseStream.killCaching();
        }
    }

    public void setContentLength(int len) {
        if (this._outputStream == null && this._writer == null) {
            this._response.setContentLength(len);
        }
    }

    @Override
    public void setContentLength(long length) {
        if (this._outputStream == null && this._writer == null) {
            this._response.setContentLength(length);
        }
    }

    public void disable() {
    }

    public void enable() {
    }

    public boolean isDisabled() {
        return false;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        if (this._setCharEncoding == null && !this.isCommitted()) {
            this._charEncoding = this.getRequest().getWebApp().getLocaleEncoding(locale);
            try {
                if (this._charEncoding != null) {
                    this._responseStream.setEncoding(this._charEncoding);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StringBuilder cb = new StringBuilder();
        cb.append(locale.getLanguage());
        if (locale.getCountry() != null && !"".equals(locale.getCountry())) {
            cb.append("-");
            cb.append(locale.getCountry());
            if (locale.getVariant() != null && !"".equals(locale.getVariant())) {
                cb.append("-");
                cb.append(locale.getVariant());
            }
        }
        this.setHeader("Content-Language", cb.toString());
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        return Locale.getDefault();
    }

    @Override
    public void setPrivateCache(boolean isPrivate) {
        this._isPrivateCache = isPrivate;
        this.killCache();
    }

    public void setPrivateOrResinCache(boolean isPrivate) {
        this._isPrivateCache = isPrivate;
    }

    @Override
    public void setCacheInvocation(AbstractCacheFilterChain cacheInvocation) {
        assert (this._cacheInvocation == null || cacheInvocation == null);
        this._cacheInvocation = cacheInvocation;
    }

    public final AbstractCacheFilterChain getCacheInvocation() {
        return this._cacheInvocation;
    }

    @Override
    public boolean isCaching() {
        return this._cacheInvocation != null;
    }

    public void setNoCacheUnlessVary(boolean isNoCacheUnlessVary) {
        this._isNoCacheUnlessVary = isNoCacheUnlessVary;
    }

    @Override
    public boolean isNoCacheUnlessVary() {
        return this._isNoCacheUnlessVary;
    }

    public boolean getPrivateCache() {
        return this._isPrivateCache;
    }

    public boolean isPrivateCache() {
        return !this._isCacheControl && this._isPrivateCache;
    }

    public boolean isCacheControl() {
        return this._isCacheControl;
    }

    public void setCacheControl(boolean isCacheControl) {
        this._isCacheControl = isCacheControl;
    }

    @Override
    public void setNoCache(boolean isNoCache) {
        this._isNoCache = isNoCache;
        this.killCache();
    }

    public boolean isNoCache() {
        return this._isNoCache;
    }

    @Override
    public void killCache() {
        this._isDisableCache = true;
        this._responseStream.killCaching();
    }

    public boolean isDisableCache() {
        return this._isDisableCache;
    }

    public void setStatus(int code) {
        this.setStatus(code, null);
    }

    public void setStatus(int code, String message) {
        if (code < 0) {
            code = 500;
        }
        if (message == null) {
            if (code == 200) {
                message = "OK";
            } else if (code == 304) {
                message = "Not Modified";
            } else if (message == null && (message = _errors.get(code)) == null) {
                message = L.l("Internal Server Error");
            }
        }
        if (code != 200 && code != 304) {
            this.killCache();
        }
        if (code == 400 || code == 101) {
            this._request.killKeepalive("servletResponse: bad request: " + code + " " + message);
        }
        this._status = code;
        this._statusMessage = message;
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    public void sendError(int code, String value) throws IOException {
        if (code == 304 && this.isProxyCacheFill()) {
            this.setStatus(code, value);
            if (this.handleNotModified()) {
                return;
            }
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("sendError() forbidden after buffer has been committed."));
        }
        this.resetBuffer();
        if (code != 304) {
            this.killCache();
        }
        WebApp webApp = this.getRequest().getWebApp();
        ErrorPageManager errorManager = null;
        errorManager = webApp != null && webApp.isActive() ? webApp.getErrorPageManager() : this.getRequest().getServer().getErrorPageManager();
        this.setStatus(code, value);
        try {
            if (code == 304 || code == 204) {
                this._response.finishInvocation();
                return;
            }
            if (errorManager != null) {
                errorManager.sendError(this._request, this, code, this._statusMessage);
                this._response.finishInvocation();
                return;
            }
            this.setContentType("text/html");
            ServletOutputStream s = this.getOutputStream();
            s.println("<html>");
            if (!this.isCommitted()) {
                s.print("<head><title>");
                s.print(code);
                s.print(" ");
                s.print(this._statusMessage);
                s.println("</title></head>");
            }
            s.println("<body>");
            s.print("<h1>");
            s.print(code);
            s.print(" ");
            s.print(this._statusMessage);
            s.println("</h1>");
            if (code == 404) {
                s.println(L.l("{0} was not found on this server.", (Object)HTTPUtil.encodeString(this.getRequest().getPageURI())));
            } else if (code == 503) {
                s.println(L.l("The server is temporarily unavailable due to maintenance downtime or excessive load."));
            }
            String version = null;
            if (webApp != null) {
                if (webApp.getServer() != null && webApp.getServer().getServerHeader() != null) {
                    version = webApp.getServer().getServerHeader();
                } else if (!CauchoSystem.isTesting()) {
                    version = VersionFactory.getFullVersion();
                }
            }
            if (version != null) {
                s.println("<p /><hr />");
                s.println("<small>");
                s.println(version);
                s.println("</small>");
            }
            s.println("</body></html>");
        }
        catch (Exception e) {
            log.fine(L.l("Error in processing sendError code={0}, status='{1}'", (Object)code, (Object)value));
            log.log(Level.FINE, e.toString(), e);
        }
        this._request.killKeepalive("servlet error: " + code + " " + value);
        this._response.finishInvocation();
    }

    private boolean isProxyCacheFill() {
        return true;
    }

    boolean handleNotModified() throws IOException {
        WebApp webApp;
        long maxAge;
        if (this._status != 304) {
            return false;
        }
        if (this.isProxyCacheFill()) {
            return true;
        }
        if (this._cacheInvocation != null && (maxAge = (webApp = this._request.getWebApp()).getMaxAge(this._request.getRequestURI())) > 0L && !this.containsHeader("Cache-Control")) {
            this.addHeader("Cache-Control", "max-age=" + maxAge / 1000L);
        }
        return false;
    }

    public void setContentType(String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this._locale == null && this._setCharEncoding == null) {
            this._charEncoding = null;
        }
        if (value == null) {
            this._contentType = null;
            return;
        }
        ContentType item = AbstractHttpResponse.parseContentType(value);
        this._contentType = item.getContentType();
        String encoding = item.getEncoding();
        if (encoding != null) {
            this.setCharacterEncoding(encoding);
        } else if (this._charEncoding != null || this._setCharEncoding != null) {
            return;
        }
        try {
            encoding = this.getCharacterEncoding();
            this._responseStream.setEncoding(encoding);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public String getContentType() {
        if (this._contentType == null) {
            return null;
        }
        if (this._setCharEncoding != null) {
            return this._contentType + "; charset=" + this._setCharEncoding;
        }
        String charEncoding = this.getCharacterEncoding();
        if (charEncoding != null && (this._contentType.startsWith("text/") || this._contentType.equals("application/json") || this._contentType.startsWith("multipart/"))) {
            return this._contentType + "; charset=" + charEncoding;
        }
        return this._contentType;
    }

    public String getContentTypeImpl() {
        return this._contentType;
    }

    @Override
    public String getCharacterEncodingAssigned() {
        return this._setCharEncoding;
    }

    public String getCharacterEncoding() {
        String charEncoding = this._charEncoding;
        if (charEncoding == null) {
            charEncoding = this._setCharEncoding;
            if (charEncoding == null) {
                WebApp webApp = this._request.getWebApp();
                if (webApp != null) {
                    if (webApp.getJsp() != null) {
                        charEncoding = webApp.getJsp().getCharacterEncoding();
                    }
                    if (charEncoding == null) {
                        charEncoding = webApp.getCharacterEncoding();
                    }
                }
                if (charEncoding == null) {
                    charEncoding = "utf-8";
                }
            }
            this._charEncoding = charEncoding;
        }
        return charEncoding;
    }

    public String getCharacterEncodingImpl() {
        String setCharEncoding = this._setCharEncoding;
        if (setCharEncoding != null) {
            return setCharEncoding;
        }
        String contentType = this.getContentTypeImpl();
        if (contentType == null || contentType.startsWith("text/") || contentType.startsWith("multipart/")) {
            return this.getCharacterEncoding();
        }
        return null;
    }

    public void setCharacterEncoding(String encoding) {
        if (this.isCommitted()) {
            return;
        }
        if (this._writer != null) {
            if (encoding != null && this._charEncoding != null && !encoding.equalsIgnoreCase(this._charEncoding) && log.isLoggable(Level.FINE)) {
                log.fine(this._request.getRequestURI() + ": setEncoding(" + encoding + ") ignored because writer already initialized with charset=" + this._charEncoding);
            }
            return;
        }
        this._setCharEncoding = encoding == null || encoding.equals("ISO-8859-1") || encoding.equals("") ? "iso-8859-1" : encoding;
        this._charEncoding = this._setCharEncoding;
        try {
            this._responseStream.setEncoding(encoding);
        }
        catch (Exception e) {
            log.log(Level.INFO, e.toString(), e);
        }
    }

    public void sendRedirect(String url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("Can't sendRedirect() after data has committed to the client."));
        }
        this._responseStream.clearBuffer();
        this.resetBuffer();
        this.setStatus(302);
        String encoding = this.getCharacterEncoding();
        boolean isLatin1 = "iso-8859-1".equals(encoding);
        String path = this.encodeAbsoluteRedirect(url);
        this.setHeader("Location", path);
        if (isLatin1) {
            this.setHeader("Content-Type", "text/html; charset=iso-8859-1");
        } else {
            this.setHeader("Content-Type", "text/html; charset=utf-8");
        }
        String msg = "The URL has moved <a href=\"" + path + "\">here</a>";
        if (this._writer != null) {
            this._writer.println(msg);
        } else {
            ServletOutputStream out = this.getOutputStream();
            out.println(msg);
        }
        this._request.saveSession();
        this.close();
    }

    public String encodeAbsoluteRedirect(String url) {
        return this.encodeAbsoluteRedirect(url, this.getCharacterEncoding());
    }

    public String encodeAbsoluteRedirect(String url, String encoding) {
        String path = this.getAbsolutePath(url);
        return HttpServletResponseImpl.escapeUrl(path, encoding);
    }

    public static String escapeUrl(String path, String encoding) {
        boolean isLatin1 = "iso-8859-1".equals(encoding);
        return HttpServletResponseImpl.escapeUrl(path, isLatin1);
    }

    public static String escapeUrl(String path, boolean isLatin1) {
        StringBuilder cb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            int d2;
            int d1;
            char ch = path.charAt(i);
            if (ch == '<') {
                cb.append("%3c");
                continue;
            }
            if (ch == '>') {
                cb.append("%3e");
                continue;
            }
            if (ch == '\"') {
                cb.append("%22");
                continue;
            }
            if (ch < '\u0080') {
                cb.append(ch);
                continue;
            }
            if (isLatin1) {
                HttpServletResponseImpl.addHex(cb, ch);
                continue;
            }
            if (ch < '\u0800') {
                d1 = 192 + (ch >> 6 & 0x1F);
                d2 = 128 + (ch & 0x3F);
                HttpServletResponseImpl.addHex(cb, d1);
                HttpServletResponseImpl.addHex(cb, d2);
                continue;
            }
            d1 = 224 + (ch >> 12 & 0xF);
            d2 = 128 + (ch >> 6 & 0x3F);
            int d3 = 128 + (ch & 0x3F);
            HttpServletResponseImpl.addHex(cb, d1);
            HttpServletResponseImpl.addHex(cb, d2);
            HttpServletResponseImpl.addHex(cb, d3);
        }
        return cb.toString();
    }

    private String getAbsolutePath(String path) {
        int slash = path.indexOf(47);
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (ch == ':') {
                return path;
            }
            if ((ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) break;
        }
        WebApp webApp = this.getRequest().getWebApp();
        String hostPrefix = null;
        String host = this._request.getHeader("Host");
        String serverName = webApp.getHostName();
        if (serverName == null || serverName.equals("") || serverName.equals("default")) {
            serverName = this._request.getServerName();
        }
        int port = this._request.getServerPort();
        if (hostPrefix == null || hostPrefix.equals("")) {
            if (serverName.startsWith("https:")) {
                hostPrefix = serverName;
            } else if (serverName.startsWith("http:")) {
                hostPrefix = this._request.getScheme() + serverName.substring(4);
            } else if (host != null) {
                hostPrefix = this._request.getScheme() + "://" + host;
            } else {
                hostPrefix = this._request.getScheme() + "://" + serverName;
                if (serverName.indexOf(58) < 0 && port != 0 && port != 80 && port != 443) {
                    hostPrefix = hostPrefix + ":" + port;
                }
            }
        }
        if (slash == 0) {
            return hostPrefix + path;
        }
        String uri = this._request.getRequestURI();
        String contextPath = this._request.getContextPath();
        String queryString = null;
        int p = path.indexOf(63);
        if (p > 0) {
            queryString = path.substring(p + 1);
            path = path.substring(0, p);
        }
        if (uri.equals(contextPath)) {
            path = uri + "/" + path;
        } else {
            p = uri.lastIndexOf(47);
            if (p >= 0) {
                path = uri.substring(0, p + 1) + path;
            }
        }
        try {
            if (queryString != null) {
                return hostPrefix + webApp.getInvocationDecoder().normalizeUri(path) + '?' + queryString;
            }
            return hostPrefix + webApp.getInvocationDecoder().normalizeUri(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addHex(StringBuilder cb, int hex) {
        int d1 = hex >> 4 & 0xF;
        int d2 = hex & 0xF;
        cb.append('%');
        cb.append(d1 < 10 ? (char)(d1 + 48) : (char)(d1 - 10 + 97));
        cb.append(d2 < 10 ? (char)(d2 + 48) : (char)(d2 - 10 + 97));
    }

    public void setHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this._response.addHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this._response.containsHeader(name);
    }

    public void setDateHeader(String name, long date) {
        this._response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this._response.addDateHeader(name, date);
    }

    public void setIntHeader(String name, int value) {
        this._response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this._response.addIntHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        this._request.setHasCookie();
        if (cookie == null) {
            return;
        }
        if (this._cookiesOut == null) {
            this._cookiesOut = new ArrayList();
        }
        this._cookiesOut.add(cookie);
    }

    public Cookie getCookie(String name) {
        if (this._cookiesOut == null) {
            return null;
        }
        for (int i = this._cookiesOut.size() - 1; i >= 0; --i) {
            Cookie cookie = this._cookiesOut.get(i);
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public ArrayList<Cookie> getCookies() {
        return this._cookiesOut;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    @Override
    public void setSessionId(String id) {
        this._sessionId = id;
        WebApp webApp = this._request.getWebApp();
        if (webApp != null && webApp.getSessionManager().enableSessionCookies()) {
            this.setPrivateOrResinCache(true);
        }
    }

    protected void addServletCookie(WebApp webApp) {
        if (this._sessionId != null && webApp != null && webApp.getSessionManager().enableSessionCookies()) {
            this.addCookie(this.createServletCookie(webApp));
        }
    }

    protected Cookie createServletCookie(WebApp webApp) {
        long maxAge;
        SessionManager manager = webApp.getSessionManager();
        String cookieName = this._request.isSecure() ? manager.getSSLCookieName() : manager.getCookieName();
        CookieImpl cookie = new CookieImpl(cookieName, this._sessionId);
        cookie.setVersion(manager.getCookieVersion());
        String domain = webApp.generateCookieDomain(this._request);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if ((maxAge = manager.getCookieMaxAge()) > 0L) {
            cookie.setMaxAge((int)(maxAge / 1000L));
        }
        cookie.setPath(manager.getPath());
        if (manager.getComment() != null) {
            cookie.setComment(manager.getComment());
        }
        cookie.setPort(manager.getCookiePort());
        if (manager.isSecure()) {
            cookie.setSecure(true);
        } else if (manager.isCookieSecure() && this._request.isSecure()) {
            cookie.setSecure(true);
        }
        if (manager.isCookieHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setSameSite(manager.getCookieSameSite());
        return cookie;
    }

    public String encodeURL(String string) {
        HttpServletRequestImpl request = this.getRequest();
        WebApp webApp = request.getWebApp();
        if (webApp == null) {
            return string;
        }
        if (request.isRequestedSessionIdFromCookie()) {
            return string;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return string;
        }
        SessionManager sessionManager = webApp.getSessionManager();
        if (!sessionManager.enableSessionUrls()) {
            return string;
        }
        StringBuilder cb = new StringBuilder();
        String altPrefix = sessionManager.getAlternateSessionPrefix();
        if (altPrefix == null) {
            int p = string.indexOf(63);
            if (p == 0) {
                cb.append(string);
            } else if (p > 0) {
                cb.append(string, 0, p);
                cb.append(sessionManager.getSessionPrefix());
                cb.append(session.getId());
                cb.append(string, p, string.length());
            } else {
                p = string.indexOf(35);
                if (p >= 0) {
                    cb.append(string, 0, p);
                    cb.append(sessionManager.getSessionPrefix());
                    cb.append(session.getId());
                    cb.append(string, p, string.length());
                } else {
                    cb.append(string);
                    cb.append(sessionManager.getSessionPrefix());
                    cb.append(session.getId());
                }
            }
        } else {
            int p = string.indexOf("://");
            if (p < 0) {
                cb.append(altPrefix);
                cb.append(session.getId());
                if (!string.startsWith("/")) {
                    cb.append(this._request.getContextPath());
                    cb.append('/');
                }
                cb.append(string);
            } else {
                int q = string.indexOf(47, p + 3);
                if (q < 0) {
                    cb.append(string);
                    cb.append(altPrefix);
                    cb.append(session.getId());
                } else {
                    cb.append(string.substring(0, q));
                    cb.append(altPrefix);
                    cb.append(session.getId());
                    cb.append(string.substring(q));
                }
            }
        }
        return cb.toString();
    }

    public String encodeRedirectURL(String string) {
        String path = this.encodeURL(string);
        String encoding = this.getCharacterEncoding();
        boolean isLatin1 = "iso-8859-1".equals(encoding);
        return HttpServletResponseImpl.escapeUrl(path, isLatin1);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        if (this._responseStream.getEncoding() == null) {
            String encoding = this.getCharacterEncoding();
            try {
                this._responseStream.setEncoding(encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._responseStream;
    }

    @Override
    public void setResponseStream(AbstractResponseStream responseStream) {
        this._responseStream = responseStream;
        if (this._outputStream != null) {
            this._outputStream.init(responseStream);
        }
        if (this._writer != null) {
            this._writer.init(responseStream);
        }
    }

    @Override
    public boolean isCauchoResponseStream() {
        return this._responseStream.isCauchoResponseStream();
    }

    @Override
    public String getHeader(String key) {
        return this._response.getHeader(key);
    }

    ArrayList<String> getHeaderKeys() {
        return this._response.getHeaderKeys();
    }

    ArrayList<String> getHeaderValues() {
        return this._response.getHeaderValues();
    }

    @Override
    public void setFooter(String key, String value) {
        this._response.setFooter(key, value);
    }

    @Override
    public void addFooter(String key, String value) {
        this._response.addFooter(key, value);
    }

    @Override
    public void close() throws IOException {
        AbstractHttpResponse response = this._response;
        if (response != null) {
            response.close();
        }
    }

    @Override
    public void setForbidForward(boolean forbid) {
        this._forbidForward = forbid;
    }

    @Override
    public boolean getForbidForward() {
        return this._forbidForward;
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    @Override
    public void setHasError(boolean error) {
        this._hasError = error;
    }

    @Override
    public ServletResponse getResponse() {
        return null;
    }

    @Override
    public AbstractHttpResponse getAbstractHttpResponse() {
        return this._response;
    }

    public int getStatus() {
        return this._status;
    }

    @Override
    public String getStatusMessage() {
        return this._statusMessage;
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    @Override
    public void setForwardEnclosed(boolean isForwardEnclosed) {
    }

    @Override
    public boolean isForwardEnclosed() {
        return false;
    }

    public void closeImpl() throws IOException {
        AbstractHttpResponse response = this._response;
        this._response = null;
        if (response != null) {
            response.close();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._response + "]";
    }

    static {
        _errors.put(100, "Continue");
        _errors.put(101, "Switching Protocols");
        _errors.put(200, "OK");
        _errors.put(201, "Created");
        _errors.put(202, "Accepted");
        _errors.put(203, "Non-Authoritative Information");
        _errors.put(204, "No Content");
        _errors.put(205, "Reset Content");
        _errors.put(206, "Partial Content");
        _errors.put(300, "Multiple Choices");
        _errors.put(301, "Moved Permanently");
        _errors.put(302, "Found");
        _errors.put(303, "See Other");
        _errors.put(304, "Not Modified");
        _errors.put(305, "Use Proxy");
        _errors.put(307, "Temporary Redirect");
        _errors.put(400, "Bad Request");
        _errors.put(401, "Unauthorized");
        _errors.put(402, "Payment Required");
        _errors.put(403, "Forbidden");
        _errors.put(404, "Not Found");
        _errors.put(405, "Method Not Allowed");
        _errors.put(406, "Not Acceptable");
        _errors.put(407, "Proxy Authentication Required");
        _errors.put(408, "Request Timeout");
        _errors.put(409, "Conflict");
        _errors.put(410, "Gone");
        _errors.put(411, "Length Required");
        _errors.put(412, "Precondition Failed");
        _errors.put(413, "Request Entity Too Large");
        _errors.put(414, "Request-URI Too Long");
        _errors.put(415, "Unsupported Media Type");
        _errors.put(416, "Requested Range Not Satisfiable");
        _errors.put(417, "Expectation Failed");
        _errors.put(500, "Internal Server Error");
        _errors.put(501, "Not Implemented");
        _errors.put(502, "Bad Gateway");
        _errors.put(503, "Service Temporarily Unavailable");
        _errors.put(504, "Gateway Timeout");
        _errors.put(505, "Http Version Not Supported");
    }
}

