/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.httpcache;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.xa.RawTransaction;
import com.caucho.db.xa.StoreTransaction;
import com.caucho.util.L10N;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.TempCharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileInode {
    private static final L10N L = new L10N(TempFileInode.class);
    private static final Logger log = Logger.getLogger(TempFileInode.class.getName());
    private final BlockStore _store;
    private AtomicInteger _useCount = new AtomicInteger(1);
    private ArrayList<Long> _blockList = new ArrayList();
    private long[] _blockArray;
    private long _length;

    TempFileInode(BlockStore store) {
        this._store = store;
    }

    public long getLength() {
        return this._length;
    }

    public boolean allocate() {
        int count;
        while ((count = this._useCount.get()) > 0) {
            if (!this._useCount.compareAndSet(count, count + 1)) continue;
            return true;
        }
        return false;
    }

    public OutputStream openOutputStream() {
        return new TempFileOutputStream();
    }

    public InputStream openInputStream() {
        return new TempFileInputStream();
    }

    public Writer openWriter() {
        return new TempFileWriter();
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        this.writeToStream(os, 0L, this._length);
    }

    public void writeToStream(OutputStreamWithBuffer os, long offset, long length) throws IOException {
        if (this._length < length) {
            length = this._length;
        }
        byte[] buffer = os.getBuffer();
        int writeLength = buffer.length;
        int writeOffset = os.getBufferOffset();
        long[] blockArray = this._blockArray;
        while (length > 0L) {
            int len;
            int sublen = writeLength - writeOffset;
            if (sublen == 0) {
                buffer = os.nextBuffer(writeOffset);
                writeOffset = os.getBufferOffset();
                sublen = writeLength - writeOffset;
            }
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            long blockId = blockArray[(int)(offset / 8192L)];
            int blockOffset = (int)(offset % 8192L);
            if (8192 - blockOffset < sublen) {
                sublen = 8192 - blockOffset;
            }
            if ((len = this._store.readBlock(blockId, blockOffset, buffer, writeOffset, sublen)) <= 0) break;
            writeOffset += len;
            offset += (long)len;
            length -= (long)len;
        }
        os.setBufferOffset(writeOffset);
        if (this._useCount.get() <= 0) {
            throw new IllegalStateException(L.l("Unexpected close of cache inode"));
        }
    }

    public void writeToWriter(Writer out) throws IOException {
        int len;
        TempCharBuffer charBuffer = TempCharBuffer.allocate();
        char[] buffer = charBuffer.getBuffer();
        long offset = 0L;
        for (long length = this._length; length > 0L; length -= (long)(2 * len)) {
            long blockId = this._blockArray[(int)(offset / 8192L)];
            int blockOffset = (int)(offset % 8192L);
            int sublen = (8192 - blockOffset) / 2;
            if (buffer.length < sublen) {
                sublen = buffer.length;
            }
            if (length < (long)(2 * sublen)) {
                sublen = (int)(length / 2L);
            }
            if ((len = this._store.readBlock(blockId, blockOffset, buffer, 0, sublen)) <= 0) break;
            out.write(buffer, 0, len);
            offset += (long)(2 * len);
        }
        TempCharBuffer.free(charBuffer);
        if (this._useCount.get() <= 0) {
            throw new IllegalStateException(L.l("Unexpected close of cache inode"));
        }
    }

    public void free() {
        int useCount = this._useCount.decrementAndGet();
        if (useCount == 0) {
            this.remove();
        } else if (useCount < 0) {
            throw new IllegalStateException("illegal use count: " + useCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        long[] blockArray;
        ArrayList<Long> blockList;
        Object object = this;
        synchronized (object) {
            blockList = this._blockList;
            this._blockList = null;
            blockArray = this._blockArray;
            this._blockArray = null;
        }
        if (blockArray != null) {
            if (this._useCount.get() > 0) {
                Thread.dumpStack();
            }
            for (Object block : (Object)blockArray) {
                try {
                    this._store.deallocateBlock((long)block);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            if (this._useCount.get() > 0) {
                Thread.dumpStack();
            }
        } else if (blockList != null) {
            object = blockList.iterator();
            while (object.hasNext()) {
                long block = (Long)object.next();
                try {
                    this._store.deallocateBlock(block);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    static /* synthetic */ long[] access$302(TempFileInode x0, long[] x1) {
        x0._blockArray = x1;
        return x1;
    }

    class TempFileWriter
    extends Writer {
        private final StoreTransaction _xa = RawTransaction.create();
        private final char[] _tempBuffer = new char[8];

        TempFileWriter() {
        }

        public void write(char ch) throws IOException {
            this._tempBuffer[0] = ch;
            this.write(this._tempBuffer, 0, 1);
        }

        @Override
        public void write(char[] buffer, int offset, int length) throws IOException {
            while (length > 0) {
                while ((long)TempFileInode.this._blockList.size() <= TempFileInode.this._length / 8192L) {
                    Block block = TempFileInode.this._store.allocateBlock();
                    TempFileInode.this._blockList.add(block.getBlockId());
                    block.free();
                }
                int blockOffset = (int)(TempFileInode.this._length % 8192L);
                long blockId = (Long)TempFileInode.this._blockList.get(TempFileInode.this._blockList.size() - 1);
                int sublen = (8192 - blockOffset) / 2;
                if (length < sublen) {
                    sublen = length;
                }
                TempFileInode.this._length += 2 * sublen;
                Block block = TempFileInode.this._store.writeBlock(blockId, blockOffset, buffer, offset, sublen);
                this._xa.addUpdateBlock(block);
                length -= sublen;
                offset += sublen;
            }
        }

        @Override
        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TempFileWriter tempFileWriter = this;
            synchronized (tempFileWriter) {
                if (TempFileInode.this._blockList == null) {
                    return;
                }
                TempFileInode.access$302(TempFileInode.this, new long[TempFileInode.this._blockList.size()]);
                for (int i = 0; i < TempFileInode.this._blockList.size(); ++i) {
                    ((TempFileInode)TempFileInode.this)._blockArray[i] = (Long)TempFileInode.this._blockList.get(i);
                }
                TempFileInode.this._blockList = null;
            }
        }
    }

    class TempFileInputStream
    extends InputStream {
        private final byte[] _tempBuffer = new byte[1];
        private int _offset;

        TempFileInputStream() {
        }

        @Override
        public int read() throws IOException {
            int len = this.read(this._tempBuffer, 0, 1);
            if (len > 0) {
                return this._tempBuffer[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (TempFileInode.this._length - (long)this._offset < (long)length) {
                length = (int)(TempFileInode.this._length - (long)this._offset);
            }
            long[] blockArray = TempFileInode.this._blockArray;
            int readLength = 0;
            while (length > 0) {
                int len;
                long blockId = blockArray[this._offset / 8192];
                int blockOffset = this._offset % 8192;
                int sublen = length;
                if (8192 - blockOffset < sublen) {
                    sublen = 8192 - blockOffset;
                }
                if ((len = TempFileInode.this._store.readBlock(blockId, blockOffset, buffer, offset, sublen)) <= 0) break;
                offset += len;
                this._offset += len;
                length -= len;
                readLength += len;
            }
            if (readLength <= 0) {
                return -1;
            }
            return readLength;
        }

        @Override
        public void close() {
        }
    }

    class TempFileOutputStream
    extends OutputStream {
        private final StoreTransaction _xa = RawTransaction.create();
        private final byte[] _tempBuffer = new byte[8];

        TempFileOutputStream() {
        }

        @Override
        public void write(int ch) throws IOException {
            this._tempBuffer[0] = (byte)ch;
            this.write(this._tempBuffer, 0, 1);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            while (length > 0) {
                while ((long)TempFileInode.this._blockList.size() <= TempFileInode.this._length / 8192L) {
                    Block block = TempFileInode.this._store.allocateBlock();
                    TempFileInode.this._blockList.add(block.getBlockId());
                    block.free();
                }
                int blockOffset = (int)(TempFileInode.this._length % 8192L);
                long blockAddress = (Long)TempFileInode.this._blockList.get(TempFileInode.this._blockList.size() - 1);
                int sublen = 8192 - blockOffset;
                if (length < sublen) {
                    sublen = length;
                }
                TempFileInode.this._length += sublen;
                Block block = TempFileInode.this._store.writeBlock(blockAddress, blockOffset, buffer, offset, sublen);
                this._xa.addUpdateBlock(block);
                length -= sublen;
                offset += sublen;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            if (TempFileInode.this._blockList == null) {
                return;
            }
            TempFileInode.access$302(TempFileInode.this, new long[TempFileInode.this._blockList.size()]);
            for (int i = 0; i < TempFileInode.this._blockList.size(); ++i) {
                ((TempFileInode)TempFileInode.this)._blockArray[i] = (Long)TempFileInode.this._blockList.get(i);
            }
        }
    }
}

