/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.CronType;
import com.caucho.config.types.Period;
import com.caucho.network.listen.SocketLink;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLogWriter;
import com.caucho.server.log.LogBuffer;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessLog
extends AbstractAccessLog
implements AlarmListener {
    protected static final L10N L = new L10N(AccessLog.class);
    protected static final Logger log = Logger.getLogger(AccessLog.class.getName());
    private static final long ROLLOVER_SIZE = 0x40000000L;
    public static final int BUFFER_SIZE = 65536;
    private String _timeFormat;
    private final AccessLogWriter _logWriter = new AccessLogWriter(this);
    private String _format;
    private Segment[] _segments;
    private ArrayList<Pattern> _excludeList = new ArrayList();
    private Pattern[] _excludes = new Pattern[0];
    private boolean _isAutoFlush;
    private long _autoFlushTime = 60000L;
    private int _gapUrl = 128;
    private int _gap = 64;
    private Alarm _alarm = new WeakAlarm(this);
    private boolean _isActive;

    public AccessLog() {
        this.setRolloverSize(new Bytes(0x40000000L));
    }

    @Configurable
    public void setBufferSize(Bytes bytes) {
        this._logWriter.setBufferSize(bytes);
    }

    @Override
    public int getBufferSize() {
        return this._logWriter.getBufferSize();
    }

    public void setFormat(String format) {
        this._format = format;
    }

    @Override
    public void setPath(Path path) {
        super.setPath(path);
        this._logWriter.setPath(path);
    }

    @Override
    @Configurable
    public void setPathFormat(String pathFormat) throws ConfigException {
        super.setPathFormat(pathFormat);
        this._logWriter.setPathFormat(pathFormat);
    }

    @Configurable
    public void setArchiveFormat(String format) {
        this._logWriter.setArchiveFormat(format);
    }

    @Configurable
    public void setRolloverCount(int count) {
        this._logWriter.setRolloverCount(count);
    }

    @Configurable
    public void setRolloverCron(CronType cron) {
        this._logWriter.setRolloverCron(cron);
    }

    @Configurable
    public void setRolloverPeriod(Period period) {
        this._logWriter.setRolloverPeriod(period);
    }

    @Configurable
    public void setRolloverSize(Bytes bytes) {
        this._logWriter.setRolloverSize(bytes);
    }

    @Configurable
    public void setRolloverCheckTime(Period period) {
        this._logWriter.setRolloverCheckPeriod(period.getPeriod());
    }

    @Configurable
    public void setAutoFlush(boolean isAutoFlush) {
        this._isAutoFlush = isAutoFlush;
    }

    boolean isAutoFlush() {
        return this._isAutoFlush;
    }

    public void setAutoFlushTime(Period period) {
        this._autoFlushTime = period.getPeriod();
    }

    public void setSharedBuffer(boolean isSharedBuffer) {
    }

    @Configurable
    public void addExclude(Pattern pattern) {
        this._excludeList.add(pattern);
        this._excludes = new Pattern[this._excludeList.size()];
        this._excludeList.toArray(this._excludes);
    }

    @Override
    @PostConstruct
    public void init() throws ServletException, IOException {
    }

    @Override
    public void start() {
        if (this._isActive) {
            return;
        }
        this._isActive = true;
        if (this._alarm != null) {
            if (this._autoFlushTime > 0L) {
                this._alarm.queue(this._autoFlushTime);
            } else {
                this._alarm.queue(60000L);
            }
        }
        if (this._format == null) {
            this._format = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        ArrayList<Segment> segments = this.parseFormat(this._format);
        this._segments = new Segment[segments.size()];
        segments.toArray(this._segments);
        if (this._timeFormat == null || this._timeFormat.equals("")) {
            this._timeFormat = "[%d/%b/%Y:%H:%M:%S %z]";
        }
        try {
            this._logWriter.init();
            super.init();
            this._logWriter.rollover();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ArrayList<Segment> parseFormat(String format) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        block5: while (i < this._format.length()) {
            char ch;
            if ((ch = this._format.charAt(i++)) != '%' || i >= this._format.length()) {
                cb.append(ch);
                continue;
            }
            String arg = null;
            if ((ch = this._format.charAt(i++)) == '>') {
                ch = this._format.charAt(i++);
            } else if (ch == '{') {
                if (cb.length() > 0) {
                    segments.add(new Segment(this, 0, cb.toString()));
                }
                cb.clear();
                while (i < this._format.length() && this._format.charAt(i++) != '}') {
                    cb.append(this._format.charAt(i - 1));
                }
                arg = cb.toString();
                cb.clear();
                ch = this._format.charAt(i++);
            }
            switch (ch) {
                case 'D': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'u': 
                case 'v': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    segments.add(new Segment(this, ch, arg));
                    continue block5;
                }
                case 't': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    if (arg != null) {
                        this._timeFormat = arg;
                    }
                    segments.add(new Segment(this, ch, arg));
                    continue block5;
                }
                case 'V': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    segments.add(new Segment(this, ch, arg));
                    continue block5;
                }
            }
            cb.append('%');
            --i;
        }
        cb.append(CauchoSystem.getNewlineString());
        segments.add(new Segment(this, 0, cb.toString()));
        return segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(HttpServletRequest req, HttpServletResponse res, ServletContext application) throws IOException {
        LogBuffer logBuffer;
        CauchoRequest cRequest = (CauchoRequest)req;
        HttpServletResponseImpl responseImpl = (HttpServletResponseImpl)res;
        AbstractHttpRequest absRequest = cRequest.getAbstractHttpRequest();
        HttpServletRequestImpl request = absRequest.getRequestFacade();
        AbstractHttpResponse response = responseImpl.getAbstractHttpResponse();
        if (this._excludes.length > 0) {
            byte[] data = absRequest.getUriBuffer();
            int sublen = absRequest.getUriLength();
            String uri = new String(data, 0, sublen);
            for (Pattern pattern : this._excludes) {
                if (!pattern.matcher(uri).find()) continue;
                return;
            }
        }
        if (!(logBuffer = response.getLogBuffer()).allocate(this._logWriter)) {
            logBuffer = this._logWriter.allocateBuffer();
        }
        try {
            byte[] buffer = logBuffer.getBuffer();
            int length = this.log(request, responseImpl, response, buffer, 0, buffer.length);
            logBuffer.setLength(length);
            this._logWriter.writeBuffer(logBuffer);
            logBuffer = null;
        }
        finally {
            if (logBuffer != null) {
                this._logWriter.freeBuffer(logBuffer);
            }
        }
    }

    private int log(HttpServletRequestImpl request, HttpServletResponseImpl responseFacade, AbstractHttpResponse response, byte[] buffer, int offset, int length) throws IOException {
        AbstractHttpRequest absRequest = request.getAbstractHttpRequest();
        CharBuffer cb = new CharBuffer();
        block23: for (Segment segment : this._segments) {
            String value = null;
            CharSegment csValue = null;
            switch (segment._code) {
                case 0: {
                    int sublen = segment._data.length;
                    byte[] data = segment._data;
                    for (int j = 0; j < sublen; ++j) {
                        buffer[offset++] = data[j];
                    }
                    continue block23;
                }
                case 1: {
                    buffer[offset++] = segment._ch;
                    continue block23;
                }
                case 98: {
                    if (responseFacade.getStatus() == 304) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, response.getContentLength());
                    continue block23;
                }
                case 99: {
                    Cookie cookie = request.getCookie(segment._string);
                    if (cookie == null) {
                        cookie = responseFacade.getCookie(segment._string);
                    }
                    if (cookie == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, cookie.getValue());
                    continue block23;
                }
                case 2: {
                    ArrayList<Cookie> cookies = responseFacade.getCookies();
                    if (cookies == null) continue block23;
                    int cookiesSize = cookies.size();
                    value = response.getHeader(segment._string);
                    if (cookies != null && cookiesSize > 0) {
                        cb.clear();
                        if (value != null) {
                            cb.append(value);
                        }
                        for (int j = 0; j < cookiesSize; ++j) {
                            Cookie cookie = cookies.get(j);
                            if (cb.getLength() > 0) {
                                cb.append(",");
                            }
                            cb.append(cookie.getName());
                            cb.append('=');
                            cb.append(cookie.getValue());
                        }
                        offset = this.print(buffer, offset, cb.getBuffer(), 0, cb.getLength());
                        continue block23;
                    }
                    if (value != null) {
                        int p = value.indexOf(59);
                        if (p > 0) {
                            offset = this.print(buffer, offset, value, 0, p);
                            continue block23;
                        }
                        offset = this.print(buffer, offset, value);
                        continue block23;
                    }
                    buffer[offset++] = 45;
                    continue block23;
                }
                case 104: {
                    if (this.isHostnameDnsLookup()) {
                        String addrName = request.getRemoteAddr();
                        InetAddress addr = InetAddress.getByName(addrName);
                        offset = this.print(buffer, offset, addr.getHostName());
                        continue block23;
                    }
                    offset = absRequest.printRemoteAddr(buffer, offset);
                    continue block23;
                }
                case 105: {
                    csValue = absRequest.getHeaderBuffer(segment._string);
                    if (csValue == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, csValue);
                    continue block23;
                }
                case 112: {
                    value = request.getParameter(segment._string);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block23;
                }
                case 108: {
                    buffer[offset++] = 45;
                    continue block23;
                }
                case 110: {
                    Object oValue = request.getAttribute(segment._string);
                    if (oValue == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, String.valueOf(oValue));
                    continue block23;
                }
                case 111: {
                    value = response.getHeader(segment._string);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block23;
                }
                case 114: {
                    offset = this.print(buffer, offset, request.getMethod());
                    buffer[offset++] = 32;
                    byte[] data = absRequest.getUriBuffer();
                    int sublen = absRequest.getUriLength();
                    if (buffer.length - offset - this._gapUrl < sublen) {
                        sublen = buffer.length - offset - this._gapUrl;
                        System.arraycopy(data, 0, buffer, offset, sublen);
                        offset += sublen;
                        buffer[offset++] = 46;
                        buffer[offset++] = 46;
                        buffer[offset++] = 46;
                    } else {
                        System.arraycopy(data, 0, buffer, offset, sublen);
                        offset += sublen;
                    }
                    buffer[offset++] = 32;
                    offset = this.print(buffer, offset, request.getProtocol());
                    continue block23;
                }
                case 115: {
                    int status = responseFacade.getStatus();
                    buffer[offset++] = (byte)(48 + status / 100 % 10);
                    buffer[offset++] = (byte)(48 + status / 10 % 10);
                    buffer[offset++] = (byte)(48 + status % 10);
                    continue block23;
                }
                case 83: {
                    String sessionId = request.getRequestedSessionId();
                    if (!request.isRequestedSessionIdValid() || sessionId == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, sessionId);
                    continue block23;
                }
                case 116: {
                    long now = CurrentTime.getCurrentTime();
                    byte[] data = response.fillLogDateBuffer(now, this._timeFormat);
                    int sublen = response.getLogDateBufferLength();
                    System.arraycopy(data, 0, buffer, offset, sublen);
                    offset += sublen;
                    continue block23;
                }
                case 84: {
                    long startTime = request.getStartTime();
                    long endTime = CurrentTime.getCurrentTime();
                    offset = this.print(buffer, offset, (int)((endTime - startTime + 500L) / 1000L));
                    continue block23;
                }
                case 68: {
                    long startTime = request.getStartTime();
                    long endTime = CurrentTime.getExactTime();
                    offset = this.print(buffer, offset, (int)((endTime - startTime) * 1000L));
                    continue block23;
                }
                case 117: {
                    value = request.getRemoteUser(false);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    buffer[offset++] = 34;
                    offset = this.print(buffer, offset, value);
                    buffer[offset++] = 34;
                    continue block23;
                }
                case 118: {
                    value = request.getServerName();
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block23;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block23;
                }
                case 85: {
                    offset = this.print(buffer, offset, request.getRequestURI());
                    continue block23;
                }
                case 86: {
                    offset = this.printVariable(buffer, offset, segment.getArg(), request);
                    continue block23;
                }
                default: {
                    throw new IOException(L.l("Unknown code {0}", (Object)String.valueOf((char)segment._code)));
                }
            }
        }
        return offset;
    }

    private int printVariable(byte[] buffer, int offset, String arg, HttpServletRequestImpl request) {
        if (arg == null) {
            return offset;
        }
        if (arg.equals("ssl_protocol")) {
            SocketLink conn = request.getSocketLink();
            if (conn == null) {
                return offset;
            }
            String protocol = conn.getSslProtocol();
            if (protocol != null) {
                return this.print(buffer, offset, protocol);
            }
            return offset;
        }
        if (arg.equals("ssl_cipher_suite")) {
            SocketLink conn = request.getSocketLink();
            if (conn == null) {
                return offset;
            }
            String cipherSuite = conn.getCipherSuite();
            if (cipherSuite != null) {
                return this.print(buffer, offset, cipherSuite);
            }
            return offset;
        }
        return offset;
    }

    private int print(byte[] buffer, int offset, CharSegment cb) {
        if (cb == null) {
            return offset;
        }
        char[] charBuffer = cb.getBuffer();
        int cbOffset = cb.getOffset();
        int length = cb.getLength();
        if (buffer.length - offset - this._gap < length) {
            int space = Math.min(buffer.length - offset, Math.max(8, buffer.length - offset - this._gap));
            length = Math.min(length, space);
        }
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[cbOffset + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, String s) {
        if (s == null) {
            return offset;
        }
        int length = s.length();
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)s.charAt(i);
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, String s, int sOff, int sLen) {
        for (int i = sLen - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)s.charAt(sOff + i);
        }
        return offset + sLen;
    }

    private int print(byte[] buffer, int offset, char[] cb, int cbOff, int length) {
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cb[cbOff + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, long v) {
        if (v == 0L) {
            buffer[offset] = 48;
            return offset + 1;
        }
        if (v < 0L) {
            buffer[offset++] = 45;
            v = -v;
        }
        int length = 0;
        int exp = 10;
        while ((long)exp <= v && exp > 0) {
            exp = 10 * exp;
            ++length;
        }
        offset += length;
        for (int i = 0; i <= length; ++i) {
            buffer[offset - i] = (byte)(v % 10L + 48L);
            v /= 10L;
        }
        return offset + 1;
    }

    @Override
    public void flush() {
        this._logWriter.flush();
        this._logWriter.waitForFlush(5000L);
        this._logWriter.rollover();
    }

    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            this.flush();
        }
        finally {
            alarm = this._alarm;
            if (alarm != null && this._isActive && this._autoFlushTime > 0L) {
                alarm.queue(this._autoFlushTime);
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        super.destroy();
        this._isActive = false;
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        this.flush();
        this._logWriter.close();
    }

    static class Segment {
        static final int TEXT = 0;
        static final int CHAR = 1;
        static final int SET_COOKIE = 2;
        int _code;
        byte[] _data;
        byte _ch;
        String _string;
        AccessLog _log;

        Segment(AccessLog log, int code, String string) {
            this._log = log;
            this._code = code;
            this._string = string;
            if (string != null) {
                if (code == 111 && string.equalsIgnoreCase("Set-Cookie")) {
                    this._code = 2;
                }
                this._data = this._string.getBytes();
                if (code == 0 && this._string.length() == 1) {
                    this._ch = (byte)this._string.charAt(0);
                    this._code = 1;
                }
            }
        }

        private String getArg() {
            return this._string;
        }
    }
}

