/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.topology.CloudSystem;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.functions.FmtFunctions;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.env.service.ResinSystem;
import com.caucho.naming.Jndi;
import com.caucho.server.resin.BootResinConfig;
import com.caucho.server.resin.BootResinEnvConfig;
import com.caucho.server.resin.JavaVar;
import com.caucho.server.resin.ResinVar;
import com.caucho.server.webbeans.ResinCdiProducer;
import com.caucho.server.webbeans.ResinServerConfigLibrary;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class BootConfig {
    private final ResinSystem _resinSystem;
    private final String _serverId;
    private final Path _resinHome;
    private final Path _rootDirectory;
    private final Path _logDirectory;
    private final Path _resinConf;
    private final boolean _isProfessional;
    private final BootResinConfig _bootResinConfig;
    private CloudSystem _cloudSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootConfig(ResinSystem resinSystem, String serverId, Path resinHome, Path rootDirectory, Path logDirectory, Path resinConf, boolean isProfessional, BootType bootType) {
        this._resinSystem = resinSystem;
        this._serverId = serverId;
        this._resinHome = resinHome;
        this._rootDirectory = rootDirectory;
        this._logDirectory = logDirectory;
        this._resinConf = resinConf;
        this._isProfessional = isProfessional;
        switch (bootType) {
            case RESIN: {
                this._bootResinConfig = new BootResinEnvConfig(this._resinSystem);
                break;
            }
            default: {
                this._bootResinConfig = new BootResinConfig(this._resinSystem);
            }
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            this.preConfigInit();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public BootResinConfig getBootResin() {
        return this._bootResinConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureFile(Path path) {
        if (path == null || !path.canRead()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            Vfs.setPwd(this._rootDirectory);
            Config config = new Config();
            config.configure((Object)this._bootResinConfig, path, this._bootResinConfig.getSchema());
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void preConfigInit() {
        ResinVar resinVar = new ResinVar(this._serverId, this._resinHome, this._rootDirectory, this._logDirectory, this._resinConf, this._isProfessional, null);
        Config.setProperty("resinHome", this._resinHome);
        Config.setProperty("resin", resinVar);
        Config.setProperty("server", resinVar);
        Config.setProperty("java", new JavaVar());
        Config.setProperty("system", System.getProperties());
        Config.setProperty("getenv", System.getenv());
        Config.setProperty("server_id", this._serverId);
        Config.setProperty("serverId", this._serverId);
        Config.setProperty("rvar0", this._serverId);
        InjectManager cdiManager = InjectManager.create();
        if (cdiManager.getBeans((Type)((Object)ResinCdiProducer.class), new Annotation[0]).size() == 0) {
            Config.setProperty("fmt", new FmtFunctions());
            ResinConfigLibrary.configure(cdiManager);
            try {
                Method method = Jndi.class.getMethod("lookup", String.class);
                Config.setProperty("jndi", method);
                Config.setProperty("jndi:lookup", method);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            cdiManager.addManagedBeanDiscover(cdiManager.createManagedBean(ResinCdiProducer.class));
            Class<?> resinValidatorClass = ResinCdiProducer.createResinValidatorProducer();
            if (resinValidatorClass != null) {
                cdiManager.addManagedBeanDiscover(cdiManager.createManagedBean(resinValidatorClass));
            }
            cdiManager.update();
        }
        ResinServerConfigLibrary.configure(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudSystem initTopolopy() {
        BootConfig bootConfig = this;
        synchronized (bootConfig) {
            if (this._cloudSystem == null) {
                this._cloudSystem = this._bootResinConfig.initTopology();
            }
        }
        return this._cloudSystem;
    }

    public static enum BootType {
        RESIN,
        WATCHDOG;

    }
}

