/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.DependencyBean;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.resin.AbstractResinConfig;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootClusterProxy;
import com.caucho.server.resin.BootPodConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.server.resin.ResinArgs;
import com.caucho.vfs.PersistentDependency;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootResinConfig
extends AbstractResinConfig
implements SchemaBean,
DependencyBean {
    private static final Logger log = Logger.getLogger(BootResinConfig.class.getName());
    private ResinSystem _resinSystem;
    private String _clusterSystemKey;
    private String _homeServer;
    private String _homeCluster;
    private boolean _isElasticServer;
    private ContainerProgram _resinProgram = new ContainerProgram();
    private ArrayList<ConfigProgram> _clusterDefaults = new ArrayList();
    private ArrayList<BootClusterConfig> _clusters = new ArrayList();
    private String _elasticServerAddress;
    private int _elasticServerPort;
    private int _elasticServerIndex = -1;

    public BootResinConfig(ResinSystem resinSystem) {
        this._resinSystem = resinSystem;
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._resinSystem.getClassLoader();
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/resin.rnc";
    }

    @Configurable
    public void setResinSystemAuthKey(String key) {
        this.setClusterSystemKey(key);
    }

    @Configurable
    public void setClusterSystemKey(String key) {
        this._clusterSystemKey = key;
    }

    public String getClusterSystemKey() {
        return this._clusterSystemKey;
    }

    public void setHomeServer(String homeServer) {
        if (homeServer != null && !homeServer.isEmpty()) {
            this._homeServer = homeServer;
        }
    }

    public String getHomeServer() {
        return this._homeServer;
    }

    public void setHomeCluster(String homeCluster) {
        this._homeCluster = homeCluster;
    }

    public String getHomeCluster() {
        return this._homeCluster;
    }

    public void setElasticServer(boolean isElasticServer) {
        this._isElasticServer = isElasticServer;
    }

    public boolean isElasticServer(ResinArgs args) {
        if (args.isElasticServer()) {
            return args.isElasticServer();
        }
        return this._isElasticServer;
    }

    public void setElasticServerPort(int port) {
        this._elasticServerPort = port;
    }

    public int getElasticServerPort(ResinArgs args) {
        if (args.getElasticServerPort() > 0) {
            return args.getElasticServerPort();
        }
        return this._elasticServerPort;
    }

    public void setElasticServerAddress(String address) {
        this._elasticServerAddress = address;
    }

    public String getElasticServerAddress(ResinArgs args) {
        if (args.getElasticServerAddress() != null) {
            return args.getElasticServerAddress();
        }
        return this._elasticServerAddress;
    }

    public int getElasticServerIndex(ResinArgs args) {
        if (args.getElasticServerIndex() > 0) {
            return args.getElasticServerIndex();
        }
        return this._elasticServerIndex;
    }

    @Configurable
    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaults.add(program);
    }

    @Configurable
    public void addCluster(BootClusterProxy clusterProxy) throws ConfigException {
        BootClusterConfig cluster = this.addClusterById(clusterProxy.getId());
        clusterProxy.getProgram().configure(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BootClusterConfig addClusterById(String id) throws ConfigException {
        BootClusterConfig cluster = this.findCluster(id);
        if (cluster == null) {
            cluster = new BootClusterConfig(this);
            cluster.setId(id);
            this._clusters.add(cluster);
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Object oldCluster = null;
            try {
                oldCluster = Config.getProperty("cluster");
                Config.setProperty("cluster", new ClusterConfigVar(cluster));
                for (int i = 0; i < this._clusterDefaults.size(); ++i) {
                    this._clusterDefaults.get(i).configure(cluster);
                }
                cluster.init();
            }
            finally {
                Config.setProperty("cluster", oldCluster);
                thread.setContextClassLoader(loader);
            }
        }
        return cluster;
    }

    public BootClusterConfig findCluster(String id) {
        if (id == null) {
            if (this._clusters.size() == 1) {
                return this._clusters.get(0);
            }
            return null;
        }
        for (BootClusterConfig cluster : this._clusters) {
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        return null;
    }

    public ArrayList<BootClusterConfig> getClusterList() {
        return this._clusters;
    }

    BootServerConfig findServer(String id) {
        for (BootClusterConfig cluster : this.getClusterList()) {
            for (BootPodConfig pod : cluster.getPodList()) {
                for (BootServerConfig server : pod.getServerList()) {
                    if (!id.equals(server.getId())) continue;
                    return server;
                }
            }
        }
        return null;
    }

    public void addContentProgram(ConfigProgram program) {
        this._resinProgram.addProgram(program);
    }

    public ConfigProgram getProgram() {
        return this._resinProgram;
    }

    @Override
    public void addDependency(PersistentDependency dependency) {
        this.getClassLoader().addDependency(dependency);
    }

    CloudSystem initTopology() {
        TopologyService topology = this._resinSystem.getService(TopologyService.class);
        if (topology == null) {
            this._resinSystem.addServiceIfAbsent(new TopologyService(this._resinSystem.getId()));
            topology = this._resinSystem.getService(TopologyService.class);
        }
        this.initTopology(topology.getSystem());
        return topology.getSystem();
    }

    private void initTopology(CloudSystem cloudSystem) {
        for (BootClusterConfig bootCluster : this._clusters) {
            this.initTopology(bootCluster);
        }
    }

    public void initTopology(BootClusterConfig bootCluster) {
        CloudSystem cloudSystem = TopologyService.getCurrentSystem();
        CloudCluster cloudCluster = cloudSystem.findCluster(bootCluster.getId());
        if (cloudCluster == null) {
            cloudCluster = cloudSystem.createCluster(bootCluster.getId());
        }
        bootCluster.initTopology(cloudCluster);
    }

    public BootServerConfig findLocalServer() {
        for (BootClusterConfig cluster : this.getClusterList()) {
            for (BootPodConfig pod : cluster.getPodList()) {
                for (BootServerConfig server : pod.getServerList()) {
                    if (server.isRequireExplicitId()) continue;
                    try {
                        InetAddress address = InetAddress.getByName(server.getAddress());
                        if (!address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress()) continue;
                        return server;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
        }
        return null;
    }

    static class ClusterConfigVar {
        private BootClusterConfig _cluster;

        public ClusterConfigVar(BootClusterConfig cluster) {
            this._cluster = cluster;
        }

        public String getId() {
            return this._cluster.getId();
        }
    }
}

