/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebAppRegexpDeployGenerator
extends DeployGenerator<WebAppController> {
    private static final Logger log = Logger.getLogger(WebAppSingleDeployGenerator.class.getName());
    private WebAppContainer _container;
    private WebAppController _parent;
    private WebAppConfig _config;
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private ArrayList<WebAppController> _entries = new ArrayList();

    public WebAppRegexpDeployGenerator(DeployContainer<WebAppController> deployContainer) {
        super(deployContainer);
    }

    public WebAppRegexpDeployGenerator(DeployContainer<WebAppController> deployContainer, WebAppContainer container, WebAppConfig config) {
        super(deployContainer);
        this.setContainer(container);
        this._config = config;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setContainer(WebAppContainer container) {
        this._container = container;
    }

    public void setParent(WebAppController parent) {
        this._parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void generateController(String name, ArrayList<WebAppController> list) {
        Pattern regexp = this._config.getURLRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find()) return;
        if (matcher.start() != 0) {
            return;
        }
        int length = matcher.end() - matcher.start();
        String contextPath = matcher.group();
        ArrayList<String> vars = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        for (int j = 0; j <= matcher.groupCount(); ++j) {
            vars.add(matcher.group(j));
            varMap.put("app" + j, matcher.group(j));
        }
        varMap.put("regexp", vars);
        Path appDir = null;
        try {
            String appDirPath = this._config.getRootDirectory();
            if (appDirPath == null) {
                appDirPath = "./" + matcher.group(0);
            }
            if (!(appDir = PathBuilder.lookupPath(appDirPath, varMap)).isDirectory()) return;
            if (!appDir.canRead()) {
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return;
        }
        WebAppController controller = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            ArrayList<WebAppController> arrayList = this._entries;
            synchronized (arrayList) {
                for (int i = 0; i < this._entries.size(); ++i) {
                    controller = this._entries.get(i);
                    if (!appDir.equals(controller.getRootDirectory())) continue;
                    list.add(controller);
                    return;
                }
                String stage = this._container.getServer().getStage();
                String hostId = this._container.getHost().getIdTail();
                String id = name.startsWith("/") ? stage + "/webapp/" + hostId + name : stage + "/webapp/" + hostId + "/" + name;
                controller = new WebAppController(id, appDir, this._container, name);
                controller.getVariableMap().putAll(varMap);
                controller.setRegexpValues(vars);
                controller.setConfig(this._config);
                for (int i = 0; i < this._webAppDefaults.size(); ++i) {
                    controller.addConfigDefault((DeployConfig)this._webAppDefaults.get(i));
                }
                this._entries.add(controller);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        controller.setSourceType("regexp");
        list.add(controller);
    }

    @Override
    public String toString() {
        if (this._config == null) {
            return "WebAppRegexpDeployGenerator[]";
        }
        return "WebAppRegexpDeployGenerator[" + this._config.getURLRegexp().pattern() + "]";
    }
}

