/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.ConfigPropertiesResolver;
import com.caucho.config.inject.InjectManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinServerConfigLibrary {
    private static final L10N L = new L10N(ResinServerConfigLibrary.class);
    private static final Logger log = Logger.getLogger(ResinServerConfigLibrary.class.getName());

    public static String file_lookup(String resource, String pwd) {
        if (resource == null || resource.trim().isEmpty()) {
            return null;
        }
        if (pwd == null) {
            throw new ConfigException(L.l("file_lookup requires a pwd argument"));
        }
        Path pwdPath = Vfs.lookup(pwd);
        return pwdPath.lookup(resource).getFullPath();
    }

    public static Object rvar(String var) {
        String resinProp;
        String resinKey;
        Object value = null;
        String[] stringArray = ConfigPropertiesResolver.RESIN_PROPERTIES;
        int n = stringArray.length;
        for (int i = 0; i < n && (resinKey = (String)ResinServerConfigLibrary.getProperty(resinProp = stringArray[i])) != null; ++i) {
            value = ResinServerConfigLibrary.getProperty(resinKey + '.' + var);
            if (value == null) continue;
            return value;
        }
        return ResinServerConfigLibrary.getProperty(var);
    }

    private static Object getProperty(String name) {
        return Config.getElVar(name);
    }

    public static void configure(InjectManager webBeans) {
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            for (Method m : ResinServerConfigLibrary.class.getMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || m.getName().equals("configure")) continue;
                Config.setProperty(m.getName(), m, loader);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }
}

