/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.VersionFactory;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CGIServlet
extends GenericServlet {
    protected static final Logger log = Logger.getLogger(CGIServlet.class.getName());
    static final L10N L = new L10N(CGIServlet.class);
    private String _executable;
    private boolean _stderrIsException = true;
    private boolean _ignoreExitCode = false;
    private ArrayList<String> _envMap = new ArrayList();

    public void setExecutable(String executable) {
        this._executable = executable;
    }

    public void setStderrIsException(boolean isException) {
        this._stderrIsException = isException;
    }

    public void setIgnoreExitCode(boolean ignoreExitCode) {
        this._ignoreExitCode = ignoreExitCode;
    }

    public CgiEnv createEnv() {
        return new CgiEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block52: {
            String pathInfo;
            String scriptPath;
            String queryString;
            String servletPathInfo;
            String servletPath;
            String contextPath;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String requestURI = (String)req.getAttribute("javax.servlet.include.request_uri");
            if (requestURI != null) {
                contextPath = (String)req.getAttribute("javax.servlet.include.context_path");
                servletPath = (String)req.getAttribute("javax.servlet.include.servlet_path");
                servletPathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
                queryString = (String)req.getAttribute("javax.servlet.include.query_string");
            } else {
                requestURI = req.getRequestURI();
                contextPath = req.getContextPath();
                servletPath = req.getServletPath();
                servletPathInfo = req.getPathInfo();
                queryString = req.getQueryString();
            }
            if (servletPathInfo == null) {
                scriptPath = servletPath;
                pathInfo = null;
            } else {
                String fullPath = servletPath + servletPathInfo;
                int i = this.findScriptPathIndex(req, fullPath);
                if (i < 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(L.l("no script path index for `{0}'", (Object)fullPath));
                    }
                    res.sendError(404);
                    return;
                }
                scriptPath = fullPath.substring(0, i);
                pathInfo = fullPath.substring(i);
                if ("".equals(pathInfo)) {
                    pathInfo = null;
                }
            }
            String realPath = this.getServletContext().getRealPath(scriptPath);
            Path vfsPath = Vfs.lookup(realPath);
            if (!vfsPath.canRead() || vfsPath.isDirectory()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(L.l("script '{0}' is unreadable", (Object)vfsPath));
                }
                res.sendError(404);
                return;
            }
            String[] env = this.createEnvironment(req, requestURI, contextPath, scriptPath, pathInfo, queryString);
            String[] args = this.getArgs(realPath);
            if (log.isLoggable(Level.FINER)) {
                if (args.length > 1) {
                    log.finer("[cgi] exec " + args[0] + " " + args[1]);
                } else if (args.length > 0) {
                    log.finer("[cgi] exec " + args[0]);
                }
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            Alarm alarm = null;
            try {
                int exitCode;
                int ch;
                File dir = new File(Vfs.lookup(realPath).getParent().getNativePath());
                if (log.isLoggable(Level.FINE)) {
                    CharBuffer argsBuf = new CharBuffer();
                    argsBuf.append('[');
                    for (String arg : args) {
                        if (argsBuf.length() > 1) {
                            argsBuf.append(", ");
                        }
                        argsBuf.append('\"');
                        argsBuf.append(arg);
                        argsBuf.append('\"');
                    }
                    argsBuf.append(']');
                    log.fine(L.l("exec {0} (pwd={1})", (Object)argsBuf, (Object)dir));
                    if (log.isLoggable(Level.FINEST)) {
                        for (String envElement : env) {
                            log.finest(envElement);
                        }
                    }
                }
                process = runtime.exec(args, env, dir);
                InputStream inputStream = process.getInputStream();
                InputStream errorStream = process.getErrorStream();
                TimeoutAlarm timeout = new TimeoutAlarm(requestURI, process, inputStream);
                alarm = new Alarm(timeout, 360000L);
                OutputStream outputStream = process.getOutputStream();
                TempBuffer tempBuf = TempBuffer.allocate();
                byte[] buf = tempBuf.getBuffer();
                try {
                    int len;
                    ServletInputStream sis = req.getInputStream();
                    while ((len = sis.read(buf, 0, buf.length)) > 0) {
                        outputStream.write(buf, 0, len);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                finally {
                    outputStream.close();
                }
                TempBuffer.free(tempBuf);
                tempBuf = null;
                ReadStream rs = Vfs.openRead(inputStream);
                boolean hasStatus = false;
                try {
                    hasStatus = this.parseHeaders(req, res, rs);
                    ServletOutputStream out = res.getOutputStream();
                    rs.writeToStream((OutputStream)out);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                    inputStream.close();
                }
                StringBuilder error = new StringBuilder();
                boolean hasContent = false;
                while (errorStream.available() > 0 && (ch = errorStream.read()) > 0) {
                    error.append((char)ch);
                    if (Character.isWhitespace((char)ch)) continue;
                    hasContent = true;
                }
                errorStream.close();
                if (hasContent) {
                    String errorString = error.toString();
                    log.warning(errorString);
                    if (!hasStatus && this._stderrIsException) {
                        throw new ServletException(errorString);
                    }
                }
                if ((exitCode = process.waitFor()) == 0) break block52;
                if (hasStatus) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("exit code {0} (ignored, hasStatus)", exitCode));
                    }
                    break block52;
                }
                if (this._ignoreExitCode) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(L.l("exit code {0} (ignored)", exitCode));
                    }
                    break block52;
                }
                throw new ServletException(L.l("CGI execution failed.  Exit code {0}", exitCode));
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (alarm != null) {
                    alarm.dequeue();
                }
                try {
                    process.destroy();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private int findScriptPathIndex(HttpServletRequest req, String fullPath) {
        int head;
        String realPath = req.getRealPath(fullPath);
        Path path = Vfs.lookup(realPath);
        if (log.isLoggable(Level.FINER)) {
            log.finer(L.l("real-path is `{0}'", (Object)path));
        }
        if (path.canRead() && !path.isDirectory()) {
            return fullPath.length();
        }
        int tail = fullPath.length();
        while ((head = fullPath.lastIndexOf(47, tail)) >= 0) {
            String subPath = fullPath.substring(0, head);
            realPath = req.getRealPath(subPath);
            path = Vfs.lookup(realPath);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(L.l("trying script path {0}", (Object)path));
            }
            if (path.canRead() && !path.isDirectory()) {
                return head;
            }
            tail = head - 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getArgs(String path) {
        if (this._executable != null) {
            return new String[]{this._executable, path};
        }
        try (ReadStream is = null;){
            is = Vfs.lookup(path).openRead();
            if (is.read() != 35) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            if (is.read() != 33) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            CharBuffer cb = CharBuffer.allocate();
            ArrayList<String> list = new ArrayList<String>();
            int ch = is.read();
            while (ch >= 0 && ch != 13 && ch != 10) {
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
                if (ch < 0 || ch == 13 || ch == 10) {
                    if (list.size() > 0) {
                        list.add(path);
                        String[] stringArray = list.toArray(new String[list.size()]);
                        return stringArray;
                    }
                    String[] stringArray = new String[]{path};
                    return stringArray;
                }
                cb.clear();
                while (ch > 0 && ch != 32 && ch != 9 && ch != 13 && ch != 10) {
                    cb.append((char)ch);
                    ch = is.read();
                }
                list.add(cb.toString());
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
            }
            if (list.size() > 0) {
                list.add(path);
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{path};
            return stringArray;
        }
    }

    private String[] createEnvironment(HttpServletRequest req, String requestURI, String contextPath, String scriptPath, String pathInfo, String queryString) {
        boolean isFine = log.isLoggable(Level.FINE);
        ArrayList<String> env = new ArrayList<String>();
        env.add("SERVER_SOFTWARE=Resin/" + VersionFactory.getVersion());
        env.add("SERVER_NAME=" + req.getServerName());
        env.add("REDIRECT_STATUS=200");
        env.add("SERVER_PORT=" + req.getServerPort());
        env.add("REMOTE_ADDR=" + req.getRemoteAddr());
        if (req.getRemoteUser() != null) {
            env.add("REMOTE_USER=" + req.getRemoteUser());
        }
        if (req.getAuthType() != null) {
            env.add("AUTH_TYPE=" + req.getAuthType());
        }
        env.add("GATEWAY_INTERFACE=CGI/1.1");
        env.add("SERVER_PROTOCOL=" + req.getProtocol());
        env.add("REQUEST_METHOD=" + req.getMethod());
        if (isFine) {
            log.fine("[cgi] REQUEST_METHOD=" + req.getMethod());
        }
        if (queryString != null) {
            env.add("QUERY_STRING=" + queryString);
            if (isFine) {
                log.fine("[cgi] QUERY_STRING=" + queryString);
            }
        }
        env.add("REQUEST_URI=" + requestURI);
        if (isFine) {
            log.fine("[cgi] REQUEST_URI=" + requestURI);
        }
        env.add("SCRIPT_FILENAME=" + req.getRealPath(scriptPath));
        scriptPath = contextPath + scriptPath;
        env.add("SCRIPT_NAME=" + scriptPath);
        if (isFine) {
            log.fine("[cgi] SCRIPT_NAME=" + scriptPath);
        }
        if (pathInfo != null) {
            env.add("PATH_INFO=" + pathInfo);
            env.add("PATH_TRANSLATED=" + req.getRealPath(pathInfo));
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (isFine) {
                log.fine("[cgi] " + key + "=" + value);
            }
            if (key.equalsIgnoreCase("content-length")) {
                env.add("CONTENT_LENGTH=" + value);
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                env.add("CONTENT_TYPE=" + value);
                continue;
            }
            if (key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            env.add(this.convertHeader(key, value));
        }
        env.addAll(this._envMap);
        return env.toArray(new String[env.size()]);
    }

    private String convertHeader(String key, String value) {
        CharBuffer cb = new CharBuffer();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        cb.append('=');
        cb.append(value);
        return cb.close();
    }

    private boolean parseHeaders(HttpServletRequest req, HttpServletResponse res, ReadStream rs) throws IOException {
        boolean hasStatus = false;
        CharBuffer key = new CharBuffer();
        CharBuffer value = new CharBuffer();
        while (true) {
            key.clear();
            value.clear();
            int ch = rs.read();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = rs.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                rs.unread();
            }
            if (key.length() == 0) {
                return hasStatus;
            }
            String keyStr = key.toString();
            String valueStr = value.toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer(keyStr + ": " + valueStr);
            }
            if (keyStr.equalsIgnoreCase("Status")) {
                int i;
                int status = 0;
                int len = valueStr.length();
                hasStatus = true;
                for (i = 0; i < len; ++i) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    status = 10 * status + ch - 48;
                }
                while (i < len) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c != ' ') break;
                    ++i;
                }
                if (status < 304) {
                    res.setStatus(status);
                    continue;
                }
                res.setStatus(status, valueStr.substring(i));
                continue;
            }
            if (keyStr.equalsIgnoreCase("Location")) {
                String uri = valueStr.startsWith("/") ? req.getContextPath() + valueStr : valueStr;
                res.setHeader("Location", res.encodeRedirectURL(uri));
                continue;
            }
            res.addHeader(keyStr, valueStr);
        }
    }

    public class CgiEnv {
        public void setProperty(String key, String value) {
            CGIServlet.this._envMap.add(key + "=" + value);
        }
    }

    class TimeoutAlarm
    implements AlarmListener {
        String _uri;
        Process _process;
        InputStream _is;

        TimeoutAlarm(String uri, Process process, InputStream is) {
            this._uri = uri;
            this._process = process;
            this._is = is;
        }

        @Override
        public void handleAlarm(Alarm alarm) {
            log.warning("timing out CGI process for '" + this._uri + "'");
            try {
                this._is.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._process.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

