/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.servlets.ssi.BlockStatement;
import com.caucho.servlets.ssi.ElifStatement;
import com.caucho.servlets.ssi.ElseStatement;
import com.caucho.servlets.ssi.EndifStatement;
import com.caucho.servlets.ssi.ErrorStatement;
import com.caucho.servlets.ssi.IfStatement;
import com.caucho.servlets.ssi.SSIFactory;
import com.caucho.servlets.ssi.Statement;
import com.caucho.servlets.ssi.TextStatement;
import com.caucho.util.ByteBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SSIParser {
    private int _line;
    private final SSIFactory _factory;

    public SSIParser() {
        this._factory = new SSIFactory();
    }

    public SSIParser(SSIFactory factory) {
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statement parse(Path path) throws IOException {
        try (ReadStream is = path.openRead();){
            ArrayList<Statement> statements = new ArrayList<Statement>();
            this.parse(is, statements);
            BlockStatement blockStatement = new BlockStatement(statements);
            return blockStatement;
        }
    }

    Statement parse(ReadStream is) throws IOException {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        this.parse(is, statements);
        return new BlockStatement(statements);
    }

    private void parse(ReadStream is, ArrayList<Statement> statements) throws IOException {
        int ch;
        ByteBuffer bb = new ByteBuffer();
        while ((ch = is.read()) >= 0) {
            if (ch != 60) {
                if (ch == 10) {
                    ++this._line;
                }
                bb.append(ch);
                continue;
            }
            ch = is.read();
            if (ch != 33) {
                bb.append(60);
                is.unread();
                continue;
            }
            ch = is.read();
            if (ch != 45) {
                bb.append(60);
                bb.append(33);
                is.unread();
                continue;
            }
            ch = is.read();
            if (ch != 45) {
                bb.append(60);
                bb.append(33);
                bb.append(45);
                is.unread();
                continue;
            }
            ch = is.read();
            if (ch != 35) {
                bb.append(60);
                bb.append(33);
                bb.append(45);
                bb.append(45);
                is.unread();
                continue;
            }
            if (bb.getLength() > 0) {
                TextStatement text = new TextStatement(bb.getBuffer(), 0, bb.getLength());
                statements.add(text);
                bb.clear();
            }
            Statement stmt = this.parseCommand(is);
            statements.add(stmt);
            if (stmt instanceof IfStatement) {
                this.parseIf(is, (IfStatement)stmt);
            }
            if (stmt instanceof ElifStatement) {
                return;
            }
            if (stmt instanceof ElseStatement) {
                return;
            }
            if (!(stmt instanceof EndifStatement)) continue;
            return;
        }
        if (bb.getLength() > 0) {
            statements.add(new TextStatement(bb.getBuffer(), 0, bb.getLength()));
            bb.clear();
        }
    }

    private void parseIf(ReadStream is, IfStatement ifStmt) throws IOException {
        ArrayList<Statement> trueBlock = new ArrayList<Statement>();
        this.parse(is, trueBlock);
        int size = trueBlock.size();
        if (size > 0 && trueBlock.get(size - 1) instanceof ElifStatement) {
            ElifStatement elifBlock = (ElifStatement)trueBlock.get(size - 1);
            trueBlock.remove(size - 1);
            ifStmt.setFalseBlock(elifBlock);
        } else if (size > 0 && trueBlock.get(size - 1) instanceof ElseStatement) {
            ArrayList<Statement> falseBlock = new ArrayList<Statement>();
            this.parse(is, falseBlock);
            ifStmt.setFalseBlock(new BlockStatement(falseBlock));
        }
        ifStmt.setTrueBlock(new BlockStatement(trueBlock));
    }

    private Statement parseCommand(ReadStream is) throws IOException {
        Statement statement;
        int ch;
        StringBuilder sb = new StringBuilder();
        while (Character.isLetterOrDigit(ch = is.read())) {
            sb.append((char)ch);
        }
        String cmd = sb.toString();
        HashMap<String, String> attr = this.parseAttributes(is);
        ch = is.read();
        if (ch != 45 || (ch = is.read()) != 45 || (ch = is.read()) != 62) {
            // empty if block
        }
        if ((statement = this._factory.createStatement(cmd, attr, is.getPath())) == null) {
            statement = new ErrorStatement("['" + cmd + "' is an unknown command.]");
        }
        return statement;
    }

    private HashMap<String, String> parseAttributes(ReadStream is) throws IOException {
        HashMap<String, String> attr = new HashMap<String, String>();
        while (true) {
            int ch;
            if (Character.isWhitespace(ch = is.read())) {
                continue;
            }
            StringBuilder key = new StringBuilder();
            while (Character.isLetterOrDigit(ch)) {
                key.append((char)ch);
                ch = is.read();
            }
            while (Character.isWhitespace(ch)) {
                ch = is.read();
            }
            if (ch != 61) {
                return attr;
            }
            ch = is.read();
            while (Character.isWhitespace(ch)) {
                ch = is.read();
            }
            StringBuilder value = new StringBuilder();
            if (ch == 39 || ch == 34) {
                int end = ch;
                ch = is.read();
                while (ch > 0 && ch != end) {
                    if (ch == 92) {
                        ch = is.read();
                        if (ch == 39 || ch == 34) {
                            value.append((char)ch);
                        } else {
                            value.append('\\');
                            is.unread();
                        }
                    } else {
                        value.append((char)ch);
                    }
                    ch = is.read();
                }
            } else {
                while (ch > 0 && !Character.isWhitespace(ch)) {
                    value.append((char)ch);
                    ch = is.read();
                }
            }
            attr.put(key.toString(), value.toString());
        }
    }
}

