/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.CallableStatementWrapper;
import com.caucho.tools.profiler.PreparedStatementWrapper;
import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.tools.profiler.StatementWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public final class ConnectionWrapper
implements Connection {
    private final Connection _connection;
    private final ProfilerPoint _profilerPoint;

    public ConnectionWrapper(ProfilerPoint profilerPoint, Connection connection) {
        this._profilerPoint = profilerPoint;
        this._connection = connection;
    }

    private ProfilerPoint createProfilerPoint(String sql) {
        return this._profilerPoint.addProfilerPoint(sql);
    }

    private StatementWrapper wrap(Statement statement) {
        return new StatementWrapper(this._profilerPoint, statement);
    }

    private PreparedStatementWrapper wrap(String sql, PreparedStatement statement) {
        ProfilerPoint profilerPoint = this.createProfilerPoint(sql);
        return new PreparedStatementWrapper(profilerPoint, statement);
    }

    private CallableStatementWrapper wrap(String sql, CallableStatement statement) {
        ProfilerPoint profilerPoint = this.createProfilerPoint(sql);
        return new CallableStatementWrapper(profilerPoint, statement);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.wrap(this._connection.createStatement());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrap(this._connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrap(this._connection.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ProfilerPoint profilerPoint = this._profilerPoint.addProfilerPoint(sql);
        return this.wrap(sql, this._connection.prepareStatement(sql));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ProfilerPoint profilerPoint = this._profilerPoint.addProfilerPoint(sql);
        return this.wrap(sql, this._connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.wrap(sql, this._connection.prepareCall(sql));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrap(sql, this._connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrap(sql, this._connection.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.wrap(sql, this._connection.prepareStatement(sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.wrap(sql, this._connection.prepareStatement(sql, columnNames));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrap(sql, this._connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrap(sql, this._connection.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String sql) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            String string = this._connection.nativeSQL(sql);
            return string;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setAutoCommit(autoCommit);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._connection.getAutoCommit();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void commit() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.commit();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void rollback() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.rollback();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._connection.isClosed();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            return databaseMetaData;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setReadOnly(readOnly);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            boolean bl = this._connection.isReadOnly();
            return bl;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setCatalog(catalog);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            String string = this._connection.getCatalog();
            return string;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setTransactionIsolation(level);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._connection.getTransactionIsolation();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            SQLWarning sQLWarning = this._connection.getWarnings();
            return sQLWarning;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.clearWarnings();
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Map<String, Class<?>> map = this._connection.getTypeMap();
            return map;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setTypeMap(map);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.setHoldability(holdability);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            int n = this._connection.getHoldability();
            return n;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Savepoint savepoint = this._connection.setSavepoint();
            return savepoint;
        }
        finally {
            profiler.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            Savepoint savepoint = this._connection.setSavepoint(name);
            return savepoint;
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.rollback(savepoint);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.releaseSavepoint(savepoint);
        }
        finally {
            profiler.finish();
        }
    }

    @Override
    public void close() throws SQLException {
        Profiler profiler = this._profilerPoint.start();
        try {
            this._connection.close();
        }
        finally {
            profiler.finish();
        }
    }

    public String toString() {
        return "ConnectionWrapper[" + this._profilerPoint.getName() + "]";
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }
}

