/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ActorQueue;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public abstract class AbstractActorQueue<M>
implements ActorQueue<M> {
    private static final L10N L = new L10N(AbstractActorQueue.class);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean offer(M value) {
        return this.offer(value, 0L, TimeUnit.SECONDS);
    }

    @Override
    public boolean offer(M value, long timeout, TimeUnit unit) {
        return this.offer(value, timeout, unit, 0);
    }

    @Override
    public boolean offer(M value, long timeout, TimeUnit unit, int reservedSpace) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void put(M value) throws InterruptedException {
        this.offer(value, (long)Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public boolean add(M value) {
        if (!this.offer(value)) {
            throw new IllegalStateException(L.l("No space in queue {0}", (Object)this));
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends M> c) {
        for (M item : c) {
            if (this.add(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public M peek() {
        return null;
    }

    @Override
    public M element() {
        M value = this.peek();
        if (value == null) {
            throw new IllegalStateException(L.l("No value available for {0}", (Object)this));
        }
        return value;
    }

    @Override
    public M poll(long timeout, TimeUnit unit) {
        return null;
    }

    @Override
    public M poll() {
        return this.poll(0L, TimeUnit.SECONDS);
    }

    @Override
    public M remove() {
        M value = this.poll();
        if (value == null) {
            throw new IllegalStateException(L.l("No value available for {0}", (Object)this));
        }
        return null;
    }

    @Override
    public M take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int drainTo(Collection<? super M> c) {
        return 0;
    }

    @Override
    public int drainTo(Collection<? super M> collection, int maxElements) {
        return 0;
    }

    @Override
    public Iterator<M> iterator() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : this.toArray()) {
            list.add(item);
        }
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        return this.toArray((X[])array);
    }

    @Override
    public <X> X[] toArray(X[] a) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object value : c) {
            if (this.remove(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

