/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class ByteBuffer {
    private byte[] _buffer;
    private int _capacity;
    private int _length;

    public ByteBuffer(int minimumCapacity) {
        this._capacity = 32;
        if (minimumCapacity > 4096) {
            this._capacity = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this._capacity < minimumCapacity) {
                this._capacity += this._capacity;
            }
        }
        this._buffer = new byte[minimumCapacity];
        this._length = 0;
    }

    public ByteBuffer() {
        this._buffer = new byte[32];
        this._capacity = this._buffer.length;
        this._length = 0;
    }

    public int capacity() {
        return this._capacity;
    }

    public int hashCode() {
        int hash = 17;
        for (int i = this._length - 1; i >= 0; --i) {
            hash = 65537 * hash + this._buffer[i];
        }
        return hash;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this._capacity) {
            return;
        }
        if (minimumCapacity > 4096) {
            this._capacity = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this._capacity < minimumCapacity) {
                this._capacity += this._capacity;
            }
        }
        byte[] bytes = new byte[this._capacity];
        System.arraycopy(this._buffer, 0, bytes, 0, this._length);
        this._buffer = bytes;
    }

    public int length() {
        return this._length;
    }

    public int size() {
        return this._length;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int len) {
        if (len < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (len > this._capacity) {
            this.ensureCapacity(len);
        }
        this._length = len;
    }

    public void clear() {
        this._length = 0;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public void append(int b) {
        if (this._length + 1 > this._capacity) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)b;
    }

    public void add(int i, byte[] buffer, int offset, int length) {
        if (this._length + length > this._capacity) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(this._buffer, i, this._buffer, i + length, this._length - i);
        System.arraycopy(buffer, offset, this._buffer, i, length);
        this._length += length;
    }

    public void add(byte[] buffer, int offset, int length) {
        if (this._capacity < this._length + length) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(buffer, offset, this._buffer, this._length, length);
        this._length += length;
    }

    public void add(int i, int data) {
        if (this._length + 1 > this._capacity) {
            this.ensureCapacity(this._length + 1);
        }
        System.arraycopy(this._buffer, i, this._buffer, i + 1, this._length - i);
        this._buffer[i] = (byte)data;
        ++this._length;
    }

    public void add(int data) {
        if (this._capacity < this._length + 1) {
            this.ensureCapacity(this._length + 1);
        }
        this._buffer[this._length++] = (byte)data;
    }

    public void set(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this._buffer, i, length);
    }

    public void set(int i, int data) {
        this._buffer[i] = (byte)data;
    }

    public void insert(int i, byte[] buffer, int offset, int length) {
        if (this._length + length > this._capacity) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(this._buffer, i, this._buffer, i + length, this._length - i);
        System.arraycopy(this._buffer, offset, this._buffer, i, length);
        this._length += length;
    }

    public void replace(int i, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this._buffer, i, length);
    }

    public void append(byte[] buffer, int offset, int length) {
        if (this._length + length >= this._capacity) {
            this.ensureCapacity(this._length + length);
        }
        System.arraycopy(buffer, offset, this._buffer, this._length, length);
        this._length += length;
    }

    public void addByte(int v) {
        this.add(v);
    }

    public void replaceShort(int i, int s) {
        this._buffer[i] = (byte)(s >> 8);
        this._buffer[i + 1] = (byte)s;
    }

    public void appendShort(int s) {
        if (this._length + 2 > this._capacity) {
            this.ensureCapacity(this._length + 2);
        }
        this.replaceShort(this._length, s);
        this._length += 2;
    }

    public void addShort(int s) {
        if (this._length + 2 > this._capacity) {
            this.ensureCapacity(this._length + 2);
        }
        this._buffer[this._length++] = (byte)(s >> 8);
        this._buffer[this._length++] = (byte)s;
    }

    public void addShort(int i, int s) {
        this.add(i, (byte)(s >> 8));
        this.add(i + 1, (byte)s);
    }

    public void setShort(int i, int s) {
        this._buffer[i] = (byte)(s >> 8);
        this._buffer[i + 1] = (byte)s;
    }

    public void replaceInt(int i, int v) {
        this._buffer[i] = (byte)(v >> 24);
        this._buffer[i + 1] = (byte)(v >> 16);
        this._buffer[i + 2] = (byte)(v >> 8);
        this._buffer[i + 3] = (byte)v;
    }

    public void appendInt(int s) {
        if (this._length + 4 > this._capacity) {
            this.ensureCapacity(this._length + 4);
        }
        this._buffer[this._length++] = (byte)(s >> 24);
        this._buffer[this._length++] = (byte)(s >> 16);
        this._buffer[this._length++] = (byte)(s >> 8);
        this._buffer[this._length++] = (byte)s;
    }

    public void addInt(int s) {
        if (this._capacity < this._length + 4) {
            this.ensureCapacity(this._length + 4);
        }
        this._buffer[this._length++] = (byte)(s >> 24);
        this._buffer[this._length++] = (byte)(s >> 16);
        this._buffer[this._length++] = (byte)(s >> 8);
        this._buffer[this._length++] = (byte)s;
    }

    public void addInt(int i, int s) {
        this.add(i + 0, (byte)(s >> 24));
        this.add(i + 1, (byte)(s >> 16));
        this.add(i + 2, (byte)(s >> 8));
        this.add(i + 3, (byte)s);
    }

    public void setInt(int i, int v) {
        this._buffer[i] = (byte)(v >> 24);
        this._buffer[i + 1] = (byte)(v >> 16);
        this._buffer[i + 2] = (byte)(v >> 8);
        this._buffer[i + 3] = (byte)v;
    }

    public void addLong(long v) {
        if (this._length + 8 > this._capacity) {
            this.ensureCapacity(this._length + 8);
        }
        this._buffer[this._length++] = (byte)(v >> 56);
        this._buffer[this._length++] = (byte)(v >> 48);
        this._buffer[this._length++] = (byte)(v >> 40);
        this._buffer[this._length++] = (byte)(v >> 32);
        this._buffer[this._length++] = (byte)(v >> 24);
        this._buffer[this._length++] = (byte)(v >> 16);
        this._buffer[this._length++] = (byte)(v >> 8);
        this._buffer[this._length++] = (byte)v;
    }

    public void addFloat(float v) {
        if (this._length + 4 > this._capacity) {
            this.ensureCapacity(this._length + 4);
        }
        int bits = Float.floatToIntBits(v);
        this._buffer[this._length++] = (byte)(bits >> 24);
        this._buffer[this._length++] = (byte)(bits >> 16);
        this._buffer[this._length++] = (byte)(bits >> 8);
        this._buffer[this._length++] = (byte)bits;
    }

    public void addDouble(double v) {
        if (this._length + 8 > this._capacity) {
            this.ensureCapacity(this._length + 8);
        }
        long bits = Double.doubleToLongBits(v);
        this._buffer[this._length++] = (byte)(bits >> 56);
        this._buffer[this._length++] = (byte)(bits >> 48);
        this._buffer[this._length++] = (byte)(bits >> 40);
        this._buffer[this._length++] = (byte)(bits >> 32);
        this._buffer[this._length++] = (byte)(bits >> 24);
        this._buffer[this._length++] = (byte)(bits >> 16);
        this._buffer[this._length++] = (byte)(bits >> 8);
        this._buffer[this._length++] = (byte)bits;
    }

    public void addString(String s) {
        int len = s.length();
        if (len + this._length > this._capacity) {
            this.ensureCapacity(this._length + len);
        }
        for (int i = 0; i < len; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
    }

    public void addString(String s, String encoding) {
        if (encoding == null || encoding.equals("ISO-8859-1")) {
            this.addString(s);
            return;
        }
        byte[] bytes = null;
        try {
            bytes = s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.addString(s);
            return;
        }
        int len = bytes.length;
        if (len + this._length > this._capacity) {
            this.ensureCapacity(this._length + len);
        }
        for (int i = 0; i < len; ++i) {
            this._buffer[this._length++] = bytes[i];
        }
    }

    public void add(String s) {
        int len = s.length();
        if (len + this._length > this._capacity) {
            this.ensureCapacity(this._length + len);
        }
        for (int i = 0; i < len; ++i) {
            this._buffer[this._length++] = (byte)s.charAt(i);
        }
    }

    public void add(char[] s, int offset, int len) {
        if (len + this._length > this._capacity) {
            this.ensureCapacity(this._length + len);
        }
        for (int i = 0; i < len; ++i) {
            this._buffer[this._length++] = (byte)s[offset + i];
        }
    }

    public void add(CharBuffer cb) {
        int len = cb.length();
        if (len + this._length > this._capacity) {
            this.ensureCapacity(this._length + len);
        }
        char[] s = cb.getBuffer();
        for (int i = 0; i < len; ++i) {
            this._buffer[this._length++] = (byte)s[i];
        }
    }

    public void remove(int begin, int length) {
        System.arraycopy(this._buffer, begin + length, this._buffer, begin, this._capacity - length - begin);
        this._length -= length;
    }

    public void append(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.append(string.charAt(i));
        }
    }

    public byte byteAt(int i) {
        if (i < 0 || i > this._length) {
            throw new RuntimeException();
        }
        return this._buffer[i];
    }

    public void setByteAt(int i, int b) {
        this._buffer[i] = (byte)b;
    }

    public byte get(int i) {
        if (i < 0 || i >= this._length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this._length);
        }
        return this._buffer[i];
    }

    public short getShort(int i) {
        if (i < 0 || i + 1 >= this._length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this._length);
        }
        return (short)(((this._buffer[i] & 0xFF) << 8) + (this._buffer[i + 1] & 0xFF));
    }

    public int getInt(int i) {
        if (i < 0 || i + 3 >= this._length) {
            throw new RuntimeException("out of bounds: " + i + " len: " + this._length);
        }
        return ((this._buffer[i + 0] & 0xFF) << 24) + ((this._buffer[i + 1] & 0xFF) << 16) + ((this._buffer[i + 2] & 0xFF) << 8) + (this._buffer[i + 3] & 0xFF);
    }

    public void print(int i) {
        if (this._length + 16 >= this._capacity) {
            this.ensureCapacity(this._length + 16);
        }
        if (i < 0) {
            this._buffer[this._length++] = 45;
            i = -i;
        } else if (i == 0) {
            this._buffer[this._length++] = 48;
            return;
        }
        int start = this._length;
        while (i > 0) {
            this._buffer[this._length++] = (byte)(i % 10 + 48);
            i /= 10;
        }
        for (int j = (this._length - start) / 2; j > 0; --j) {
            byte temp = this._buffer[this._length - j];
            this._buffer[this._length - j] = this._buffer[start + j - 1];
            this._buffer[start + j - 1] = temp;
        }
    }

    public int indexOf(byte[] buffer, int offset, int length) {
        if (length <= 0) {
            return -1;
        }
        int end = this._length - length;
        byte first = buffer[offset];
        byte[] testBuffer = this._buffer;
        for (int i = 0; i <= end; ++i) {
            int j;
            if (testBuffer[i] != first) continue;
            for (j = length - 1; j > 0 && testBuffer[i + j] == buffer[offset + j]; --j) {
            }
            if (j != 0) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        ByteBuffer newBuffer = new ByteBuffer(this._length);
        System.arraycopy(this._buffer, 0, newBuffer._buffer, 0, this._length);
        return newBuffer;
    }

    public boolean equals(Object b) {
        if (!(b instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer bb = (ByteBuffer)b;
        if (bb._length != this._length) {
            return false;
        }
        for (int i = this._length - 1; i >= 0; --i) {
            if (bb._buffer[i] == this._buffer[i]) continue;
            return false;
        }
        return true;
    }

    public InputStream createInputStream() {
        return new BBInputStream(this);
    }

    public OutputStream createOutputStream() {
        return new BBOutputStream(this);
    }

    public ReadStream createReadStream() {
        return VfsStream.openRead(new BBInputStream(this));
    }

    public byte[] getByteArray() {
        byte[] bytes = new byte[this._length];
        System.arraycopy(this._buffer, 0, bytes, 0, this._length);
        return bytes;
    }

    public String toString() {
        try {
            return new String(this._buffer, 0, this._length, "iso-8859-1");
        }
        catch (Exception e) {
            return new String(this._buffer, 0, this._length);
        }
    }

    public String toString(String encoding) {
        try {
            return new String(this._buffer, 0, this._length, encoding);
        }
        catch (Exception e) {
            return new String(this._buffer, 0, this._length);
        }
    }

    static class BBOutputStream
    extends OutputStream {
        ByteBuffer _buf;

        @Override
        public void write(int ch) throws IOException {
            this._buf.append(ch);
        }

        BBOutputStream(ByteBuffer buf) {
            this._buf = buf;
        }
    }

    static class BBInputStream
    extends InputStream {
        ByteBuffer _buf;
        int _index;

        @Override
        public int available() {
            return this._buf._length - this._index;
        }

        @Override
        public int read() throws IOException {
            if (this._index >= this._buf._length) {
                return -1;
            }
            return this._buf._buffer[this._index++] & 0xFF;
        }

        BBInputStream(ByteBuffer buf) {
            this._buf = buf;
        }
    }
}

