/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;

public class CurrentTime {
    private static Logger _log;
    private static final CurrentTimeThread _currentTimeThread;
    private static volatile long _currentTime;
    private static volatile boolean _isCurrentTimeUsed;
    private static volatile boolean _isSlowTime;
    private static final boolean _isStressTest;
    private static long _testTime;
    private static long _testNanoDelta;

    private CurrentTime() {
    }

    public static boolean isActive() {
        return _testTime == 0L && _currentTimeThread != null;
    }

    public static long getCurrentTime() {
        if (_testTime > 0L) {
            return _testTime;
        }
        return System.currentTimeMillis();
    }

    public static long getCurrentTimeActual() {
        if (_testTime > 0L) {
            return System.currentTimeMillis();
        }
        return CurrentTime.getCurrentTime();
    }

    public static long getExactTime() {
        if (_testTime > 0L) {
            return _testTime;
        }
        return System.currentTimeMillis();
    }

    public static long getExactTimeNanoseconds() {
        if (_testTime > 0L) {
            return (_testTime - 10000000L) * 1000000L + _testNanoDelta;
        }
        return System.nanoTime();
    }

    public static boolean isTest() {
        return _testTime > 0L;
    }

    public static void yieldIfTest() {
        if (_testTime > 0L) {
            // empty if block
        }
    }

    static void setTestTime(long time) {
        _testTime = time;
        if (_testTime > 0L) {
            if (time < _currentTime) {
                Alarm.testClear();
            }
            _currentTime = time;
        } else {
            _currentTime = System.currentTimeMillis();
        }
        Alarm.setAlarmTestTime(time);
    }

    static void testClear() {
        Alarm.testClear();
    }

    static void setTestNanoDelta(long delta) {
        _testNanoDelta = delta;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(CurrentTime.class.getName());
        }
        return _log;
    }

    static {
        _currentTime = System.currentTimeMillis();
        ClassLoader systemLoader = null;
        Object currentTimeThread = null;
        ClassLoader loader = CurrentTime.class.getClassLoader();
        try {
            systemLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        currentTimeThread = null;
        _currentTimeThread = currentTimeThread;
        _isStressTest = System.getProperty("caucho.stress.test") != null;
    }

    static class CurrentTimeThread
    extends Thread {
        CurrentTimeThread() {
            super("resin-timer");
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            int idleCount = 0;
            while (true) {
                try {
                    while (true) {
                        if (_testTime > 0L) {
                            _currentTime = _testTime;
                            LockSupport.park();
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        _currentTime = now;
                        boolean isCurrentTimeUsed = _isCurrentTimeUsed;
                        _isCurrentTimeUsed = false;
                        if (isCurrentTimeUsed) {
                            idleCount = 0;
                            _isSlowTime = false;
                        } else if (++idleCount >= 10) {
                            _isSlowTime = true;
                        }
                        if (_isSlowTime) {
                            long sleepTime = 1000L;
                            LockSupport.parkNanos(sleepTime * 1000000L);
                            continue;
                        }
                        Thread.sleep(20L);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

