/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.FreeRing;
import com.caucho.util.FreeRingSoft;

public final class FreeRingDual<T> {
    private final FreeRing<T> _freeRing;
    private final FreeRingSoft<T> _freeRingSoft;

    public FreeRingDual(int capacity, int softCapacity) {
        this._freeRing = new FreeRing(capacity);
        this._freeRingSoft = new FreeRingSoft(capacity);
    }

    public int getSize() {
        return this._freeRing.getSize() + this._freeRingSoft.getSize();
    }

    public long getHead() {
        return this._freeRing.getHead();
    }

    public long getHeadAlloc() {
        return this._freeRing.getHeadAlloc();
    }

    public long getTail() {
        return this._freeRing.getTail();
    }

    public long getTailAlloc() {
        return this._freeRing.getTailAlloc();
    }

    public T allocate() {
        T value = this._freeRing.allocate();
        if (value != null) {
            return value;
        }
        return this._freeRingSoft.allocate();
    }

    public boolean free(T value) {
        if (this._freeRing.free(value)) {
            return true;
        }
        return this._freeRingSoft.free(value);
    }

    public boolean freeCareful(T value) {
        if (this.checkDuplicate(value)) {
            throw new IllegalStateException("tried to free object twice: " + value);
        }
        return this.free(value);
    }

    public boolean checkDuplicate(T obj) {
        return false;
    }
}

