/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class StreamSource {
    private static final Logger log = Logger.getLogger(StreamSource.class.getName());
    private static final L10N L = new L10N(StreamSource.class);
    private TempOutputStream _out;
    private StreamSource _indirectSource;

    protected StreamSource() {
    }

    public StreamSource(TempOutputStream os) {
        this._out = os;
    }

    public StreamSource(StreamSource indirectSource) {
        this._indirectSource = indirectSource;
    }

    public InputStream getInputStream() throws IOException {
        if (this._indirectSource != null) {
            return this._indirectSource.getInputStream();
        }
        if (this._out != null) {
            return this._out.openInputStream();
        }
        log.fine(L.l("{0}: no input stream is available", (Object)this));
        return null;
    }

    public InputStream openInputStream() throws IOException {
        if (this._indirectSource != null) {
            return this._indirectSource.openInputStream();
        }
        if (this._out != null) {
            return this._out.openInputStreamNoFree();
        }
        log.fine(L.l("{0}: no input stream is available", (Object)this));
        return null;
    }

    public void close() {
        TempOutputStream out = this._out;
        this._out = null;
        StreamSource ss = this._indirectSource;
        this._indirectSource = null;
        if (out != null) {
            out.destroy();
        }
        if (ss != null) {
            ss.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._out + "," + this._indirectSource + "]";
    }
}

